<?php
/*
 * Version 0.1.0 (changelog in the bottom of the file)
 * maintained by Morten Poulsen (nick: Silmarillion) <morten@poulsen.org>
 *
 *
 * This file overrides some of the settings in config.php to a more dynamic
 * autodetection version.
 * This has 2 main advantages:
 *   1. the whole site can be moved from one dir to another without editing
 *      config.php manually
 *   2. the site can have multiple alias-urls, for instance both mysite.com
 *      and www.mysite.com and www.mysitealias.com at the same time without
 *      the name being reset to a hardcoded one.
 *
 * It has some disadvantages also, though
 *   - using alternative tmp, images, admin dirs may presently have strange
 *     consequences
 *   - as the autodetection routines are somewhat system-dependent I may
 *     not be able to test on every system in the world, so please try it
 *     out thouroughly before using on a production site.
 *
 * Installation
 * ************
 * 1. Put this file in you site root
 * 2. Insert this line at the bottom of you config.php just before ?>
 *    require_once(dirname(__FILE__)."/dynapaths.php");
 *
 * Uninstallation
 * **************
 * 1. remove the require_once line from the bottom of config.php
 * 2. optionally remove the dynapaths.php from your site root
 *  */

$debugmode=isset($_GET["debugmode"]);

//Force debugmode
//$debugmode=true;

if ($debugmode) {
  echo "<strong>Relevant PHP-vars:</strong><br/>";
  echo "<table>";
  echo "<tr><td>dirname(__FILE__)</td><td>".dirname(__FILE__)."</td></tr>";
  echo "<tr><td>\$_SERVER['HTTP_HOST']</td><td>".$_SERVER['HTTP_HOST']."</td></tr>";
  echo "<tr><td>\$_SERVER['REQUEST_URI']</td><td>".$_SERVER['REQUEST_URI']."</td></tr>";
  echo "<tr><td>\$_SERVER['SCRIPT_NAME']</td><td>".$_SERVER['SCRIPT_NAME']."</td></tr>";
  echo "</table><br/><br/>";
}

$urlserver="http://".$_SERVER['HTTP_HOST'];
$urldir=$_SERVER['SCRIPT_NAME'];
$pos=strrpos($urldir,"/");
if ($pos!==false) {
  $urldir=substr($urldir,0,$pos);
}

//Collecting the url
$config['root_url']=$urlserver.$urldir;

//Removing admin part
$config['root_url']=str_replace('/'.$config['admin_dir'],'',$config['root_url']);

$config['uploads_url'] = $config['root_url'] . '/uploads';
$config['image_uploads_url'] = $config['root_url'] . '/uploads/images';

$config['root_path']=dirname(__FILE__);

//This removes part of the path if dynapaths is located in modules/dynapaths
//and symlinked to root... like on my testsystem...
if (strpos($config['root_path'],'/modules/dynapaths')!==false) {
  $config['root_path']=str_replace('/modules/dynapaths','',$config['root_path']);
}

//This part removes the admin-dir from the path, it's added in the system, so it should
//not be present here
if (strpos($config['root_path'],$config['admin_dir'].'/'.$config['admin_dir'])!==false) {
  $config['root_path']=str_replace($config['admin_dir'].'/','',$config['root_path']);
}


$config['image_uploads_path'] = $config['root_path'].'/uploads/images';
$config['uploads_path'] = $config['root_path'].'/uploads';
$config['previews_path'] = $config['root_path'].'/tmp/cache';

if ($debugmode) {
  echo "<strong>Resulting in these new configvars:</strong><br/>";
  echo "<table>";
  echo "<tr><td>\$config['root_url']</td><td>".$config['root_url']."</td></tr>";
  echo "<tr><td>\$config['root_path']</td><td>".$config['root_path']."</td></tr>";
  //echo "<tr><td>\$_SERVER['REQUEST_URI']</td><td>".$_SERVER['REQUEST_URI']."</td></tr>";
  //echo "<tr><td>\$_SERVER['SCRIPT_NAME']</td><td>".$_SERVER['SCRIPT_NAME']."</td></tr>";
  echo "</table>";
}
if ($debugmode) {
  die();
}

/*
 * Changelog
 * *********
 * 0.1.0 - Initial release doing it's job (for me a least)
 *
 *
 *
 */

?>
