<?php
$lang['modulename'] = 'Licznik Ściągnięć (Download Counter)';
$lang['help'] = '
<h3>Co to robi?</h3>
<p>Licznik Ściągnięć jest bardzo prostym modułem w formie znacznika. Służy on do liczenia ściągnięć plików, które udostępniasz na swojej stronie.<br />
Moduł ten nie polega na module Uploads, ani na żadnym innym. Możesz używać go do jakichkolwiek plików, nieważne w jaki sposób znalazły się na serwerze. Nawet lepiej: możesz używać tego modułu do liczenia kliknięć <b>jakichkolwiek</b> linków na Twojej stronie!
</p>

<h3>Jak tego używać?</h3>
<p>Licznik Ściągnięć to moduł w formie znacznika. Można go wstawić do szablonu strony za pomocą znacznika cms_module. Przykładowa składnia mogłaby wyglądać następująco:<br />
<code>{cms_module module=\'DownCnt\' name=\'nazwa_licznika\' link=\'http://docelowastrona.com\'}</code> - w celu licznia kliknięć, oraz<br />
<code>(cms_module module=\'DownCnt\' name=\'nazwa_licznika\' action=\'display\'}</code> - w celu wyświetlania stanu licznika.</p>
<p>Nie zapomnij ustawić uprawnienia \'Manage Download Counters\' dla użytkowników , którzy będą administrować licznikami.</p>

<h3>Parametry</h3>
<ul>
<li><i>action</i> - akcja do wykonania w aktualnym znaczniku. Możliwe wartości:
  <ul>
    <li><i>default</i> - ten znacznik będzie wykonywał zliczanie; aby działał prawidłowo powinien być umieszczony zamiast adresu docelowego znacznika &lt;A&gt; (html) (na przykład: &lt;A HREF={cms_module module=\'DownCnt\'...); nie używaj żadnych znaków cytowania dookoła znacznika, inaczej mogą wystąpić problemy; parametry <i>name</i> i <i>link</i> są wymagane dla tej akcji;</li>
    <li><i>display</i> - ten znacznik tylko wyświetli licznik dla podanej nazwy; parametr <i>name</i> jest wymagany dla tej akcji;</li>
  </ul>
<li><i>name</i> - nazwa licznika, który ma być użyty; nazwa może być dowolnym tekstem (na przykład nazwą pliku), ale powinna być unikalna w obrębie instalacji CMS;nazwa jest identyfikatorem, według którego moduł rozróżnia poszczególne liczniki; nazwa nie może być dłuższa niż 255 znaków!</li>
<li><i>link</i> - wymagany tylko jeśli <i>action</i>=\'default\'; wstaw tutaj link do docelowego zasobu - link, który notmalnie byłby użyty jako HREF w znaczniku &lt;A&gt;; ścieżka jest względna według katalogu instalacji CMS MS; do linków zewnętrznych musi być podany pełny adres, <b>włączając przedrostek http://</b>.</li>
</ul>

<p>Aby wyświetlić licznik do linku za właściwym linkiem, należy użyć znacznika dwukrotnie - raz z domyślną akcją <i>action</i> (parametr <i>action</i> może być w tym przypadku pominięty) i drugi raz z <i>action</i>=\'show\', przy czym oba znaczniki muszą mieć taką samą wartość parametru <i>name</i>.</p>

<h3>Przykłady</h3>
<h4>Tworzenie linku do strony lub pliku do ściągnięcia, który będzie zliczał kliknięcia:</h4>
<p>Jeśli Twój link wygląda tak<br />
<br />
<code>&lt;A HREF="/downloads/plik.zip"&gt;ściągnij ten plik&lt;/A&gt;</code> lub<br />
<code>&lt;A HREF="http://jakasstrona.com"&gt;idź do strony&lt;/A&gt;</code><br />
<br />
to aby dodać zliczanie kliknięć, musisz go przerobić odpowiednio na<br />
<br />
<code>&lt;A HREF={cms_module module=\'DownCnt\' name=\'plik\' link=\'/downloads/plik.zip\'}&gt;ściągnij ten plik&lt;/A&gt;</code> lub<br />
<code>&lt;A HREF={cms_module module=\'DownCnt\' name=\'plik\' link=\'http://jakasstrona.com\'}&gt;idź do strony&lt;/A&gt;</code>.<br />
<br />
Zwróć uwagę, że nie ma znaków cytowania dookoła znacznika. Jest to ważne, żeby ich nie dodawać, ponieważ znacznik zwraca zmodyfikowany link z już dodanymi znakami cytowania.<br />
<br />
Inne parametry znacznika &lt;A&gt;, jak TARGET, mogą być używane bez przeszkód.</p>

<h4>Wyświetlanie licznika kliknięć:</h4>
<p>Niezależnie czy link prowadzi do strony, czy do pliku, metoda wyświetlenia jego licznika jest jedna:<br />
<br />
<code>{cms_module module=\'DownCnt\' action=\'show\' name=\'plik\'}</code><br />
<br />
W parametrze <i>name</i> należy podać nazwę użytą w odpowiadającym znaczniku w linku.<br />
Znacznik ten wyświetli zwykłą liczbę całkowitą, która będzie wartością licznika. Możesz ją otoczyć jakimikolwiek znacznikami w celu zmodyfikowania jej wyglądu.<br />
Jeśli link nie został nigdy kliknięty (jego licznik jeszcze nie istnieje) powyższy znacznik wyświetli zero.</p>

<h3>Część administracyjna</h3>
<p>Istniejącymi licznikami można zarządzać z części administracyjnej CMS MS. Przejdź do menu Treść (Content) i wybierz Licznik Ściągnięć (Download Counter).</p>
<p>Jeśli chcesz wyzerować jakiś licznik, po prostu go usuń. Zostanie on utworzony automatycznie przy następnym kliknięciu linku.</p>
<p>Kolumna <i>Aktywny</i> mówi czy licznik powinien być zwiększany, czy nie. Jeśli licznik jest wyłączony (nie Aktywny) link będzie ciągle działał i będzie dało się wyświetlić wartość licznika, ale wartość ta nie będzie zwiększana przy klikaniu.</p>
';

$lang['description'] = 'Moduł Licznik Ściągnięć umożliwia zliczanie ściągnięć plików, które udostępniasz na swojej stronie.';
$lang['postinstall'] = 'Nie zapomnij ustawić uprawnienia <b>\'Manage Download Counters\'</b> dla użytkowników, którzy będą zarządzać licznikami.<br />
Informacje o sposobie użycia modułu znajdują się w pomocy.';
$lang['pre_uninstall'] = 'Wszystkie liczniki zostaną usunięte. Czy chcesz odinstalować ten moduł?';
$lang['uninstalled'] = 'Moduł został odinstalowany.';
$lang['installed'] = 'Wersja %s modułu została zainstalowana.';
$lang['nameunspec'] = 'Wymagany parametr name nie został zdefiniowany!';
$lang['error_insufficientparams'] = 'Wymagany parametr nie został zdefiniowany: %s';
$lang['nocountersfound'] = 'Nie ma jeszcze żadnych liczników.<br />
Aby utworzyć licznik wstaw znacznik modułu na dowolną stronę (zajrzyj do pomocy tego modułu aby dowiedzieć się, jak to zrobić) - nowy licznik zostanie utworzony automatycznie przy pierwszym kliknięciu w link.';
$lang['delete'] = 'Usuń';
$lang['areyousure'] = 'Usunąć licznik?';
$lang['areyousure2'] = 'Usunąć liczniki?';
$lang['name'] = 'Nazwa licznika';
$lang['value'] = 'Stan licznika';
$lang['lastdate'] = 'Data ostaniego kliknięcia';
$lang['active'] = 'Aktywny';
$lang['delselected'] = 'Usuń zaznaczone liczniki';
$lang['needpermission'] = 'Musisz posiadać uprawnienie \'%s\' aby wykonać tę funkcję.';
$lang['error_no_id'] = 'Błąd wewnętrzny: id nie został zdfiniowany';
$lang['param_action'] = 'akcja do wykonania w aktualnym znaczniku. \'<i>default</i>\': zliczanie kliknięć, \'<i>display</i>\': wyświetlanie stanu licznika.';
$lang['param_name'] = 'nazwa licznika, służąca do rozróżniania poszczególnych liczników.';
$lang['param_link'] = 'link do zasobu docelowego.';

?>
