/* Support for DecisionTree Module */
function setVisibilty(id,setting)
	{
    var elem = document.getElementById(id);
    if (elem)
		{
		elem.style.display=setting;
		}
	}

function hide(id)
	{
	setVisibilty(id,"none");
	}

function show(id)
	{
	setVisibilty(id,"");
	}

function update_dec(ldepth)
	{
	hide('results');
	hide('alternate');
	hide('suggestion');
	for (i=(ldepth+1);i<max_depth;i++)
		{
		resetSelect('dts_'+i);
		hide('dts_'+i);
		}
	sel = -1;
	if (ldepth > -1)
		{
		sel = getSelectionValue('dts_'+ldepth);
		}
	depth = ldepth + 1;
	loadXMLDoc(base_url.replace('DID',sel), populate_next);	
	}
	
function populate_next(datareq)
	{
	// only if req shows "loaded"
	if (datareq.readyState == 4)
		{
		// only if "OK"
		if (datareq.status == 200) 
			{
			subdec = datareq.responseXML.getElementsByTagName('decision');
			if (subdec.length == 0)
				{
				sel = getSelectionValue('dts_'+(depth-1));
				loadXMLDoc(base_url.replace('DID',sel).replace('get_dec','get_outcome'), populate_last);	
				}
			else
				{
				populateFromDOM('dts_'+depth, subdec);
				show('dts_'+depth);
				}
			} 
		else
			{
			alert("There was a problem retrieving the XML data:\n" + datareq.statusText);
			}
		}
	}

function populate_last(datareq)
	{
	req = datareq;

	// only if req shows "loaded"
	if (req.readyState == 4)
		{
		// only if "OK"
		if (req.status == 200) 
			{
			subdec = req.responseXML.getElementsByTagName('decision');
			var returns = subdec[0].getElementsByTagName('returns')[0].childNodes[0].data;
			if (returns && returns != '')
				{
				fillElement('results_val',returns);
				show('results');
				}
			var alt = subdec[0].getElementsByTagName('alternate')[0].childNodes[0].data;
			if (alt && alt != '')
				{
				fillElement('alternate_val',alt);
				show('alternate');
				}
			var sug = subdec[0].getElementsByTagName('suggestion')[0].childNodes[0].data;
			if (sug && sug != '')
				{
				fillElement('suggestion_val',sug);
				show('suggestion');
				}
			} 
		else
			{
			alert("There was a problem retrieving the XML data:\n" + req.statusText);
			}
		}
	}

function fillElement(id,string)
	{
	var item = document.getElementById(id);
	if (item)
		{
		item.innerHTML = string;
		}
	}
	
function appendToSelect(select, value, content, selected)
	{
    var opt;
    opt = document.createElement("option");
	if (selected)
		opt.selected = "true";
    opt.value = value;
    opt.appendChild(document.createTextNode(content));
    select.appendChild(opt);
	}

function getSelectionText(id)
	{
    var select = document.getElementById(id);
	if (select.selectedIndex >= 0)
		return select.options[select.selectedIndex].text;
	return "";
	}

function getSelectionValue(id)
	{
	var select = document.getElementById(id);
	return select.options[select.selectedIndex].value;
	}

function resetSelect(id)
	{
    var sel = document.getElementById(id);
	while (typeof(sel.length) != "undefined" && sel.length > 0)
		{
		try {
			sel.remove(0);
			} catch (IEBug)
				{
				}
    	}
	}

function resetRadio(id)
{
	setRadio(formFields[id]["radioname"], -1);
	formFields[id]["filled"] = 0;
}

function populateFromDOM(id, dom)
{
	//console.debug(dom);
    var select = document.getElementById(id);
    for (var i = 0; i < dom.length; i++) 
	{
       if (i == 0)
          {
          var prompt = dom[i].getElementsByTagName('prompt');
          if (prompt && prompt.length > 0)
              {
              appendToSelect(select,'',prompt[0].childNodes[0].data);
              }
          else
              {
              appendToSelect(select,'',dprompt);
              }
          }
        appendToSelect(select, dom[i].getElementsByTagName('decision_id')[0].childNodes[0].data,
			dom[i].getElementsByTagName('name')[0].childNodes[0].data);
    }
}

function loadXMLDoc(url, callback)
	{
	var the_var = null;
    if (window.XMLHttpRequest)
	{
        the_var = new XMLHttpRequest();
        the_var.onreadystatechange = function () {callback(the_var)};
        the_var.open("GET", url, true);
		// send referer header
		the_var.setRequestHeader("Referer", document.location);
        the_var.send(null);
    // branch for IE/Windows ActiveX version
    }
	else if (window.ActiveXObject) 
		{
        isIE = true;
        the_var = new ActiveXObject("Microsoft.XMLHTTP");
        if (the_var) 
			{
			the_var.onreadystatechange = function () {callback(the_var)};
            the_var.open("GET", url, true);
            the_var.send();
        	}
    	}
	return the_var;
	}

/* depth must be defined before we get here! */
update_dec(depth);