<?php
if (!isset($gCms)) exit;
if (! $this->CheckPermission('Modify Any Page')) {
  return $this->DisplayErrorPage($id, $params, $returnid,$this->Lang('accessdenied'));
}

$success = true;
$error = '';
$db = &$gCms->GetDB();
$max_depth = -1;
if (isset($_FILES[$id.'tree_file']['tmp_name']) && !empty($_FILES[$id.'tree_file']['tmp_name']))
   {
   
   // erase old one if requested
   if (isset($params['overwrite']) && $params['overwrite'] == 1)
      {
      $exist_query = 'select tree_id from '.cms_db_prefix().'module_dectree_trees where alias=?';
      $dres = $db->Execute($exist_query,array($params['tree_alias']));
   	if ($dres && $row=$dres->FetchRow())
   		{
   		$this->deleteTreeById($row['tree_id']);
   		}
      }
   $xml = file($_FILES[$id.'tree_file']['tmp_name']);
   $tree_id = $db->GenID(cms_db_prefix().'module_dectree_trees_seq');
   $tree_query = 'insert into '.cms_db_prefix().'module_dectree_trees (tree_id,alias,description) values (?,?,?)';
   $dec_query = 'insert into '.cms_db_prefix().
	'module_dectree_decs (decision_id,tree_id,parent_id,is_result,decision,returns,alternate,suggestion,prompt,order_by) '.
	'values (?,?,?,?,?,?,?,?,?,?)';

   $dres = $db->Execute($tree_query,array($tree_id,$params['tree_alias'],$params['tree_description']));
	if (! $dres)
		{
		$error = 'db_failed';
		$success = false;
		}
	else
		{
		$depth = 0;
		$parent = array();
		$line = 0;
		foreach ($xml as $tl)
			{
			$line += 1;
			if (preg_match('/<(\\\\)*decisions>/i',$tl))
				{
				// skip this
				}
			else if (preg_match('/<decision/i',$tl) && !preg_match('/return(s*)\s*=\s*\"([^"]+)"/i',$tl))
				{
				// opening decision
				if (!preg_match('/name\s*=\s*\"([^"]+)"/',$tl, $res))
					{
					echo $this->Lang('parse_decision_name',$line);
					$error = 'parse_failed';
					$success = false;
					}
				else
					{
					$name = $res[1];
					$prompt = '';
					if (preg_match('/prompt\s*=\s*\"([^"]+)"/',$tl, $res))
					    {
					    $prompt = $res[1];
					    }
					if (isset($parents[$depth]))
						{
						$pid = $parents[$depth];
						}
					else
						{
						$pid = -1;
						}
					$dec_id = $db->GenID(cms_db_prefix().'module_dectree_decs_seq');
					$dres = $db->Execute($dec_query,array($dec_id,$tree_id,$pid,'0',$name,'','','',$prompt,$line));
					}
				$depth += 1;
				if ($depth > $max_depth)
					{
					$max_depth = $depth;
					}
				$parents[$depth] = $dec_id;
				}
			else if (preg_match('/return(s*)\s*=\s*\"([^"]+)"/i',$tl))
				{
				// decision outcome
				$name = '';
				$returns = '';
				$suggestion = '';
				$alternate = '';
				$prompt = '';
				if (!preg_match('/name\s*=\s*\"([^"]+)"/i',$tl, $res))
					{
					echo $this->Lang('parse_outcome_name',$line);
					$error = 'parse_failed';
					$success = false;
					}
				$name = $res[1];
				if (!preg_match('/return(s*)\s*=\s*\"([^"]+)"/i',$tl, $res))
					{
					echo $this->Lang('parse_outcome_results',$line);
					$error = 'parse_failed';
					$success = false;
					}
				$returns = $res[2];
				if (preg_match('/suggestion\s*=\s*\"([^"]+)"/i',$tl, $res))
					{
					$suggestion = $res[1];
					}
				if (preg_match('/alternate\s*=\s*\"([^"]+)"/i',$tl, $res))
					{
					$alternate = $res[1];
					}
				if (preg_match('/prompt\s*=\s*\"([^"]+)"/',$tl, $res))
				    {
				    $prompt = $res[1];
				    }
				$outcome_id = $db->GenID(cms_db_prefix().'module_dectree_decs_seq');
				$dres = $db->Execute($dec_query,array($outcome_id,$tree_id,$dec_id,'1',
               $name,$returns,$alternate,$suggestion,$prompt,$line));
				}
			else
				{
				// closing decision
				$depth -= 1;
				}
			}			
		}
	/*
   $res = $this->parse_xml_to_database($xml);
   if ($res === false)
		{
		$error = 'parse_failed';
		}
   else
		{
		echo $params['tree_alias'].'<hr>';
		debug_display($res);
		//$this->recurse($res);
		}
*/
   }

if ($success)
	{
	$db->Execute('update '.cms_db_prefix().'module_dectree_trees set max_depth=? where tree_id=?',array($max_depth + 2,$tree_id));
	$params = array('tab_message'=> 'summary_imported', 'active_tab' => 'listing');
	}
else
	{
	$params = array('tab_message'=> $error, 'active_tab' => 'listing');
	}

$this->DoAction('defaultadmin', $id, $params, $returnid);
?>