<?php
#-------------------------------------------------------------------------
# Module: Decision Tree
# Version: 0.1, SjG
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2009 by Ted Kulp (ted@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/decisiontree/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class DecisionTree extends CMSModule
{
  
  function GetName()
  {
    return 'DecisionTree';
  }
  
  function GetFriendlyName()
  {
    return $this->Lang('friendlyname');
  }
  function GetVersion()
  {
    return '0.1.4';
  }
  function GetHelp()
  {
    return $this->Lang('help');
  }
  function GetAuthor()
  {
    return 'SjG';
  }
  function GetAuthorEmail()
  {
    return 'sjg@cmsmodules.com';
  }
  function GetChangeLog()
  {
    return $this->Lang('changelog');
  }
  function IsPluginModule()
  {
    return true;
  }
  function HasAdmin()
  {
    return true;
  }
  function GetAdminSection()
  {
    return 'content';
  }
  function GetAdminDescription()
  {
    return $this->Lang('moddescription');
  }
  function VisibleToAdminUser()
  {
    return $this->CheckPermission('Modify Any Page');
  }
  function GetDependencies()
  {
    return array();
  }
  function MinimumCMSVersion()
  {
    return "1.5";
  }
  function SetParameters()
  {
  $this->RegisterModulePlugin(); 
  $this->RestrictUnknownParams();
  
  $this->CreateParameter('tree','',$this->Lang('help_tree'));
  $this->SetParameterType('tree',CLEAN_STRING);
  $this->CreateParameter('tree_id','',$this->Lang('help_tree_id'));
  $this->SetParameterType('tree_id',CLEAN_INT);
  $this->CreateParameter('dec_id','',$this->Lang('help_dec_id'));
  $this->SetParameterType('dec_id',CLEAN_INT);
  }
  function InstallPostMessage()
  {
    return $this->Lang('postinstall');
  }
  function UninstallPostMessage()
  {
    return $this->Lang('postuninstall');
  }

  function deleteTreeById($tree_id)
  {
	global $gCms;
	$db = &$gCms->GetDb();
   $query = 'DELETE from '.cms_db_prefix().
      'module_dectree_decs where tree_id = ?';
   $result = $db->Execute($query,array($tree_id));
   $query = 'DELETE from '.cms_db_prefix().
      'module_dectree_trees where tree_id = ?';
   $result = $db->Execute($query,array($tree_id));
  }

  function emit_xml(&$params)
  {
	global $gCms;
	$db = &$gCms->GetDb();
	
	$xmlstr = '<?xml version="1.0"?>';
	$xmlstr .= "\n<decisions>\n";

	if (isset($params['final']))
		{
		$query = 'SELECT * from '.cms_db_prefix().
			'module_dectree_decs where decision_id=? and tree_id=?';
		}
	else
		{
		$query = 'SELECT * from '.cms_db_prefix().
			'module_dectree_decs where parent_id=? and tree_id=? order by order_by';
		}

	$result = $db->Execute($query,array($params['dec_id'],$params['tree_id']));
	while ($result !== false && $row=$result->FetchRow())
	   {
	   $xmlstr .= "<decision>\n";
	   $xmlstr .= "<name><![CDATA[".$row['decision']."]]></name>\n";
      if (!empty($row['prompt']))
         {
         $xmlstr .= "<prompt><![CDATA[".$row['prompt']."]]></prompt>\n";
         }
	   $xmlstr .= "<is_result>".$row['is_result']."</is_result>\n";
	   $xmlstr .= "<decision_id>".$row['decision_id']."</decision_id>\n";
	   $xmlstr .= "<returns><![CDATA[".$row['returns']."]]></returns>\n";
	   $xmlstr .= "<suggestion><![CDATA[".$row['suggestion']."]]></suggestion>\n";
	   $xmlstr .= "<alternate><![CDATA[".$row['alternate']."]]></alternate>\n";
	   $xmlstr .= "</decision>\n";
	   }
	$xmlstr .= '</decisions>';
	$this->SetContentType('text/xml');
	return $xmlstr;
  }

} //end class
?>
