<?php
if (!isset($gCms)) exit;

$this->AdminStyle('h3 {color:red}');

// Tabs
if (FALSE == empty($params['active_tab']))
{
  $tab = $params['active_tab'];
} else {
  $tab = '';
}

if ($this->CheckPermission('Use GoogleMaps'))
{

  if (isset($params['submit_general']))
    {
      $this->SetPreference("apikey", isset($params['apikey']) ? $params['apikey'] : '' );
      $this->SetPreference("usecache", isset($params['usecache']) ? '1' : '0' );
      $this->SetPreference("lookupservice", isset($params['lookupservice']) ? $params['lookupservice'] : 'YAHOO');
      $this->SetPreference("yahooapid", isset($params['yahooapid']) ? $params['yahooapid'] : $id);
      $this->SetPreference('usemarkershadows', isset($params['usemarkershadows']) ? '1' : '0' );
      echo '<div class="pagemcontainer"><p class="pagemessage">'.$this->Lang('settings_saved').'</p></div>';
    }

  if (isset($params['submit_address_query'])) {
    require_once('lib/GoogleMapAPI-'.$this->_googleapi_version.'/GoogleMapAPI.class.php');
    $query_map = new GoogleMapAPI(0, $this->GetPreference('yahooappid', '1234'));
    $query_map->setLookupService( $this->GetPreference('lookupservice', 'GOOGLE') );
    $geocode = $query_map->getGeocode($params['address']);
    if( $geocode === false )
      {
	echo $this->ShowErrors($this->Lang('e_badaddress'));
      }
    else
      {
	echo $this->ShowMessage($this->Lang('location_for').' <b>'. $params['address'] .'</b> '. $this->Lang('is').':<br/>
           <dl>
             <dt>'.$this->Lang('t_lan').':&nbsp;'.$geocode['lat'] .'</dt>
             <dt>'.$this->Lang('t_lon').':&nbsp;'.$geocode['lon'] .'</dd>
           </dl>');
      }
  }

  //tabs  
  echo $this->StartTabHeaders();
  echo $this->SetTabHeader('maps',$this->Lang('maps'), ('maps' == $tab)?true:false);
  echo $this->SetTabHeader('address',$this->Lang('query_address'), ('address' == $tab)?true:false);
  echo $this->SetTabHeader('settings',$this->Lang('settings'), ('settings' == $tab)?true:false);
  echo $this->EndTabHeaders();
  //end tabs

  //The content of the tabs
  echo $this->StartTabContent();
  
  // maps tab
  echo $this->StartTab('maps', $params);

  require_once ( 'lib/rcrud.inc.php' );
  $co = new rcrud( $db , cms_db_prefix().'module_googlemaps_maps' );
  //settings for rcrud
  $co->header = "Your maps";

  //field settings
  $co->fields['map_id']['label'] = $this->Lang('map_id');

  $co->fields['name']['label'] = $this->Lang('t_name');

  $co->fields['owner_id']['visible_in_edit'] = false;

  $co->fields['center_lat']['label'] = $this->Lang('center_lat');
  $co->fields['center_lon']['label'] = $this->Lang('center_lon');
  
  $co->fields['type']['field_type'] = "radio|map|satellite|hybrid";
  $co->fields['type']['label'] = $this->Lang('t_type');

  $co->fields['width']['label'] = $this->Lang('t_width');
  $co->fields['height']['label'] = $this->Lang('t_height');

  $co->fields['controls']['field_type'] = "checkbox_on";
  $co->fields['controls']['label'] = $this->Lang('t_controls');

  $co->fields['controls_size']['field_type'] = "radio|large|small";
  $co->fields['controls_size']['label'] = $this->Lang('t_controls_size');
  
  $co->fields['type_controls']['field_type'] = "checkbox_on";
  $co->fields['type_controls']['label'] = $this->Lang('t_type_controls');

  $co->fields['sidebar']['field_type'] = "checkbox_on";
  $co->fields['sidebar']['label'] = $this->Lang('t_sidebar');

  $co->fields['directions']['field_type'] = "checkbox";
  $co->fields['directions']['label'] = $this->Lang('t_directions');

  $co->fields['zoom']['field_type'] = "select|range|1|20";
  $co->fields['zoom']['label'] = $this->Lang('t_zoom');

  $co->fields['description']['field_type'] = 'textarea';
  $co->fields['description']['label'] = $this->Lang('t_description');

  $co->fields['zoom_encompass']['field_type'] = "checkbox";
  $co->fields['zoom_encompass']['label'] = $this->Lang('t_zoom_encompass');

  $co->fields['bounds_fudge']['label'] = $this->Lang('t_bounds_fudge');

  $co->fields['info_window']['field_type'] = "checkbox_on";
  $co->fields['info_window']['label'] = $this->Lang('t_info_window');

  $co->fields['info_trigger']['field_type'] = "radio|click|mouseover";
  $co->fields['info_trigger']['label'] = $this->Lang('t_info_trigger');

  //list visibility 
  $co->fields['map_id']['visible_in_list'] = false;
  $co->fields['owner_id']['visible_in_list'] = false;
  $co->fields['description']['visible_in_list'] = false;
  $co->fields['width']['visible_in_list'] = false;
  $co->fields['height']['visible_in_list'] = false;
  $co->fields['width']['visible_in_list'] = false;
  $co->fields['controls']['visible_in_list'] = false;
  $co->fields['type_controls']['visible_in_list'] = false;
  $co->fields['controls_size']['visible_in_list'] = false;
  $co->fields['sidebar']['visible_in_list'] = false;
  $co->fields['directions']['visible_in_list'] = false;
  $co->fields['zoom']['visible_in_list'] = false;
  $co->fields['zoom_encompass']['visible_in_list'] = false;
  $co->fields['bounds_fudge']['visible_in_list'] = false;
  $co->fields['info_window']['visible_in_list'] = false;
  $co->fields['info_trigger']['visible_in_list'] = false;


  //print it!
  $co->go();

  //markers crud
  $cm = new rcrud( $db , cms_db_prefix().'module_googlemaps_markers' );
  $cm->header = "Your Markers";

  //settings
  $cm->fields['map']['field_type'] = 'select|table|' . cms_db_prefix() . 'module_googlemaps_maps|map_id|name';

  //lang settings
  $cm->fields['name']['label'] = $this->Lang('t_name');
  $cm->fields['map']['label'] = $this->Lang('t_belongs_to');
  $cm->fields['info']['label'] = $this->Lang('t_info');
  $cm->fields['address']['label'] = $this->Lang('t_address');
  $cm->fields['lat']['label'] = $this->Lang('t_lan');
  $cm->fields['lon']['label'] = $this->Lang('t_lon');
  $cm->fields['icon']['label'] = $this->Lang('t_icon');

  $cm->fields['info']['field_type'] = 'textarea';


  //visibility_settings
  //list
  $cm->fields['marker_id']['visible_in_list'] = false;
  $cm->fields['info']['visible_in_list'] = false;

  $config = $gCms->GetConfig();
  // Read the directory that contain the images of the markers
  $path = $this->config['uploads_path'].'/'.$this->getName().'/markers';
  $cm->setPath($path, $this->Lang('patherror'), $this->Lang('markererror'));

  $cm->go();
  

  echo $this->EndTab();
  //end maps tab

  //start address tab
  echo $this->StartTab('address', $params);
  echo $this->CreateFormStart($id, 'defaultadmin');
  echo $this->CreateFieldsetStart($id, 'Address queries', 'Address queries' );
  echo $this->CreateInputTextWithLabel($id, 'address', '', 100, 1024,  '', $this->Lang('address_lookup').':&nbsp;' );
  echo $this->CreateFieldsetEnd();
  echo $this->CreateInputHidden($id, 'module', 'googlemaps');
  echo $this->CreateInputSubmit($id, 'submit_address_query', $this->Lang('Submit'));
  echo $this->CreateFormEnd();

  echo $this->EndTab();
  //end address tab

  //Settings tab
  echo $this->StartTab('settings', $params);

  echo $this->CreateFormStart($id, 'defaultadmin');
  echo $this->CreateFieldsetStart($id, 'general', 'General settings' );
  echo '<p>';
  echo $this->CreateInputTextWithLabel($id, 'apikey', $this->GetPreference("apikey", 1) , 100, 1024, '', $this->Lang('apikey') );
  echo "</p>";
  echo "<p>";
  echo $this->CreateLabelForInput($id, 'usecache', $this->Lang('usecache'));
  echo $this->CreateInputCheckbox($id, 'usecache', $this->GetPreference("usecache", 0) , '1');
  echo "</p>";
  echo '<p>';
  echo $this->CreateLabelForInput($id, 'usemarkershadows', $this->Lang('usemarkershadows'));
  echo $this->CreateInputCheckbox($id, 'usemarkershadows', $this->GetPreference('usemarkershadows', 0) , '1');
  echo "</p>"; 

  echo "<p>"; 
  echo $this->CreateLabelForInput($id, 'lookupservice', $this->Lang('lookupservice'));
  $lookupservices = array();
  $lookupservices["YAHOO"] = "YAHOO";
  $lookupservices["GOOGLE"] = "GOOGLE";
  echo $this->CreateInputDropdown($id, 'lookupservice', $lookupservices, -1, $this->GetPreference("lookupservice"));
  echo "</p>"; 

  echo "<p>"; 
  echo $this->CreateInputTextWithLabel($id, 'yahooapid', $this->GetPreference("yahooapid", '') , 100, 1024, '', $this->Lang('yahooappid') );
  echo "</p>"; 
  echo $this->CreateFieldsetEnd();

  echo $this->CreateInputSubmit($id, 'submit_general', $this->Lang('Submit'));
  echo $this->CreateFormEnd();

  echo $this->EndTab();
  //END Settings tab

  echo $this->EndTabContent();  
}  
?>
