<?php

/*---------------------------------------------------------
   DisplayModuleOutput($id, $params, $returnid, $message)
   NOT PART OF THE MODULE API
   This is an example of a simple method to display
   something where a page or template has a tag calling
   this module.
   
   Note that it uses a template, and is thus very powerful,
   even if it's simple.
  ---------------------------------------------------------*/

if (!isset($gCms)) exit;

#Avoid float problem in locale
$currentLocale = setlocale(LC_ALL, 0);
setlocale(LC_ALL, 'en_US');


if($this->GetPreference('apikey') == '')
{
  $this->smarty->assign('error', $this->Lang('nokey'));
  $this->smarty->assign('title', $this->Lang('error'));
  echo $this->ProcessTemplate('error.tpl');
  return;
}

$query = "SELECT * FROM ". cms_db_prefix() ."module_googlemaps_maps WHERE name LIKE '". $params['map']. "' LIMIT 1";
$map_data = array();
$dbresult =& $db->Execute($query);
if($dbresult) {
  $map_data = $dbresult->FetchRow();
}

if(!isset($map_data['map_id'])) {
  $this->smarty->assign('error', $this->Lang('nomap'));
  $this->smarty->assign('title', $this->Lang('error'));
  echo $this->ProcessTemplate('error.tpl');
  return;
}

// Now that a check is done if all seems ok, handle the overrides that are passed
if (isset($params['width'])) $map_data['width'] = $params['width'];
if (isset($params['height'])) $map_data['height'] = $params['height'];
if (isset($params['controls'])) {	// Tried to use intval($params['controls']), but smarty still fell over that
	$params['controls'] == '1' ? $map_data['controls'] = 1 : $map_data['controls'] = 0;
}
if (isset($params['type_controls'])) {
	$params['type_controls'] == '1' ? $map_data['type_controls'] = 1 : $map_data['type_controls'] = 0;
}
if (isset($params['zoom'])) $map_data['zoom'] = $params['zoom'];
if (isset($params['controls_size'])) $map_data['controls_size'] = $params['controls_size'];
if (isset($params['type'])) $map_data['type'] = $params['type'];
if (isset($params['sidebar'])) {
	$params['sidebar'] == '1' ? $map_data['sidebar'] = 1 : $map_data['sidebar'] = 0;
}
if (isset($params['directions'])) {
	$params['directions'] == '1' ? $map_data['directions'] = 1 : $map_data['directions'] = 0;
}
if (isset($params['zoom_encompass'])) {
	$params['zoom_encompass'] == '1' ? $map_data['zoom_encompass'] = 1 : $map_data['zoom_encompass'] = 0;
}
if (isset($params['bounds_fudge'])) $map_data['bounds_fudge'] = $params['bounds_fudge'];
if (isset($params['info_window'])) {
	$params['info_window'] == '1' ? $map_data['info_window'] = 1 : $map_data['info_window'] = 0;
}
if (isset($params['centerlon'])) $map_data['center_lon'] = $params['centerlon'];
if (isset($params['centerlat'])) $map_data['center_lat'] = $params['centerlat'];
if (isset($params['info_trigger'])) $map_data['info_trigger'] = $params['info_trigger'];
	
require_once('lib/GoogleMapAPI-'.$this->_googleapi_version.'/GoogleMapAPI.class.php');
$map = new GoogleMapAPI($map_data['map_id'], $this->GetPreference('yahooappid', '1234'));

// set values for displaying
$map->setAPIKey($this->GetPreference('apikey',1));
$map->setLookupService( $this->GetPreference('lookupservice', 'GOOGLE') );

$map->setWidth($map_data['width']);
$map->setHeight($map_data['height']);

if ($map_data['controls'] == 0) {
  $map->disableMapControls();
}
if ($map_data['type_controls'] == 0) {
  $map->disableTypeControls($map_data['type_controls']);
}

$map->setZoomLevel($map_data['zoom']);
$map->setControlSize($map_data['controls_size']);

$map->setMapType($map_data['type']);

if ($map_data['sidebar'] == 0) {
  $map->disableSidebar();
}

if ($map_data['directions'] == 0) {
  $map->disableDirections();
}

if($map_data['zoom_encompass'] == 0) {
  $map->disableZoomEncompass();
}

$map->setBoundsFudge($map_data['bounds_fudge']);

if($map_data['info_window'] == 0) {
  $map->disableInfoWindow();
}

$map->setInfoWindowTrigger($map_data['info_trigger']);

// get markers for this map
$query = "SELECT * FROM ". cms_db_prefix() ."module_googlemaps_markers WHERE map = '". $map_data['map_id'] ."'";
$dbresult =& $db->Execute($query);

$error = '';
while ($dbresult && $map_marker = $dbresult->FetchRow()) {
  
  $lat = '';
  $lon = '';
  
  if($map_marker['lat'] == '' && $map_marker['lat'] == '') {
    //find address
    $geocode = '';
    if($map_marker['address'] != '') {
      $geocode = $map->getGeocode($map_marker['address']);
    }
    $lat = $geocode['lat'];
    $lon = $geocode['lon'];
  } else {
    // use provided lat lon
    $lat = $map_marker['lat'];
    $lon = $map_marker['lon'];
  }
  
  if($lat != '' && $lon != '') {
    $map->addMarkerByCoords(
			    str_replace(',', '.', $lon), 
			    str_replace(',', '.', $lat), 
			    $map_marker['name'], 
			    $map_marker['info']
			    );
	// Add the correct icon
	$config = $gCms->GetConfig();
	$markerdir = $this->config['root_url'].DIRECTORY_SEPARATOR.'modules'.
		DIRECTORY_SEPARATOR.$this->getName().
		DIRECTORY_SEPARATOR.'images'.DIRECTORY_SEPARATOR;
	if ($map_marker['icon'] != '') {
 		// Prepare the url to the marker
  		$icontouse = $markerdir.'markers'.DIRECTORY_SEPARATOR.$map_marker['icon'];
	} else {
  		$icontouse = $markerdir.'markers'.DIRECTORY_SEPARATOR.'default.png';
	}
	// Now check if a shadow is to be included
	if ($this->GetPreference('usemarkershadows', 0) == 0) {
		$map->addMarkerIcon($icontouse);
	} else {
		// Build the name of the shadow icon. Split name in first part and extension
		$filenamesplit = array();
		$filenamesplit = strtok($map_marker['icon'], '.');
		$shadowtouse = $markerdir.'markershadows'.DIRECTORY_SEPARATOR.$filenamesplit.'s.png';
  		// Check if the shadow icon exists
  		if (!file_exists($shadowtouse)) {
			$shadowtouse = $markerdir.'markershadows'.DIRECTORY_SEPARATOR.'defaults.png';
		}
		$map->addMarkerIcon($icontouse, $shadowtouse);
	}
  } 
}



// center the map if center coordinates are set!
if ( $map_data['center_lat'] && $map_data['center_lon'] ) {
  $map->setCenterCoords(
			str_replace(',', '.', $map_data['center_lon']), 
			str_replace(',', '.', $map_data['center_lat'])
			);
}

#$map->disableOnLoad();

// assign Smarty variables;
$this->smarty->assign('google_map_header',$map->getHeaderJS());
$this->smarty->assign('google_map_js',$map->getMapJS());
$this->smarty->assign('google_map_sidebar',$map->getSidebar());
$this->smarty->assign('google_map',$map->getMap());
$this->smarty->assign('map_description', $map_data['description']);

// Display the populated template
echo $this->ProcessTemplate('map.tpl');

#Set back locale again
setlocale(LC_ALL, $currentLocale);
?>
