<?php
if (!isset($gCms)) exit;

$db =& $gCms->GetDb();

// mysql-specific, but ignored by other database
$taboptarray = array('mysql' => 'TYPE=MyISAM');

$dict = NewDataDictionary($db);

// table schema description
$flds = "
	map_id I AUTO KEY,
        name C(80) NOTNULL,
	description X,
        center_lat C(50),
        center_lon C(50),
        owner_id I,
        type C(50),
        width C(50),
        height C(50),
        controls L,
        controls_size C(10),
        type_controls L,
        sidebar L,
        directions L,
        zoom C(10),
        zoom_encompass L,
        bounds_fudge F,
        info_window L,
        info_trigger C(80)
	";

// create it. This should do error checking, but I'm a lazy sod.
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_googlemaps_maps", $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

//index for maps
$sqlarray = $dict->CreateIndexSQL('i_name', cms_db_prefix()."module_googlemaps_maps", 'name');

// create a sequence
#$db->CreateSequence(cms_db_prefix()."module_googlemaps_maps_seq");


// Markers
$flds = "
        marker_id I AUTO KEY,
        map C(100),
        name C(80),
        info X,
        address C(255),
        lat C(100),
        lon C(100),
        icon C(100)
        ";

// create it. This should do error checking, but I'm a lazy sod.
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_googlemaps_markers", $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
// create a sequence
$db->CreateSequence(cms_db_prefix()."module_googlemaps_markers_seq");


// Cache not used yet
$flds = "
        address C(255) KEY DEFAULT '', 
        lon F,
        lat F
        ";

$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_googlemaps_cache", $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
// create a sequence
$db->CreateSequence(cms_db_prefix()."module_googlemaps_cache_seq");


// create a permission
$this->CreatePermission('Use GoogleMaps', 'Use GoogleMaps');


// create a preference
$this->SetPreference("apikey", '');
$this->SetPreference("lookupservice", 'GOOGLE');
$this->SetPreference("usecache", '0');
$this->GetPreference('usemarkershadows', 0);
$this->SetPreference("yahooappid", '');

$config = $gCms->GetConfig();
// Prepare a directory that will contain the images of the markers and one for the shadows of the markers
$path = $this->config['uploads_path'].'/'.$this->getName();
// Make sure the directory can be found. Create it, error handling will cover any problems found
mkdir($path, 0777);
$markerspath = $path.DIRECTORY_SEPARATOR.'markers';
mkdir($markerspath, 0777);
$markershadowspath = $path.DIRECTORY_SEPARATOR.'markershadows';
mkdir($markershadowspath, 0777);
// Copy over the default supplied markers
$markerdir = dirname(__FILE__).DIRECTORY_SEPARATOR.'images'.DIRECTORY_SEPARATOR.'markers';
if (file_exists( $markerdir ) ) {
	$dir = opendir($markerdir);
	// Filter out the directory controling characters and build selectable options of the others
	while (($file = readdir($dir)) !== false)
	  {
	  	if ($file !='.' && $file!='..') {
  			copy($markerdir.DIRECTORY_SEPARATOR.$file, $markerspath.DIRECTORY_SEPARATOR.$file);
	  	}
	  }
	closedir($dir);
}

// put mention into the admin log
$this->Audit( 0, $this->Lang('friendlyname'), $this->Lang('installed',$this->GetVersion()));

?>
