<?php
#-------------------------------------------------------------------------
# Module: EMoneyateway - A Emoney gateway module for the Orders module
# Version: 1.0, SjG <sjg@cmsmodules.com>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2008 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/emoneygateway
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
if( !isset($gCms) ) exit;

$db = &$gCms->GetDB();

if (!isset($params['order_id']) || ! isset($params['emgw_custom_field']))
 	{
	$this->ShowErrors($this->Lang('error_permissiondenied'));
	exit;
	}
if (!isset($_SESSION['emgw_custom_field']) || $_SESSION['emgw_custom_field'] != $params['emgw_custom_field'])
	{
	$this->ShowErrors($this->Lang('error_securityviolation'));
	exit;
	}
	
// retrieve enough order details to submit it!
$order = $db->GetRow('SELECT * FROM ' . cms_db_prefix() . 'module_orders WHERE id = ?', array($params['order_id']));

if ($order === false || count($order) < 1)
	{
	$this->ShowErrors($this->Lang('error_invalidorderid'));
	exit;
	}

if ($this->GetPreference('mode','test') == 'test')
	{
	$query_url = $this->GetPreference('test_url');
	}
else
	{
	$query_url = $this->GetPreference('production_url');
	}

// clean up credit card number
$cn = preg_replace('/\D/','',$params['card_number']);
// clean up zip
$zip = preg_replace('/\D/','',$order['billing_postal']);
// clean up expiration

if ($params['exp_month'] < 10)
	{
	$expiration = '0'.$params['exp_month'];
	}
else
	{
	$expiration = $params['exp_month'];
	}

$expiration .= substr($params['exp_year'],-2,2);

$post_string = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n".
	"<RequestMessage>\n".
	"<Action>AUTHORIZE_ONLINE</Action>\n".
	"<ClientID>".$this->GetPreference('clientid')."</ClientID>\n".
	"<MasterKey>".$this->GetPreference('masterkey')."</MasterKey>\n".
	"<PurchaseIdentifier1>ORDER-".$params['order_id']."</PurchaseIdentifier1>\n".
	"<TransactionAmount>".$order['total']."</TransactionAmount>\n".
	"<AccountNumber>".$cn."</AccountNumber>\n".
	"<ExpirationDate>".$expiration."</ExpirationDate>\n" .
	"<NameOnCard>".$order['billing_first_name'].' '.$order['billing_last_name']."</NameOnCard>\n".
	"<AVSStreet1>".substr($order['billing_address1'],0,20)."</AVSStreet1>\n".
	"<AVSZip>".$zip."</AVSZip>\n";
if (isset($params['cvv']))
	{
	$post_string .= "<CVV>".$params['cvv']."</CVV>\n";
	}
	
$post_string .= "<VendorID>".$this->GetPreference('vendorid')."</VendorID>\n".
	"<VendorName>".$this->GetPreference('vendorname')."</VendorName>\n".
	"<VendorProduct>".$this->Lang('friendlyname').' '.$this->GetVersion()."</VendorProduct>\n".
	"</RequestMessage>\n";


$disp_post_str = substr($post_string,0,stripos($post_string,'<AccountNumber>')+15).
	substr('*******************',0,strlen($cn)-4).substr($cn,-4).substr($post_string,stripos($post_string,'</AccountNumber>'));
if (stripos($disp_post_str,'<CVV>') !== false)
	{
	$disp_post_str = substr($disp_post_str,0,stripos($disp_post_str,'<CVV>')+5).
		'***'.substr($disp_post_str,stripos($disp_post_str,'</CVV>'));
	}

if ($this->GetPreference('debug_mode','false') == 'true' || $this->GetPreference('mode','test') == 'test')
	{
	error_log('SENT: '.$disp_post_str);
	}
$connect=curl_init();
curl_setopt($connect, CURLOPT_URL, $query_url);
curl_setopt($connect, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($connect, CURLOPT_POST, 1) ;
curl_setopt($connect, CURLOPT_POSTFIELDS, urlencode($post_string));

curl_setopt($connect, CURLOPT_SSL_VERIFYPEER, 0);
curl_setopt($connect, CURLOPT_SSL_VERIFYHOST, 0);

$result = curl_exec($connect);

if ($result === false)
	{
	$httpresp = curl_getinfo($connect,CURLINFO_HTTP_CODE);
	$curlerror = curl_errno();
	$_SESSION['error_message'] = $this->Lang('connection_error',array($httpresp,$curlerror));
	$this->SetReturnStatus('FAILED');
	}
curl_close($connect);
if ($this->GetPreference('debug_mode','false') == 'true' ||  $this->GetPreference('mode','test') == 'test')
	{
	error_log('RCVD: '.$result);
	}

$resp_items = array(
	'ResponseCode'=>'',
	'TransactionID'=>'',
	'ApprovalCode'=>'',
	'AVSResultCode'=>'',
	'CVVResultCode'=>'',
	'TransactionSequenceNumber'=>''
);

$res_string = '';
foreach ($resp_items as $rkey=>$rval)
	{
	$resp_items[strtolower($rkey)] = $this->ExtractResponseString($rkey,$result);
	$res_string .= $rkey.':'.$resp_items[strtolower($rkey)].' ';
	}
$result_message = $this->ExtractResponseString('ResponseText',$result);
// check for success code - should be 00 (successful authorization) or 85 (card validates)
if ($resp_items['responsecode'] != '00' && $resp_items['responsecode'] != '85')
	{
	$this->SetReturnStatus('SOFTFAIL');
	$_SESSION['error_message'] = $this->Lang('validation_failed',$result_message);
	}
else
	{
	// 
	/*
	Check for Address verification, if requested:
	X EXACT MATCH Exact match, 9 digit zip 
	Y EXACT MATCH Exact match, 5 digit zip 
	A ADDRESS MATCH Address match only 
	W ZIP MATCH 9-digit zip match only 
	Z ZIP MATCH 5-digit zip match only 
	*/
	if ($this->GetPreference('require_address','require') != 'require' || preg_match('/x|y|z|a|w/i',$resp_items['avsresultcode'] ))
		{
		/*
		Check for CVV verification, if requested:
		M CVV2/CV2C/CID verification successful. 
		N CVV2/CV2C/CID verification failed. 
		P APPROVAL XXXXXX
		*/
		if ($this->GetPreference('require_cvv','require') != 'require' || preg_match('/m|p/i', $resp_items['cvvresultcode']))
			{
    		$this->SetReturnStatus('SUCCESS');
    		$this->SetReturnTransactionID($res_string);
			}
		else
			{
			$_SESSION['error_message'] = $this->Lang('validation_failed_cvv');
			$this->SetReturnStatus('SOFTFAIL');	
			}
		}
	else
		{
		$_SESSION['error_message'] = $this->Lang('validation_failed_address');
		$this->SetReturnStatus('SOFTFAIL');	
		}
  	}

// build the default url
if($this->GetReturnStatus() == 'SUCCESS' && isset($_SESSION['ewgw_success_url']) )
  {
    $url = cms_html_entity_decode(trim($_SESSION['ewgw_success_url']));
    if( !empty($url ) )
      {
	  redirect($url);
	  return;
      }
  }

$url = cms_html_entity_decode($_SESSION['emgw_cancel_url']);
redirect($url);
return;
?>