<?php
#-------------------------------------------------------------------------
# Module: EMoneyateway - A Emoney gateway module for the Orders module
# Version: 1.0, SjG <sjg@cmsmodules.com>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2008 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/emoneygateway
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
if( !isset($gCms) ) exit;

if( !$this->CheckPermission('Modify Site Preferences') )
{
	echo $this->ShowErrors($this->Lang('error_permissiondenied'));
	exit;
}

if (FALSE == empty($params['active_tab']))
  {
    $tab = $params['active_tab'];
  } else {
  $tab = '';
 }

$smarty->assign('tabheaders', $this->StartTabHeaders() .
	$this->SetTabHeader('preferences',$this->Lang('preferences'),('preferences' == $tab)?true:false) .
	$this->SetTabHeader('advanced',$this->Lang('advanced'),('advanced' == $tab)?true:false) .
	$this->EndTabHeaders().
	$this->StartTabContent());
$smarty->assign('start_preferences',$this->StartTab('preferences'));
$smarty->assign('start_advanced',$this->StartTab('advanced'));
$smarty->assign('end_tab',$this->EndTab());
$smarty->assign('end_tabs',$this->EndTabContent());

 if (isset($params['submit']))
	{
	if (isset($params['production_url']))
		{
		$this->SetPreference('production_url', trim($params['production_url']));
		}
	if (isset($params['test_url']))
		{
		$this->SetPreference('test_url', trim($params['test_url']));
		}
	if (isset($params['mode']))
		{
		$this->SetPreference('mode',$params['mode']);
		}
	
	if (isset($params['masterkey']))
		{
		$this->SetPreference('masterkey', trim($params['masterkey']));
		}
	if (isset($params['clientid']))
		{
		$this->SetPreference('clientid', trim($params['clientid']));
		}
	if (isset($params['vendorname']))
		{
		$this->SetPreference('vendorname', trim($params['vendorname']));
		}
	if (isset($params['vendorid']))
		{
		$this->SetPreference('vendorid', trim($params['vendorid']));
		}
	if (isset($params['require_cvv']))
		{
		$this->SetPreference('require_cvv',$params['require_cvv']);
		}
	if (isset($params['require_address']))
		{
		$this->SetPreference('require_address',$params['require_address']);
		}
	if (isset($params['debug_mode']))
		{
		$this->SetPreference('debug_mode',$params['debug_mode']);
		}

	}

$smarty->assign('formstart', $this->CGCreateFormStart($id, 'defaultadmin', $returnid));
$smarty->assign('formend', $this->CreateFormEnd());

if (! function_exists('curl_init'))
	{
	$smarty->assign('error',$this->Lang('missing_libcurl'));
	}
else
	{
	$smarty->assign('error','');
	}

$smarty->assign('prompt_production_url',$this->Lang('production_url'));
$smarty->assign('prompt_test_url',$this->Lang('test_url'));
$smarty->assign('input_production_url', $this->CreateInputText($id, 'production_url', $this->GetPreference('production_url', 'https://pos.etsemoney.com/ECOM3X/main.asp'), 100, 1024));
$smarty->assign('input_test_url', $this->CreateInputText($id, 'test_url', $this->GetPreference('test_url', 'https://demo.etsemoney.com/ECOM3X/main.asp'), 100, 1024));
$smarty->assign('prompt_mode', $this->Lang('prompt_mode'));
$modes = array($this->Lang('mode_production')=>'production',$this->Lang('mode_test')=>'test');
$smarty->assign('input_mode', $this->CreateInputRadioGroup($id, 'mode', $modes, $this->GetPreference('mode','test')));

$smarty->assign('prompt_clientid',$this->Lang('prompt_clientid'));
$smarty->assign('prompt_masterkey',$this->Lang('prompt_masterkey'));
$smarty->assign('prompt_vendorname',$this->Lang('prompt_vendorname'));
$smarty->assign('prompt_vendorid',$this->Lang('prompt_vendorid'));
$smarty->assign('prompt_require_cvv',$this->Lang('prompt_require_cvv'));
$smarty->assign('prompt_require_address',$this->Lang('prompt_require_address'));
$smarty->assign('prompt_debug_mode',$this->Lang('prompt_debug_mode'));

$smarty->assign('input_clientid', $this->CreateInputText($id, 'clientid', $this->GetPreference('clientid'), 5, 10));
$smarty->assign('input_masterkey', $this->CreateInputText($id, 'masterkey', $this->GetPreference('masterkey'), 6, 10));
$smarty->assign('input_vendorname', $this->CreateInputText($id, 'vendorname', $this->GetPreference('vendorname'), 20, 40));
$smarty->assign('input_vendorid', $this->CreateInputText($id, 'vendorid', $this->GetPreference('vendorid'), 20, 40));
$reqs = array($this->Lang('require')=>'require',$this->Lang('norequire')=>'norequire');
$smarty->assign('input_require_cvv', $this->CreateInputRadioGroup($id, 'require_cvv', $reqs, $this->GetPreference('require_cvv','require')));
$smarty->assign('input_require_address', $this->CreateInputRadioGroup($id, 'require_address', $reqs, $this->GetPreference('require_address','require')));
$truefalse = array($this->Lang('on')=>'true',$this->Lang('off')=>'false');
$smarty->assign('input_debug_mode', $this->CreateInputRadioGroup($id, 'debug_mode', $truefalse, $this->GetPreference('debug_mode','false')));


$smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));

echo $this->ProcessTemplate('prefs.tpl');

// EOF
?>
