<?php
#-------------------------------------------------------------------------
# Module: EMoneyateway - A Emoney gateway module for the Orders module
# Version: 1.0, SjG <sjg@cmsmodules.com>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2008 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/emoneygateway
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$cgextensions = cms_join_path($gCms->config['root_path'],'modules',
	'CGExtensions','CGExtensions.module.php');
if( !is_readable( $cgextensions ) )
{
	echo '<h1><font color="red">ERROR: The CGExtensions module could not be found.</font></h1>';
	return;
}
require_once($cgextensions);

class EMoneyGateway extends CGExtensions
{

  var $_weightunits;
  var $_currencycode;
  var $_successurl;
  var $_successpage;
  var $_cancelurl;
  var $_cancelpage;
  var $_items;
  var $_ordertax;
  var $_ordershipping;
  var $_orderid;

  /*---------------------------------------------------------
   Constructor()
   ---------------------------------------------------------*/
  function EMoneyGateway()
  {
    parent::CMSModule();
    $this->reset();
  }

  /*---------------------------------------------------------
   GetName()
   ---------------------------------------------------------*/
  function GetName()
  {
    return 'EMoneyGateway';
  }
  
  /*---------------------------------------------------------
   GetFriendlyName()
   ---------------------------------------------------------*/
  function GetFriendlyName()
  {
    return $this->Lang('friendlyname');
  }


  /*---------------------------------------------------------
   GetVersion()
   ---------------------------------------------------------*/
  function GetVersion()
  {
    return '1.0.2';
  }


  /*---------------------------------------------------------
   GetHelp()
   ---------------------------------------------------------*/
  function GetHelp()
  {
    return $this->Lang('help');
  }


  /*---------------------------------------------------------
   GetAuthor()
   ---------------------------------------------------------*/
  function GetAuthor()
  {
    return 'SjG';
  }


  /*---------------------------------------------------------
   GetAuthorEmail()
   ---------------------------------------------------------*/
  function GetAuthorEmail()
  {
    return 'sjg@cmsmodules.com';
  }


  /*---------------------------------------------------------
   GetChangeLog()
   ---------------------------------------------------------*/
  function GetChangeLog()
  {
    return $this->Lang('changelog');
  }

  /*---------------------------------------------------------
   IsPluginModule()
   ---------------------------------------------------------*/
  function IsPluginModule()
  {
    return true;
  }


  /*---------------------------------------------------------
   HasAdmin()
   ---------------------------------------------------------*/
  function HasAdmin()
  {
    return true;
  }


  /*---------------------------------------------------------
   GetAdminSection()
   ---------------------------------------------------------*/
  function GetAdminSection()
  {
    return 'extensions';
  }


  /*---------------------------------------------------------
   GetAdminDescription()
   ---------------------------------------------------------*/
  function GetAdminDescription()
  {
    return $this->Lang('moddescription');
  }


  /*---------------------------------------------------------
   VisibleToAdminUser()
   ---------------------------------------------------------*/
  function VisibleToAdminUser()
  {
    return $this->CheckPermission('Modify Templates') ||
      $this->CheckPermission('Modify Site Preferences');
  }


  /*---------------------------------------------------------
   GetDependencies()
   ---------------------------------------------------------*/
  function GetDependencies()
  {
    return array('CGExtensions'=>'1.9','Orders'=>'1.1');
  }


  /*---------------------------------------------------------
   MinimumCMSVersion()
   ---------------------------------------------------------*/
  function MinimumCMSVersion()
  {
    return "1.3";
  }


  /*---------------------------------------------------------
   SetParameters()
   ---------------------------------------------------------*/
  function SetParameters()
  {
    $this->RegisterModulePlugin();
    $this->RestrictUnknownParams();

    $this->SetParameterType('process', CLEAN_STRING);		
    $this->SetParameterType('order_id', CLEAN_INT);
    $this->SetParameterType('mycustom', CLEAN_STRING);
	$this->SetParameterType('emgw_custom_field', CLEAN_STRING);
	$this->SetParameterType('card_number', CLEAN_STRING);
	$this->SetParameterType('cvv', CLEAN_STRING);
	$this->SetParameterType('exp_month', CLEAN_INT);
	$this->SetParameterType('exp_year', CLEAN_INT);
	$this->SetParameterType('submit', CLEAN_STRING);
	
  }


  /*---------------------------------------------------------
   InstallPostMessage()
   ---------------------------------------------------------*/
  function InstallPostMessage()
  {
    return $this->Lang('postinstall');
  }


  /*---------------------------------------------------------
   UninstallPostMessage()
   ---------------------------------------------------------*/
  function UninstallPostMessage()
  {
    return $this->Lang('postuninstall');
  }


  /*---------------------------------------------------------
   UninstallPreMessage()
   ---------------------------------------------------------*/
  function UninstallPreMessage()
  {
    return $this->Lang('really_uninstall');
  }

	
  /*---------------------------------------------------------
   IsPaymentGatewayModule()
   ---------------------------------------------------------*/
  function IsPaymentGatewayModule()
  {
    return true;
  }

  function GetForm($returnid)
	{
	// force https?
	$id = 'cntnt07';
		
	$this->smarty->assign('form_start',	$this->CreateFrontendFormStart($id,$returnid,'process','post',
		'',false,'',array('order_id'=>$this->_orderid,'emgw_custom_field'=>md5('order'.$this->_orderid)
					    )));
	$_SESSION['emgw_custom_field'] = md5('order'.$this->_orderid);

	$this->smarty->assign('prompt_card',$this->Lang('prompt_card'));
	$this->smarty->assign('prompt_expiration',$this->Lang('prompt_expiration'));
	$this->smarty->assign('prompt_cvv',$this->Lang('prompt_cvv'));
	
	$this->smarty->assign('input_card',  $this->CreateInputText($id, 'card_number','',16,19));
	$this->smarty->assign('input_cvv',  $this->CreateInputText($id, 'cvv','',3,5));
	$this->smarty->assign('submit',$this->CreateInputSubmit($id, 'submit', $this->Lang('submit')));
	$mon = array();
	$year = array();
	for ($i=1;$i<13;$i++)
		{
		$mn = ''.($i<10?'0':'').$i;
		$mon[$mn] = $i;
		}
	$yr = date('Y');
	for ($i=$yr;$i<($yr+11);$i++)
		{
		$year[$i]=$i;
		}
	
	$this->smarty->assign('input_expiration', $this->CreateInputDropdown($id, 'exp_month', $mon). $this->CreateInputDropdown($id, 'exp_year', $year));
    if( !empty($this->_successurl) )
      {
		$_SESSION['emgw_success_url'] = $this->_successurl;
      }
    if( !empty($this->_cancelurl) )
      {
		$_SESSION['emgw_cancel_url'] = $this->_cancelurl;
      }
	return $this->ProcessTemplate('form.tpl');
	}

/*
  function GetForm($returnid)
  {
    if( empty($this->_orderid) || count($this->_items) == 0 )
      {
		return '';
      }
    $successpage = (empty($this->_successpage))?$returnid:$this->_successpage;
    $cancelpage = (empty($this->_cancelpage))?$returnid:$this->_cancelpage;
    
    require_once('paypal.class.php');
    $pp = new paypal_class;

    $pp->paypal_url = $this->GetPreference('paypal_url','https://www.sandbox.paypal.com/cgi-bin/webscr');
    $pp->add_field('upload', '1'); //3rd party cart
    $pp->add_field('rm','2'); //Use POST for returns
    $pp->add_field('cmd','_cart'); //3rd party cart
    if( !empty($this->_weightunits) )
      {
	$pp->add_field('weight_unit',$this->_weightunits);
      }
    if( !empty($this->_currencycode) )
      {
	$pp->add_field('currency_code',$this->_currencycode);
      }
    $pp->add_field('business',$this->GetPreference('business_email',''));
    $pp->add_field('order_id',$this->_orderid);
    $_SESSION['ppgw_custom_field'] = md5('orders'.$this->_orderid);
    $pp->add_field('custom',$_SESSION['ppgw_custom_field']);
    $pp->add_field('return',$this->CreateLink($id,'return_success',$successpage,'',array('order_id'=>$this->_orderid,
											 'mycustom'=>$_SESSION['ppgw_custom_field']),'',true));
    $pp->add_field('cancel_return',
 		   $this->CreateLink($id,'return_cancel',$cancelpage,'',array('order_id'=>$this->_orderid,
									      'mycustom'=>$_SESSION['ppgw_custom_field']),'',true));
    $pp->add_field('no_note',1);

    // todo... handle a notify url for ipn

    $count = 1;
    foreach( $this->_items as $name => $data )
      {
	$pp->add_field('amount_'.$count, $data['amount']);
	$pp->add_field('item_name_'.$count, $name );
	$pp->add_field('item_number_'.$count, $data['number']);
	$pp->add_field('quantity_'.$count, $data['quantity']);
	$count++;
      }
    
    // hack for shipping
    if( !empty($this->_ordershipping) && $this->_ordershipping > 0 )
      {
	$pp->add_field('amount_'.$count, $this->_ordershipping );
	$pp->add_field('item_name_'.$count, 'Shipping');
      }

    // taxes
    if( !empty($this->_ordertax) )
      {
	$pp->add_field('tax_cart',$this->_ordertax);
      }

    // set a couple of session variables for the return urls
    if( !empty($this->_successurl) )
      {
	$_SESSION['ppgw_success_url'] = $this->_successurl;
      }
    if( !empty($this->_cancelurl) )
      {
	$_SESSION['ppgw_cancel_url'] = $this->_cancelurl;
      }
    @ob_start();
    $pp->submit_paypal_post(false,$this->Lang('checkout_message').' '.
			    '<input type="submit" value="'.$this->Lang('checkout_button_message').'">');
    $result = @ob_get_contents();
    @ob_end_clean();
    return $result;
  }
*/

  function reset()
  {
    $this->_weightunits = 'lbs';
    $this->_currencycode = 'USD';
    $this->_successurl = '';
    $this->_cancelurl = '';
    $this->_successpage = '';
    $this->_cancelpage = '';
    $this->_items = array();
    $this->_ordertax = '';
    $this->_ordershipping = '';
    $this->_orderid = '';
  }


  function SetCurrencyCode($code = 'USD')
  {
    $this->_currencycode = strtoupper($code);
  }


  function SetWeightUnits($units = 'lbs')
  {
    $this->_weightunits = $units;
  }


  function SetSuccessURL($url)
  {
    $this->_successurl = $url;
  }


  function SetSuccessPage($page)
  {
    $this->_successpage = $page;
  }


  function SetCancelURL($url)
  {
    $this->_cancelurl = $url;
  }


  function SetCancelPage($page)
  {
    $this->_cancelpage = $page;
  }


  function AddItem($name,$number,$quantity,$weight,$amount,$tax = '')
  {
    if( !isset($this->_items[$name]) )
      {
	$this->_items[$name] = array('name'=>$name,
				     'number'=>$number,
				     'quantity'=>$quantity,
				     'weight'=>$weight,
				     'amount'=>$amount);
	if(!empty($tax))
	  {
	    $this->_items[$name]['tax'] = $tax;
	  }
      }
  }


  function SetOrderTaxAmount($tax)
  {
    $this->_ordertax = $tax;
  }


  function SetOrderShipping($shipping)
  {
    $this->_ordershipping = $shipping;
  }


  function SetOrderID($orderid)
  {
    $this->_orderid = $orderid;
  }


  function SetReturnStatus($status)
  {
    if( !isset($_SESSION['gateway_return_params']) )
      {
	$_SESSION['gateway_return_params'] = array();
      }
    $_SESSION['gateway_return_params']['status'] = $status;
  }


  function GetReturnStatus()
  {
    if( !isset($_SESSION['gateway_return_params']) ) return false;
    if( !isset($_SESSION['gateway_return_params']['status']) ) return false;
    return $_SESSION['gateway_return_params']['status'];
  }


  function SetReturnTransactionID($tx)
  {
    if( !isset($_SESSION['gateway_return_params']) )
      {
	$_SESSION['gateway_return_params'] = array();
      }
    $_SESSION['gateway_return_params']['transid'] = $tx;
  }


  function GetReturnTransactionID()
  {
    if( !isset($_SESSION['gateway_return_params']) ) return false;
    if( !isset($_SESSION['gateway_return_params']['transid']) ) return false;
    return $_SESSION['gateway_return_params']['transid'];
  }


  function SetReturnText($txt)
  {
    if( !isset($_SESSION['gateway_return_params']) )
      {
	$_SESSION['gateway_return_params'] = array();
      }
    $_SESSION['gateway_return_params']['data'] = $txt;
  }


  function GetReturnTransactionText()
  {
    if( !isset($_SESSION['gateway_return_params']) ) return false;
    if( !isset($_SESSION['gateway_return_params']['data']) ) return false;
    return $_SESSION['gateway_return_params']['data'];
  }

  function ClearsessionVars()
  {
    unset( $_SESSION['emgw_success_url'] );
    unset( $_SESSION['emgw_cancel_url'] );
    unset( $_SESSION['emgw_custom_field'] );
    unset( $_SESSION['gateway_return_params'] );
  }

  function ExtractResponseString($tag, $result)
	{
	$regex = '/<'.$tag.'>([^<]+)<\/'.$tag.'>/i';
	$matches = array();
	if (! preg_match($regex,$result, $matches))
		{
		return false;
		}
	else
		{
		return $matches[1];
		}
	}

} // class
