<?php
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------

if (!isset($gCms)) exit;

$db =& $gCms->GetDb();

$dict = NewDataDictionary( $db );

// remove the playlist table
$sqlarray = $dict->DropTableSQL(cms_db_prefix() . 'module_exspf_playlist');
$dict->ExecuteSQLArray($sqlarray);

// remove the playlist_song table
$sqlarray = $dict->DropTableSQL(cms_db_prefix() . 'module_exspf_playlist_song');
$dict->ExecuteSQLArray($sqlarray);

// remove the sequence tables
$db->DropSequence(cms_db_prefix() . 'module_exspf_playlist_seq');
$db->DropSequence(cms_db_prefix() . 'module_exspf_playlist_song_seq');

// remove the permissions
$this->RemovePermission('Use Enhanced XSPF');

// Remove the preferences
$prefs = array(
	'player',
	'extended_player_url',
	'slim_player_url',
	'player_width',
	'slim_player_height',
	'extended_player_height',
	'autoresume',
	'autoplay',
	'autoload',
	'shuffle',
	'repeat', 
	'count_downloads',
	'no_direct_downloads'
);
foreach ($prefs as $pref)
{
	$this->RemovePreference($pref);
}

// Remove the events
$events = array(
	'XSPFPlaylistAdded', 
	'XSPFPlaylistChanged', 
	'XSPFPlaylistSongsChanged', 
	'XSPFPlaylistDeleted'
);
foreach ($events as $event)
{
	$this->RemoveEvent($event);
}

// put mention into the admin log
$this->Audit( 0, $this->GetFriendlyName(), $this->Lang('audit_module_uninstall'));

?>
