<?php
$lang['friendlyname'] = 'Enhanced XSPF';

$lang['postinstall'] = 'The module was succesfully installed';
$lang['postuninstall'] = 'The module was succesfully uninstalled';
$lang['really_uninstall'] = 'Are you sure you want to uninstall this module?';

$lang['audit_module_install']   = 'Module version %s installed.';
$lang['audit_module_upgrade']   = 'Module upgraded to version %s.';
$lang['audit_module_uninstall'] = 'Module Uninstalled.';

$lang['audit_admin_playlist_added'] = 'Playlist added';
$lang['audit_admin_playlist_changed'] = 'Playlist changed';
$lang['audit_admin_playlist_songs_saved'] = 'Playlist songs saved';
$lang['audit_admin_playlist_deleted'] = 'Playlist deleted';
$lang['audit_admin_prefs_changed'] = 'Module preferences changed';

$lang['title_admintab_prefs'] = 'Module Preferences';
$lang['title_admintab_songs'] = 'Songs';
$lang['title_admintab_playlists'] = 'Playlists';

$lang['id'] = 'Id';
$lang['name'] = 'Name';
$lang['description'] = 'Description';
$lang['songs'] = 'Songs';
$lang['playlist'] = 'Playlist';

$lang['title_link_add_playlist'] = 'Add Playlist';
$lang['title_link_edit_songs'] = 'Edit Songs';
$lang['title_link_add_uploads_categories'] = 'Add Uploads categories';
$lang['title_songs_in_playlist'] = 'Songs in playlist';
$lang['title_available_songs'] = 'Available songs';

$lang['alert_delete_playlist'] = 'Delete playlist %s?';

$lang['header_module_options'] = 'Module Options';
$lang['header_parameter_defaults'] = 'Parameter Defaults';
$lang['header_add_playlist'] = 'Add Playlist';
$lang['header_add_playlist_songs'] = 'Add Playlist Songs';
$lang['header_edit_playlist'] = 'Edit Playlist';
$lang['header_edit_playlist_songs'] = 'Edit Playlist Songs';
$lang['header_admin_playlists'] = 'Manage Playlists';

$lang['dropdown_item_player_slim'] = 'Slim';
$lang['dropdown_item_player_extended'] = 'Extended';

$lang['label_admin_prefs_extended_player_url'] = 'extended_player_url';
$lang['label_admin_prefs_slim_player_url'] = 'slim_player_url';
$lang['label_admin_prefs_player_width'] = 'player_width';
$lang['label_admin_prefs_slim_player_height'] = 'slim_player_height';
$lang['label_admin_prefs_extended_player_height'] = 'extended_player_height';
$lang['label_admin_prefs_autoresume'] = 'autoresume';
$lang['label_admin_prefs_autoplay'] = 'autoplay';
$lang['label_admin_prefs_autoload'] = 'autoload';
$lang['label_admin_prefs_shuffle'] = 'shuffle';
$lang['label_admin_prefs_repeat'] = 'repeat';
$lang['label_admin_prefs_player'] = 'player';
$lang['label_admin_prefs_count_downloads'] = 'count_downloads';
$lang['label_admin_prefs_no_direct_downloads'] = 'no_direct_downloads';

$lang['msg_no_changes'] = 'No changes';
$lang['msg_playlist_songs_updated'] = 'Updated playlist songs';
$lang['msg_playlist_updated'] = 'Updated playlist';
$lang['msg_set_preference'] = 'Updated preference %s';
$lang['msg_playlist_added'] = 'Playlist successfully added';

$lang['err_access_denied'] = 'Access Denied. Please check your permissions.';
$lang['err_admin_add_playlist_no_name'] = 'Error: no name given';
$lang['err_playlist_not_found'] = 'Error: the specified playlist was not found';
$lang['err_uploads_module_not_installed'] = 'Error: the Uploads module is not installed';
$lang['err_no_uploads_categories_defined'] = 'Error: there are no Uploads categories';
$lang['err_no_mp3s_found'] = 'Error: no .mp3 files found in the Uploads categories';
$lang['err_no_playlist_specified'] = 'Error: no playlist was specified';
$lang['err_no_song_specified'] = 'Error: no song (upload ID) was specified';
$lang['err_no_playlist_or_song_specified'] = 'Error: no song or playlist parameter given';

$lang['help_drag_drop'] = 'use drag and drop to add/remove songs and define the song order';

$lang['help_parameter_count_downloads'] = 'Whether each song played should be counted as a download in the Uploads module. When unset, direct links to the MP3 files will be used (unless no_direct_downloads is enabled).';
$lang['help_parameter_no_direct_downloads'] = 'Enable this to prevent someone finding out the direct download location of your MP3 files by accessing the playlist XSPF/XML file directly. Enabling this will disable the count_downloads parameter (downloads are always counted).';
$lang['help_parameter_playlist'] = 'playlist id to play';
$lang['help_parameter_song'] = 'upload_id of a single song to play instead of a playlist';
$lang['help_parameter_song_title'] = 'The text to replace the players default\'s. Only used when the song parameter is also supplied.';
$lang['help_parameter_player'] = 'the xspf player version to use (slim or extended)';
$lang['help_parameter_extended_player_url'] = 'the url of the extended version of the xspf player';
$lang['help_parameter_slim_player_url'] = 'the url of the slim version of the xspf player';
$lang['help_parameter_player_width'] = 'width of the player in pixels';
$lang['help_parameter_slim_player_height'] = 'height of the slim player in pixels';
$lang['help_parameter_extended_player_height'] = 'height of the extended player in pixels';
$lang['help_parameter_autoresume'] = 'boolean value that makes the player remember it\'s position';
$lang['help_parameter_autoplay'] = 'boolean value that makes the playlist load and the music start without the initial user click';
$lang['help_parameter_autoload'] = 'boolean value that makes the playlist load without the initial user click';
$lang['help_parameter_repeat_playlist'] = 'boolean value that makes the player repeat the playlist after the end of the last song';

$lang['help_parameter_alpha'] = 'percent of color change, only works with custom color';
$lang['help_parameter_alphabetize'] = 'boolean value to alphabetize playlist';
$lang['help_parameter_buffer'] = 'seconds to preload video before playing, exclude for automatic';
$lang['help_parameter_color'] = 'six digit hex value to change the players color';
$lang['help_parameter_gotoany'] = 'boolean value that forces travel to unknown URLs';
$lang['help_parameter_image'] = 'url for a jpg image that is shown when autoplay is off';
$lang['help_parameter_info_button_text'] = 'the text to display on the info link, <a href=http://musicplayer.sourceforge.net/test/info-test.html>see this page</a>';
$lang['help_parameter_infourl'] = 'global info url for all songs, replaces playlist info urls';
$lang['help_parameter_loadurl'] = 'url linking to a text file containing all variables. cuts down on html coding and file sizes, one file can be used by many players';
$lang['help_parameter_load_message'] = 'message displayed after autoload';
$lang['help_parameter_main_image'] = 'global image url, replaces all playlist images';
$lang['help_parameter_mainurl'] = 'right-click "about" url';
$lang['help_parameter_no_continue'] = 'boolean value to turn off automatic song changing';
$lang['help_parameter_player_title'] = 'the text to replace the players default\'s';
$lang['help_parameter_repeat'] = 'boolean value to set repeat';
$lang['help_parameter_repeat_playlist'] = 'boolean value to repeat the playlist';
$lang['help_parameter_setup'] = 'boolean value to turn on special manager features such as auto-update. more to come.';
$lang['help_parameter_shuffle'] = 'boolean value to set shuffle';
$lang['help_parameter_start_track'] = 'track number for beginning track';
$lang['help_parameter_statsurl'] = 'url to an external script that can collect POST values. Can collect playSong and annotation';
$lang['help_parameter_timedisplay'] = 'numerical value to show time counter; 0:off, 1:all, 2:elapsed, 3:duration, 4:countdown';
$lang['help_parameter_useId3'] = 'boolean value that forces id3 tag use in the slim player. Can be helpful, but not recommended';
$lang['help_parameter_volume_level'] = 'starting volume level';

$lang['event_info_XSPFSongAdded'] = 'An event generated when a song is added';
$lang['event_help_XSPFSongAdded'] = '<p>An event generated when a song is added</p>
<h4>Parameters</h4>
<ul>
<li><em>song_name</em> - The new song name</li>
</ul> 
';
$lang['event_info_XSPFSongAdded'] = 'An event generated when a song is added';
$lang['event_help_XSPFSongAdded'] = '<p>An event generated when a song is added</p>
<h4>Parameters</h4>
<ul>
<li><em>song_name</em> - The new song name</li>
</ul> 
';
$lang['event_info_XSPFSongChanged'] = 'An event generated when a song is modified';
$lang['event_help_XSPFSongChanged'] = '<p>An event generated when a song is modified</p>
<h4>Parameters</h4>
<ul>
<li><em>song_id</em> - The song id</li>
<li><em>song_name</em> - The new song name</li>
</ul> 
';
$lang['event_info_XSPFSongDeleted'] = 'An event generated when a song is deleted';
$lang['event_help_XSPFSongDeleted'] = '<p>An event generated when a song is deleted</p>
<h4>Parameters</h4>
<ul>
<li><em>song_id</em> - The song id</li>
</ul> 
';

$lang['moddescription'] = 'Enhanced XSPF Web Music Player - play MP3 on your CMS Made Simple website';
$lang['changelog'] = '
<ul>
	<li>Version 0.4 Februari 2007 (dittmann). 
		<ul>
			<li>Fixed the playlist not working correctly with CMS Made Simple 1.0.2 and 1.0.3</li>
		</ul>
	</li>
	<li>Version 0.3 Februari 2007 (dittmann). 
		<ul>
			<li>Added support for images using Uploads thumbnails</li>
		</ul>
	</li>
	<li>Version 0.2 Februari 2007 (dittmann). 
		<ul>
			<li>Added song parameter to play a single song</li>
			<li>Added count_downloads parameter</li>
			<li>Playlist songs can now be selected from all Uploads categories</li>
			<li>Added no_direct_downloads preference</li>
		</ul>
	</li>
	<li>Version 0.1 Januari 2007 (dittmann). 
		<ul>
		    <li>Initial module release</li>
		</ul>
	</li>
</ul>';
$lang['help'] = '<h3>What Does This Do?</h3>
<p>
	With this module you can manage <a href="http://www.xspf.org">XSPF</a> playlists to use with a xspf music player. <a href="http://www.boutell.com/xspf/">Enhanced XSPF player</a> is provided with the module.</p>
<p>
	The module uses the Uploads "Summary" field as the song &lt;title> in the playlist XPSF/XML, the "Author" field is used as &lt;creator> and the "Description" field can be used to supply an &lt;info> link.<br />
	When a thumbnail is used for the MP3 in the Uploads module (must be JPG) it will be used as &lt;image>.
</p>
<h3>How Do I Use It</h3>
<p>
	Upload the mp3 files you want to play (and their thumbnails) using the Uploads module. Then include the module somewhere in your template(s) (or on a single page), using either the song or the playlist parameter.
</p>
<p>
	<strong>To play a single song</strong><br />
	Provide the file ID from the Uploads module as song parameter - the module call will look something like this: {cms_module module=EnhancedXSPF song=4}
<p>
	<strong>To play a playlist</strong><br />
	Create one or more playlists from the module admin and provide the playlist ID as playlist parameter - the module call will look something like this: {cms_module module=EnhancedXSPF playlist=1}
	
</p>
<p>
	<strong>Use only the playlist</strong><br />
	To download the XSPF file, or to use the playlist from outside CMSMS - for example from a frame (for playback without pauses when the page is changed) - you can call the playlist seperately, providing a playlist parameter.<br />
	The playlist_url would look something like this: http://www.example.com/modules/EnhancedXSPF/playlist.xml.php?playlist=1<br />
	To disable download counts: http://www.example.com/modules/EnhancedXSPF/playlist.xml.php?playlist=1&count_downloads=0 (note: this will not work when the module no_direct_downloads preference is set from the admin).
</p>
<h3>XSPF Player parameters</h3>
<p>
	All player parameters (see also xspf/xspfdoc.html inside the module directory) can be passed to the module and will be used in the player call.<br />
</p>
<h3>Support</h3>
<p>There is a number of resources available to help you with this module:
<ul>
<li>Additional discussion of this module may also be found in the <a href="http://forum.cmsmadesimple.org">CMS Made Simple Forums</a>.</li>
<li>The author, Dick Ittmann, can often be found as DeeEye in the <a href="http://cmsmadesimple.org/main/support/IRC">CMS IRC Channel</a>.</li>
</ul>
</p>
<p>As per the GPL, this software is provided as-is. Please read the text
of the license for the full disclaimer.</p>

<h3>Copyright and License</h3>
<p>Copyright &copy; 2007, Dick Ittmann. All Rights Are Reserved.</p>
<p>This module has been released under the <a href="http://www.gnu.org/licenses/licenses.html#GPL">GNU Public License</a>. You must agree to this license before using the module.</p>
';

?>
