<?php
if (isSet($params['submit'])) {
	$this->products->Create($params);
	$this->products->CreateCategoryMap($params['category_id'], $params['product_id']);
	
	//$params = array('product_id'=>$params['product_id']);
	//$this->Redirect( $id, 'product_edit', $returnid, $params );
	$params = array('active_tab'=>'categories',
	                'current_category_id'=>$params['current_category_id']);
	$this->Redirect( $id, 'defaultadmin', $returnid, $params );
}
if (isset($params['cancel'])) {
	$params = array('active_tab'=>'categories',
	                'current_category_id'=>$params['current_category_id']);
	$this->Redirect( $id, 'defaultadmin', $returnid, $params );
}

$product = array();
$product['startform'] = $this->CreateFormStart( $id, 'product_add', $returnid, 'post', 'multipart/form-data');
$product['submit'] = $this->CreateInputSubmit ($id, 'submit', $this->Lang('continue'));
$product['cancel'] = $this->CreateInputSubmit ($id, 'cancel', $this->Lang('cancel'));
$product['endform'] = $this->CreateFormEnd();

$product['current_category_id'] = array(
	'label'=>'',
	'input'=>$this->CreateInputHidden( $id, 'current_category_id', $params['current_category_id'])
);

$product['category_id'] = array(
	'label'=>$this->Lang('label_product_category_id'),
	'input'=>$this->CreateInputDropdown( $id, 'category_id', $this->categories->BuildList($params['current_category_id'], '', 0), -1, intval($params['current_category_id']))
);

$product['name'] = array(
	'label'=>$this->Lang('label_product_name'),
	'input'=>$this->CreateInputText( $id, 'name', '', 40, 40)
);
$product['description'] = array(
	'label'=>$this->Lang('label_product_description'),
	'input'=>$this->CreateTextArea(true, $id, '', 'description', 'pagesmalltextarea', '', '', '', 40, 40)
);
$product['price'] = array(
	'label'=>$this->Lang('label_product_price'),
	'input'=>$this->CreateInputText( $id, 'price', '', 40, 40)
);
$product['active'] = array(
	'label'=>$this->Lang('label_product_active'),
	'input'=>$this->CreateInputCheckbox( $id, 'active', 1)
);
$product['featured'] = array(
	'label'=>$this->Lang('label_product_featured'),
	'input'=>$this->CreateInputCheckbox( $id, 'featured', 1)
);
$product['netweight'] = array(
	'label'=>$this->Lang('label_product_netweight'),
	'input'=>$this->CreateInputText( $id, 'netweight', '', 10, 20),
	'unit'=>$this->GetPreference('weightunitmeasure', 'Kg')
);
// Prepare list of possible VAT codes as set up in Cart Made Simple
$cartms =& $this->GetModuleInstance('CartMadeSimple');
if( $cartms ) { 
	$listvatcode[$cartms->GetPreference('vat0name', '')] = '0';
	$listvatcode[$cartms->GetPreference('vat1name', '')] = '1';
	$listvatcode[$cartms->GetPreference('vat2name', '')] = '2';
	$listvatcode[$cartms->GetPreference('vat3name', '')] = '3';
	$listvatcode[$cartms->GetPreference('vat4name', '')] = '4';
	$product['vatcode'] = array(
		'label'=>$this->Lang('label_product_vatcode'),
		'input'=>$this->CreateInputDropdown( $id, 'vatcode', $listvatcode, -1, $vatcode)
	);
}
else {
	$product['vatcode'] = array(
		'label'=>$this->Lang('label_product_vatcode'),
		'input'=>$this->CreateInputText( $id, 'vatcode', '', 1, 1)
	);
}

$product['position'] = array(
	'label'=>$this->Lang('label_product_position'),
	'input'=>$this->CreateInputText( $id, 'position', '', 40, 40)
);

$smarty->assign('product', $product);
echo $this->ProcessTemplate('product_add.tpl');

?>