<?php

if (!isset($gCms)) exit;

$detailpage = '';
if (isset($params['detailpage']))
{
	$manager =& $gCms->GetHierarchyManager();
	$node =& $manager->sureGetNodeByAlias($params['detailpage']);
	if (isset($node))
	{
		$content =& $node->GetContent();
		if (isset($content))
		{
			$detailpage = $content->Id();
		}
	}
	else
	{
		$node =& $manager->sureGetNodeById($params['detailpage']);
		if (isset($node))
		{
			$detailpage = $params['detailpage'];
		}
	}
}

$config = $gCms->GetConfig();
$pathcat = $this->GetPreference('imagepath_category');
$pathproduct = $this->GetPreference('imagepath_product');
// Prepare settings for usage of cart
$cartMSInstalled = false;
$modulename = 'CartMadeSimple';

$cmsmodules = $gCms->modules;
if (isset($cmsmodules[$modulename]))
{
	if (isset($cmsmodules[$modulename]['object'])
		&& $cmsmodules[$modulename]['installed'] == true
		&& $cmsmodules[$modulename]['active'] == true ) {
		$cartMSInstalled = true;
	}
}

// Display information of the product
$query = "SELECT * FROM ".cms_db_prefix()."module_sms_products WHERE product_id = ?";
$row = $db->GetRow($query, array($params['product_id']));

if ($row)
{
	$this->smarty->assign('id', $row['product_id']);
	$this->smarty->assign('productname', $row['name']);
	$this->smarty->assign('description', $row['description']);
	$this->smarty->assign('price', $row['price']);
	// Get the first picture available for the product found
	$query = "SELECT * FROM ".cms_db_prefix()."module_sms_product_images WHERE product_id = ?";
	$picture = $db->GetRow($query, array($row['product_id']));
	if ($picture)
	{
		if (isset($picture['image']) && $picture['image'] != 'no_image.jpg') {
			$this->smarty->assign('image', $pathproduct.$picture['image']);
			$this->smarty->assign('imagedesc', $row['description']);
		}
		else {
			$this->smarty->assign('image', '*none');
		}
	}
	// Build link to cart
	if ($cartMSInstalled) {
		//$result = $cmsmodules[$modulename]['object']->DoAction('addproduct','',$params,$returnid);
		$this->smarty->assign('addproduct', $cmsmodules[$modulename]['object']->CreateLink( $id, 'cart', $returnid, 'add to cart', 
			array ('name'=>$row['name'],
				'perfaction' => 'add_product',
				'product_id' => $row['product_id'],
				'qty' => 1,
				'returnmod' => 'ShopMadeSimple'
			)));
	}
	
	$product_data = $this->products->Get($params['product_id']);
	$attribute = array();
	$attributes = array();
	// Check if there are any attributes for the current product. If not checked, the foreach runs into an error
	$desclength = 40;
	$attributes['itemcount'] = count($product_data['attributes']);
	if ($attributes['itemcount'] > 0) {
		foreach ($product_data['attributes'] as $attribute) {
			$attribute['name'] = $attribute['name'];
			if (strlen($attribute['description']) > $desclength) {
				$attribute['description'] = substr($attribute['description'], 0, $desclength).'...';
			}
			else {
				$attribute['description'] = $attribute['description'];
			}
			$product_attributes_list[] = $attribute;
		}
		$attributes['list'] = $product_attributes_list;
		// Now all the attributes are found, connect them for the front end
		$this->smarty->assign_by_ref('attributes', $attributes);

	}
}

$cur_symbol = $this->GetPreference('default_symbol');
$this->smarty->assign('cur_symbol', $this->GetPreference('default_symbol'));

// Display template
$template = 'proddetail_template';
// Currently only one template available, so next lines will not perform anything
if (isset($params['proddetailtemplate'])) {
	$template = $params['proddetailtemplate'];
}
echo $this->ProcessTemplateFromDatabase($template);
?>