<?php
// Usage: place {cms_module module='ShopMadeSimple'} somewhere in the template of a frontend page.

if (!isset($gCms)) exit;

#global $gCms;

if (isset($params['detailpage']))
  {
    $manager =& $gCms->GetHierarchyManager();
    $node =& $manager->sureGetNodeByAlias($params['detailpage']);
    if (isset($node))
      {
	$content =& $node->GetContent();	
	if (isset($content))
	  {
	    $detailpage = $content->Id();
	  }
      }
    else
      {
	$node =& $manager->sureGetNodeById($params['detailpage']);
	if (isset($node))
	  {
	    $detailpage = $params['detailpage'];
	  }
      }
  }

$db =& $gCms->GetDb();
$display = '';
if (isset($params['display']))
{
	$display = $params['display'];
}
else
{
	$display = 'categorylist';
}

$parentcategory = '0';
if (isset($params['parentcategory'])) {
	$parentcategory = $params['parentcategory'];
}

if (isset($params['catname'])) {
	$catname = $params['catname'];
}
else {
	$catname = 'root';
}

switch($display)
  {
 	case 'categorylist':
		#if ($catlevel == '0') { 
			// Prepare a list of categories at top level
			foreach ($this->categories->GetList( $parentcategory ) as $category) {
				if ($category['active'] == 1) {
					$onerow = new stdClass();
					// Check the number of active products connected to this category
					$query = 'SELECT count(*) as num_products FROM '.cms_db_prefix().'module_sms_product_category pc,
						'.cms_db_prefix().'module_sms_products p WHERE category_id=? AND pc.product_id = p.product_id AND 
						p.active = 1';
					$dbresult = $db->Execute( $query, array( $category['category_id']));
					$row = $dbresult->FetchRow();
					$num_products=$row['num_products'];
					// Include the number of products in the name of the category
					if ($num_products != 0) {
						$category['name'] = $category['name'] . ' ('.$num_products.')';
					}
					$sendtodetail = array('category_id'=>$category['category_id']);
					$prettyurl = 'ShopMadeSimple/'.$row['category_id'].'/'.($detailpage!=''?$detailpage:$returnid);
					if (isset($sendtodetail['detailtemplate']))
					{
						$prettyurl .= '/d,' . $sendtodetail['detailtemplate'];
					}
					$onerow->name  = $this->CreateLink($id, 'fe_category_list', $detailpage!=''?$detailpage:$returnid, 
						$category['name'], $sendtodetail,'', false, false, '', true, $prettyurl);
					$onerow->rowclass = $rowclass;
					$entryarray[] = $onerow;
				}
			}
			$this->smarty->assign_by_ref('items', $entryarray);

			$this->smarty->assign('startform', $this->CreateFrontendFormStart($id, $returnid, 'default'));
			$this->smarty->assign('endform', $this->CreateFormEnd());
			$this->smarty->assign('label_categories', $this->Lang('label_categories'));
			$this->smarty->assign('categories', $categories);
			// Display template
			$template = 'categories_template';
			// Currently only one template available, so next lines will not perform anything
			if (isset($params['categoriestemplate'])) {
				$template = $params['categoriestemplate'];
			}
			echo $this->ProcessTemplateFromDatabase($template);

			#echo $this->ProcessTemplate('box_categories.tpl');
		
 		break;

	case 'productlist':
		// Prepare a list of products for given category
		$catinfo = array();
		$catinfo = $this->categories->GetCatByName( $params['catname'] );
		$params['category_id'] = $catinfo['category_id'];
		$this->RedirectForFrontend( $id, $returnid, 'fe_category_list', $params, true);
 		break;
	case 'featured':
		// Prepare list of all featured products
		$params['action'] = '';
		$this->RedirectForFrontend( $id, $returnid, 'fe_products_featured', $params, false);
 		break;
	case 'productdetail':
		// Prepare details for given product
 		break;
	default:
 		echo $this->Lang('unknown_display', $display);
 		return;
  }

?>