<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Lytebox module for CMSMS - A simple wrapper to the Lytebox JavaScript class.
 *
 * PHP versions 4 and 5
 *
 * LICENSE:
 * Copyright (c) 2008, Carsten Wiedmann
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY AUTHOR OR CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @category   Modules
 * @package    Lytebox
 * @author     Carsten Wiedmann <carsten_sttgt@gmx.de>
 * @copyright  2008 Carsten Wiedmann
 * @license    http://www.freebsd.org/copyright/freebsd-license.html FreeBSD License
 * @version    SVN: $Id: action.default.php 14 2008-06-10 10:02:10Z wiedmann $
 * @link       http://dev.cmsmadesimple.org/projects/Lytebox
 */

if (!isset($gCms)) {
    exit;
}

if (!class_exists('Lytebox_ActionDefault')) {
    /**
     * Default action from the Lytebox module.
     *
     * Usage:
     * <ol>
     *     <li>
     *         <ul>
     *             <li>
     *                 In the page where you want use this module, add this to the page metadata:<br />
     *                 <samp>{stylesheet name='Module: Lytebox' media='screen'}</samp>
     *             </li>
     *             <li>Or you can attach the stylesheet &quot;Module: Lytebox&quot; to your template.</li>
     *         </ul>
     *     </li>
     *     <li><b>Image Content Examples</b>
     *         <ul>
     *             <li>Single Image Example (put this in your page content):<br />
     *                 <samp>{Lytebox href='uploads/images/image-1.jpg' title='Image Description' text='Image #1'}</samp>
     *             </li>
     *             <li>Grouped Images Example (put this in your page content):<br />
     *                 <samp>{Lytebox href='uploads/images/image-1.jpg' group='vacation' title='Mom and Dad' text='Mom and Dad'}</samp><br />
     *                 <samp>{Lytebox href='uploads/images/image-2.jpg' group='vacation' title='My Sister' text='My Sister'}</code>
     *             </li>
     *             <li>Slideshow Example (put this in your page content):<br />
     *                 <samp>{Lytebox href='uploads/images/image-1.jpg' group='vacation' display='show' title='Mom and Dad' text='Mom and Dad'}</samp><br />
     *                 <samp>{Lytebox href='uploads/images/image-2.jpg' group='vacation' display='show' title='My Sister' text='My Sister'}</samp>
     *             </li>
     *         </ul>
     *     </li>
     * </ol>
     *
     * (Description is taken from the {@link http://dolem.com/lytebox/ Lytebox homepage}.)
     *
     * @category   Modules
     * @package    Lytebox
     * @author     Carsten Wiedmann <carsten_sttgt@gmx.de>
     * @license    http://www.freebsd.org/copyright/freebsd-license.html  FreeBSD License
     * @version    Release: 0.2.1beta1
     * @link       http://dev.cmsmadesimple.org/projects/Lytebox
     * @see        Lytebox
     */
    class Lytebox_ActionDefault extends Lytebox
    {
        /**
         * contains the action to perform
         *
         * @var string
         * @access protected
         */
        var $name;

        /**
         * contains the module id
         *
         * @var string
         * @access protected
         */
        var $id;

        /**
         * contains the module parameters
         *
         * @var array
         * @access protected
         */
        var $params;

        /**
         * contains the module returnid
         *
         * @var string
         * @access protected
         */
        var $returnid;

        /**
         * Lytebox_ActionDefault()
         *
         * @param string &$name     Name of the action to perform
         * @param string &$id       the id for this module
         * @param array  &$params   the parameters targeted for this module
         * @param string &$returnid the returnid for this module
         *
         * @uses Lytebox()
         * @uses $name
         * @uses $id
         * @uses $params
         * @uses $returnid
         * @uses $countcalls
         *
         * @return void
         * @access public
         */
        function Lytebox_ActionDefault(&$name, &$id, &$params, &$returnid)
        {
            parent::Lytebox();

            $this->name     =& $name;
            $this->id       =& $id;
            $this->params   =& $params;
            $this->returnid =& $returnid;
        }

        /**
         * DoubleEntitiesDecode()
         *
         * @param string $value string which can contain double encoded entities
         *
         * @return string string with double encoded entities replaced with normal entities
         * @access protected
         */
        function DoubleEntitiesDecode($value)
        {
            $trans = array(
                '&amp;quot;' => '&quot;',
                '&amp;#39;'  => '&#39;',
                '&amp;lt;'   => '&lt;',
                '&amp;gt;'   => '&gt;',
                '&amp;amp;'  => '&amp;',
            );
            $value = strtr($value, $trans);
            
            return $value;
        }

        /**
         * DoAction()
         *
         * @uses CreateFrontendLink()
         * @uses ProcessTemplateFromData()
         * @uses DoubleEntitiesDecode()
         * @uses $config
         * @uses $smarty
         * @uses $id
         * @uses $returnid
         * @uses $params
         * @uses $countcalls
         *
         * @return string
         * @access public
         */
        function DoAction()
        {
            /*
             * load the Javascript
             */
            if (0 < $this->countcalls) {
                $this->smarty->clear_assign('Lytebox_loadscript');
            } else {
                /*
                 * create javascript configuration
                 */
                $scriptparams = array();

                /* Lytebox Global Configuration */
                $scriptparams[0] = empty($this->params['theme']) ? 'grey' : trim($this->params['theme']);
                $scriptparams[1] = !isset($this->params['hideFlash']) ? 1 : $this->params['hideFlash'];
                $scriptparams[2] = !isset($this->params['outerBorder']) ? 1 : $this->params['outerBorder'];
                $scriptparams[3] = !isset($this->params['resizeSpeed']) ? 8 : $this->params['resizeSpeed'];
                $scriptparams[4] = !isset($this->params['maxOpacity']) ? 80 : $this->params['maxOpacity'];
                $scriptparams[5] = !isset($this->params['navType']) ? 1 : $this->params['navType'];
                $scriptparams[6] = !isset($this->params['autoResize']) ? 1 : $this->params['autoResize'];
                $scriptparams[7] = !isset($this->params['doAnimations']) ? 1 : $this->params['doAnimations'];
                $scriptparams[8] = !isset($this->params['borderSize']) ? 12 : $this->params['borderSize'];

                /* Lytebox Slideshow Options */
                $scriptparams[9]  = !isset($this->params['slideInterval']) ? 4000 : $this->params['slideInterval'];
                $scriptparams[10] = !isset($this->params['showNavigation']) ? 1 : $this->params['showNavigation'];
                $scriptparams[11] = !isset($this->params['showClose']) ? 1 : $this->params['showClose'];
                $scriptparams[12] = !isset($this->params['showDetails']) ? 1 : $this->params['showDetails'];
                $scriptparams[13] = !isset($this->params['showPlayPause']) ? 1 : $this->params['showPlayPause'];
                $scriptparams[14] = !isset($this->params['autoEnd']) ? 1 : $this->params['autoEnd'];
                $scriptparams[15] = !isset($this->params['pauseOnNextClick']) ? 0 : $this->params['pauseOnNextClick'];
                $scriptparams[16] = !isset($this->params['pauseOnPrevClick']) ? 1 : $this->params['pauseOnPrevClick'];

                $scriptparams = base64_encode(implode(',', $scriptparams));
                $scriptparams = array(
                    'config' => $scriptparams,
                    'showtemplate' => 'false',
                );

                /*
                 * create javascript link
                 */
                $scriptlink   = $this->CreateFrontendLink($this->id, $this->returnid, 'getjs', '', $scriptparams, '', true, true, '', true, '');
                $scriptlink   = ltrim(str_replace($this->config['root_url'], '', $scriptlink), '/');
                $this->smarty->assign('Lytebox_loadscript', "<script type=\"text/javascript\" src=\"{$scriptlink}\"></script>\n");
            }

            /*
             * set params for the hyperlink
             */
            if (empty($this->params['href'])) {
                return '';
            } else {
                $this->smarty->assign('Lytebox_href', trim($this->DoubleEntitiesDecode($this->params['href'])));
            }

            $this->smarty->clear_assign('Lytebox_frameattr');
            if (empty($this->params['display'])) {
                $this->smarty->assign('Lytebox_display', 'lytebox');
            } elseif ('frame' == $this->params['display']) {
                $this->smarty->assign('Lytebox_display', 'lyteframe');

                if (empty($this->params['frameattr'])) {
                    $this->smarty->assign('Lytebox_frameattr', 'width: 400px; height: 400px; scrolling: auto;');
                } else {
                    $this->smarty->assign('Lytebox_frameattr', trim($this->params['frameattr']));
                }
            } elseif ('show' == $this->params['display']) {
                $this->smarty->assign('Lytebox_display', 'lyteshow');
            } else {
                $this->smarty->assign('Lytebox_display', 'lytebox');
            }

            if (empty($this->params['group'])) {
                $this->smarty->assign('Lytebox_group', '');
            } else {
                $this->smarty->assign('Lytebox_group', '['.trim($this->params['group']).']');
            }

            if (empty($this->params['text'])) {
                $this->smarty->assign('Lytebox_text', basename($this->params['href']));
            } else {
                $this->smarty->assign('Lytebox_text', trim($this->params['text']));
            }

            if (empty($this->params['title'])) {
                $this->smarty->assign('Lytebox_title', basename($this->params['href']));
            } else {
                $this->smarty->assign('Lytebox_title', trim($this->params['title']));
            }

            if (empty($this->params['extra'])) {
                $this->smarty->clear_assign('Lytebox_extra');
            } else {
                $this->smarty->assign('Lytebox_extra', trim($this->params['extra']));
            }

            /*
             * set params for the thumbnail
             */
            if (empty($this->params['thumbsrc'])) {
                $this->smarty->clear_assign('Lytebox_thumbsrc');
            } else {
                $this->smarty->assign('Lytebox_thumbsrc', trim($this->DoubleEntitiesDecode($this->params['thumbsrc'])));

                if (empty($this->params['thumbalt'])) {
                    $this->smarty->assign('Lytebox_thumbalt', basename($this->params['thumbsrc']));
                } else {
                    $this->smarty->assign('Lytebox_thumbalt', trim($this->params['extra']));
                }

                if (empty($this->params['thumbextra'])) {
                    $this->smarty->clear_assign('Lytebox_thumbextra');
                } else {
                    $this->smarty->assign('Lytebox_thumbextra', trim($this->params['thumbextra']));
                }
            }

            /*
             * output the hyperlink
             */
            $template = '{if isset($Lytebox_loadscript)}{$Lytebox_loadscript}{/if}<a href="{$Lytebox_href}" rel="{$Lytebox_display}{$Lytebox_group}"{if isset($Lytebox_frameattr)} rev="{$Lytebox_frameattr}"{/if} title="{$Lytebox_title}"{if isset($Lytebox_extra)} {$Lytebox_extra}{/if}>{if isset($Lytebox_thumbsrc)}<img src="{$Lytebox_thumbsrc}" title="{$Lytebox_title}" alt="{$Lytebox_thumbalt}"{if isset($Lytebox_thumbextra)} {$Lytebox_thumbextra}{/if} />{/if}{$Lytebox_text}</a>';
            $output   = $this->ProcessTemplateFromData($template);

            echo "\n".$output."\n";

            $this->countcalls++;
        }
    }
}

$action = new Lytebox_ActionDefault($name, $id, $params, $returnid);
$action->DoAction();

?>
