<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Lytebox module for CMSMS - A simple wrapper to the Lytebox JavaScript class.
 *
 * PHP versions 4 and 5
 *
 * LICENSE:
 * Copyright (c) 2008, Carsten Wiedmann
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY AUTHOR OR CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @category   Modules
 * @package    Lytebox
 * @author     Carsten Wiedmann <carsten_sttgt@gmx.de>
 * @copyright  2008 Carsten Wiedmann
 * @license    http://www.freebsd.org/copyright/freebsd-license.html FreeBSD License
 * @version    SVN: $Id: Lytebox.module.php 14 2008-06-10 10:02:10Z wiedmann $
 * @link       http://dev.cmsmadesimple.org/projects/Lytebox
 */

if (!isset($gCms)) {
    exit;
}

/**
 * Lytebox module for CMSMS - A simple wrapper to the Lytebox JavaScript class.
 *
 * @category   Modules
 * @package    Lytebox
 * @author     Carsten Wiedmann <carsten_sttgt@gmx.de>
 * @license    http://www.freebsd.org/copyright/freebsd-license.html  FreeBSD License
 * @version    Release: 0.2.1beta1
 * @link       http://dev.cmsmadesimple.org/projects/Lytebox
 * @see        CMSModule
 */
class Lytebox extends CMSModule
{

    /**
     * how often is are some module action called?
     *
     * @staticvar int
     * @access protected
     */
    var $countcalls;

    /**
     * GetAdminDescription()
     *
     * @uses Lang()
     *
     * @param string a description of what the admin link does
     * @access public
     */
    function GetAdminDescription()
    {
        return $this->Lang('admindescription');
    }

    /**
     * GetAuthor()
     *
     * @return string the name of the author
     * @access public
     */
    function GetAuthor()
    {
        return 'Carsten Wiedmann';
    }

    /**
     * GetAuthorEmail()
     *
     * @return string the email address of the author
     * @access public
     */
    function GetAuthorEmail()
    {
        return 'carsten_sttgt@gmx.de';
    }

    /**
     * GetChangeLog()
     *
     * @uses Lang()
     *
     * @return string the changelog for the module
     * @access public
     */
    function GetChangeLog()
    {
        return $this->Lang('changelog');
    }

    /**
     * GetDescription()
     *
     * @uses Lang()
     *
     * @param string a short description of the module
     * @access public
     */
    function GetDescription()
    {
        return $this->Lang('moddescription');
    }

    /**
     * GetHelp()
     *
     * @uses Lang()
     *
     * @return string the help for the module
     * @access public
     */
    function GetHelp()
    {
        return $this->Lang('help');
    }

    /**
     * GetName()
     *
     * @return string the name of the module
     * @access public
     */
    function GetName()
    {
        return 'Lytebox';
    }

    /**
     * GetVersion()
     *
     * @return string the version of the module
     * @access public
     */
    function GetVersion()
    {
        return '0.2.1beta1';
    }

    /**
     * InstallPostMessage()
     *
     * @uses Lang()
     *
     * @return string a message after a successful installation of the module
     * @access public
     */
    function InstallPostMessage()
    {
        return $this->Lang('postinstall');
    }

    /**
     * IsPluginModule()
     *
     * @return boolean true if the module should be treated as a plugin module
     * @access public
     */
    function IsPluginModule()
    {
        return true;
    }

    /**
     * MaximumCMSVersion()
     *
     * @return string the maximum version necessary to run this version of the module
     * @access public
     */
    function MaximumCMSVersion()
    {
        return '1.9.9';
    }

    /**
     * MinimumCMSVersion()
     *
     * @return string the minimum version necessary to run this version of the module
     * @access public
     */
    function MinimumCMSVersion()
    {
        return '1.2.0';
    }

    /**
     * UninstallPostMessage()
     *
     * @uses Lang()
     *
     * @return string a message after a successful uninstall of the module
     * @access public
     */
    function UninstallPostMessage()
    {
        return $this->Lang('postuninstall');
    }

    /**
     * UninstallPreMessage()
     *
     * @uses Lang()
     *
     * @return string a message before doing an uninstall
     * @access public
     */
    function UninstallPreMessage()
    {
        return $this->Lang('really_uninstall');
    }

    /**
     * Lytebox()
     *
     * @staticvar int countcalls  how often are some module action called?
     *
     * @uses CMSModule()
     *
     * @return void
     * @access public
     */
    function Lytebox()
    {
        parent::CMSModule();

        static $countcalls = 0;
        $this->countcalls =& $countcalls;
    }

    /**
     * SetParameters()
     *
     * @uses RegisterModulePlugin()
     * @uses RestrictUnknownParams()
     * @uses CreateParameter()
     * @uses SetParameterType()
     * @uses Lang()
     * @uses CLEAN_STRING
     * @uses CLEAN_INT
     * @uses CLEAN_NONE
     *
     * @return void
     * @access public
     */
    function SetParameters()
    {
        $this->RegisterModulePlugin();
        $this->RestrictUnknownParams();


        /*
         * setup module parameters
         */
        /* Tag Parameters */
        $this->CreateParameter('href', '', $this->Lang('help_href'), false);
        $this->SetParameterType('href', CLEAN_STRING);
        $this->CreateParameter('display', 'box', $this->Lang('help_display'), true);
        $this->SetParameterType('display', CLEAN_STRING);
        $this->CreateParameter('group', '', $this->Lang('help_group'), true);
        $this->SetParameterType('group', CLEAN_STRING);
        $this->CreateParameter('frameattr', 'width: 400px; height: 400px; scrolling: auto;', $this->Lang('help_frameattr'), true);
        $this->SetParameterType('frameattr', CLEAN_STRING);
        $this->CreateParameter('title', 'basename($href)', $this->Lang('help_title'), true);
        $this->SetParameterType('title', CLEAN_STRING);
        $this->CreateParameter('extra', '', $this->Lang('help_extra'), true);
        $this->SetParameterType('extra', CLEAN_NONE);
        $this->CreateParameter('text', 'basename($href)', $this->Lang('help_text'), true);
        $this->SetParameterType('text', CLEAN_STRING);
        $this->CreateParameter('thumbsrc', '', $this->Lang('help_thumbsrc'), true);
        $this->SetParameterType('thumbsrc', CLEAN_STRING);
        $this->CreateParameter('thumbalt', 'basename($thumbsrc)', $this->Lang('help_thumbalt'), true);
        $this->SetParameterType('thumbalt', CLEAN_STRING);
        $this->CreateParameter('thumbextra', '', $this->Lang('help_thumbextra'), true);
        $this->SetParameterType('thumbextra', CLEAN_NONE);

        /* Lytebox Global Configuration */
        $this->CreateParameter('theme', 'grey', $this->Lang('help_theme'), true);
        $this->SetParameterType('theme', CLEAN_STRING);
        $this->CreateParameter('hideFlash', 1, $this->Lang('help_hideFlash'), true);
        $this->SetParameterType('hideFlash', CLEAN_INT);
        $this->CreateParameter('outerBorder', 1, $this->Lang('help_outerBorder'), true);
        $this->SetParameterType('outerBorder', CLEAN_INT);
        $this->CreateParameter('resizeSpeed', 8, $this->Lang('help_resizeSpeed'), true);
        $this->SetParameterType('resizeSpeed', CLEAN_INT);
        $this->CreateParameter('maxOpacity', 80, $this->Lang('help_maxOpacity'), true);
        $this->SetParameterType('maxOpacity', CLEAN_INT);
        $this->CreateParameter('navType', 1, $this->Lang('help_navType'), true);
        $this->SetParameterType('navType', CLEAN_INT);
        $this->CreateParameter('autoResize', 1, $this->Lang('help_autoResize'), true);
        $this->SetParameterType('autoResize', CLEAN_INT);
        $this->CreateParameter('doAnimations', 1, $this->Lang('help_doAnimations'), true);
        $this->SetParameterType('doAnimations', CLEAN_INT);
        $this->CreateParameter('borderSize', 12, $this->Lang('help_borderSize'), true);
        $this->SetParameterType('borderSize', CLEAN_INT);

        /* Lytebox Slideshow Options */
        $this->CreateParameter('slideInterval', 4000, $this->Lang('help_slideInterval'), true);
        $this->SetParameterType('slideInterval', CLEAN_INT);
        $this->CreateParameter('showNavigation', 1, $this->Lang('help_showNavigation'), true);
        $this->SetParameterType('showNavigation', CLEAN_INT);
        $this->CreateParameter('showClose', 1, $this->Lang('help_showClose'), true);
        $this->SetParameterType('showClose', CLEAN_INT);
        $this->CreateParameter('showDetails', 1, $this->Lang('help_showDetails'), true);
        $this->SetParameterType('showDetails', CLEAN_INT);
        $this->CreateParameter('showPlayPause', 1, $this->Lang('help_showPlayPause'), true);
        $this->SetParameterType('showPlayPause', CLEAN_INT);
        $this->CreateParameter('autoEnd', 1, $this->Lang('help_autoEnd'), true);
        $this->SetParameterType('autoEnd', CLEAN_INT);
        $this->CreateParameter('pauseOnNextClick', 0, $this->Lang('help_pauseOnNextClick'), true);
        $this->SetParameterType('pauseOnNextClick', CLEAN_INT);
        $this->CreateParameter('pauseOnPrevClick', 1, $this->Lang('help_pauseOnPrevClick'), true);
        $this->SetParameterType('pauseOnPrevClick', CLEAN_INT);

        $this->CreateParameter('config', $this->Lang('help_config'), '', true);
        $this->SetParameterType('config', CLEAN_NONE);
    }
}

?>
