<?php
if (!isset($gCms)) exit;

if (! $this->CheckAccess("Manage Download"))
{
  return $this->DisplayErrorPage($id, $params, $returnid,$this->Lang('accessdenied'));
}

/* -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

Code for Download "Manage downloads categories" admin action

-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

Typically, this will display something from a template
or do some other task.

*/
$db = &$gCms->db;
$this->smarty->assign('debug_post',implode("<br/>",$_POST));
$this->smarty->assign('debug_prms',implode("<br/>",$params));

$this->smarty->assign('title_error',$this->Lang('title_error'));

/* POST Case (when modified data) */
if($params['submit_cat'] == $this->Lang('submit')) {
  $catid = intval($params['fid_cat']);
  $pcat = intval($params['pcat']);
  $nom = htmlentities($params['fnom_cat'],ENT_QUOTES);
  $descript = htmlentities($params['fdescript_cat'],ENT_QUOTES);

  if( is_numeric($catid) && is_numeric($pcat) && ($nom != "") && ($descript != "")) {
    $query = "UPDATE ".cms_db_prefix()."module_download_cats SET parent_id = '$pcat', nom = '$nom', description = '$descript' WHERE cat_id = '$catid'";
    $dbres = $db->Execute($query);
	echo $db->ErrorMsg().'<br/>';
    if( $dbres == false ) {
      $this->smarty->assign('message', $db->ErrorMsg());
      echo $this->ProcessTemplate('error.tpl');
    } else {
      $this->smarty->assign('title_op', $this->Lang('modify')." ".$this->Lang('la')." ".$this->Lang('categorie'));
      $this->smarty->assign('message', $this->Lang('succees'));
      echo $this->ProcessTemplate('adminSuccees.tpl');
	}
  } else {
    $this->smarty->assign('message', $this->Lang('error_params'));
    echo $this->ProcessTemplate('error.tpl');
  }
  

  /* Edit case (when page called by main admin page) */
} else if($params[$this->Lang('modify')]) {
  $this->smarty->assign('fid',$id);
  $catid = intval($params[$this->Lang('modify')]);
  $this->smarty->assign('action','modif');

  $this->smarty->assign('title_categories',$this->Lang('title_categories'));
  $this->smarty->assign('nom_cat',$this->Lang('nom_cat'));
  $this->smarty->assign('cat_ancetre',$this->Lang('cat_ancetre'));
  $this->smarty->assign('description',$this->Lang('description'));

  $cats[0] = Array("cat_id"=>0,"parent_id"=>0,"nom"=>$this->Lang('racine'));
  $query = "SELECT cat_id, parent_id, nom FROM ".cms_db_prefix()."module_download_cats";
  $res = $db->Execute($query);
  while($res && $row = $res->FetchRow()) {
    foreach($row AS $k => &$v) { $v = html_entity_decode($v,ENT_QUOTES); }
    $cats[$row['cat_id']] = $row;
  }
  $this->smarty->assign('categories', $cats);

  $query = "SELECT * FROM ".cms_db_prefix()."module_download_cats WHERE cat_id = $catid LIMIT 1;";
  $dbres = $db->Execute($query);
  if( $dbres == false ) {
    $this->smarty->assign('message', $db->ErrorMsg());
    echo $this->ProcessTemplate('error.tpl');
  }else {
    $cat = $dbres->FetchRow();
    foreach ($cat AS $k => &$v) { $v = html_entity_decode($v,ENT_QUOTES); }

	$this->smarty->assign('ccat_id',$cat['parent_id']);
    $this->smarty->assign('startform_cat', $this->CreateFormStart($id, 'EditDldCat', $returnid));
    $this->smarty->assign('fid_cat', $this->CreateInputHidden($id, 'fid_cat', $catid));
    $this->smarty->assign('fnom_cat', $this->CreateInputText($id, 'fnom_cat', $this->GetPreference('fnom_cat', $cat['nom']), 30));
    $this->smarty->assign('fdescript_cat', $this->CreateTextArea(true, $id, $cat['description'], 'fdescript_cat'));
    $this->smarty->assign('submit_cat', $this->CreateInputSubmit($id, 'submit_cat', $this->Lang('submit'), '', '', ''));
    $this->smarty->assign('endform_cat', $this->CreateFormEnd());

    echo $this->ProcessTemplate('adminEditDldCat.tpl');
  }

  /* delete case (no comment)*/
} else if($params[$this->Lang('supprimer')]) {
  $this->smarty->assign('action','suppr');
  $catid = intval($params[$this->Lang('supprimer')]);
  
  $this->smarty->assign('supprimer',$this->Lang('supprimer'));

  $query = "DELETE FROM ".cms_db_prefix()."module_download_cats WHERE cat_id = $catid LIMIT 1;";
  $db->Execute($query);
  echo $this->ProcessTemplate('adminEditDldCat.tpl');
} else {
  $this->smarty->assign('message', $this->Lang('error_params'));
  echo $this->ProcessTemplate('error.tpl');
}
?>