<?php
$lang['friendlyname'] = 'Shop Made Simple';
$lang['admin_description'] = 'This module forms the base of preparing a shop. It handles the products and their grouping. Images and attributes are available per product';
$lang['message_postinstall'] = 'Be sure to set "Use Shop Made Simple" permissions to use this module.';
$lang['message_postuninstall'] = 'If images have been added, they are not removed during uninstall.';
$lang['message_confirmuninstall'] = 'Really? You\'re sure you want to uninstall this module?';

// Common translations
$lang['installed'] = 'has been installed.';
$lang['uninstalled'] = 'has been uninstalled.';
$lang['upgraded'] = 'has been upgraded.';

$lang['cancel'] = 'Cancel';
$lang['submit'] = 'Submit';
$lang['done'] = 'Done';
$lang['update'] = 'Update';
$lang['continue'] = 'Continue';
$lang['addimage'] = 'Add Image';
$lang['addattribute'] = 'Add Attribute';
$lang['addcategory'] = 'Add Category';
$lang['deletecategory'] = 'Delete Category';
$lang['module_example_stylesheet']='Module: Shop Made Simple';

// Specific translations, per tab
$lang['label_tab_preferences'] = 'Preferences';
$lang['label_admin_name'] = 'Administrator Name';
$lang['label_admin_email'] = 'Administrator Email';
$lang['label_shop_name'] = 'Shop Name';
$lang['label_shop_phone'] = 'Shop Emergency Phone';
$lang['label_shop_online'] = 'Shop Online';
$lang['label_default_language'] = 'Default Language';
$lang['label_prices_incl_vat'] = 'Prices are inclusive VAT';
$lang['label_weight_unit_measure'] = 'Product weight in';
$lang['label_default_currency'] = 'Default Currency';
$lang['label_default_symbol'] = 'Default Currency Symbol';
$lang['label_imagepath_category'] = 'Path to category images';
$lang['label_imagepath_product'] = 'Path to product images';
$lang['preferencesupdated'] = 'Preferences have been updated';

$lang['label_tab_templates'] = 'Templates';
$lang['label_categories_template'] = 'Categories';
$lang['label_catlist_template'] = 'Category & Products';
$lang['label_proddetail_template'] = 'Product detail';
$lang['label_prodfeat_template'] = 'Featured products';
$lang['templatesupdated'] = 'Templates have been updated';

$lang['label_tab_categories'] = 'Categories and Products';
$lang['label_current_category'] = 'Current Category';
$lang['label_categories'] = 'Categories';
$lang['label_category_id'] = 'Category';
$lang['label_category_parent'] = 'Parent Category';
$lang['label_category_name'] = 'Name';
$lang['label_category_description'] = 'Description';
$lang['label_category_image'] = 'Image';
$lang['label_category_active'] = 'Category is active ?';
$lang['label_category_position'] = 'List Order';

$lang['label_product_active'] = 'Product is active ?';
$lang['label_product_category'] = 'Products for';
$lang['label_product_category_id'] = 'Category';
$lang['label_product_description'] = 'Description';
$lang['label_product_featured'] = 'Feature this product';
$lang['label_product'] = 'Product';
$lang['label_product_id'] = 'ID';
$lang['label_product_image'] = 'Image';
$lang['label_product_name'] = 'Name';
$lang['label_product_position'] = 'List Order';
$lang['label_product_price'] = 'Price';
$lang['label_product_netweight'] = 'Nett Weight';
$lang['label_product_vatcode'] = 'VAT';

$lang['message_areyousurecategory'] = 'Are you sure you want to delete category: %s?';
$lang['message_areyousureproduct'] = 'Are you sure you want to delete product: %s?';
$lang['message_areyousureprodcat'] = 'Are you sure you want to disconnect this product: %s from category %s?';
$lang['text_add'] = 'Add';
$lang['text_category'] = 'Category';
$lang['text_product'] = 'Product';
$lang['properties_updated'] = 'Properties have been updated';

// Product Attributes tab
$lang['column_attribute_description'] = 'Description';
$lang['column_attribute_name'] = 'Name';
$lang['label_attribute_description'] = 'Description';
$lang['label_attribute_name'] = 'Name';
$lang['label_attributes_product_name'] = 'Attributes for product';
$lang['message_areyousureattribute'] = 'Are you sure you want to delete attribute: %s?';
$lang['message_attributeadded'] = 'Attribute: %s has been added';
$lang['message_attributedeleted'] = 'Attribute: %s has been deleted';
$lang['message_noattributetosave'] = 'No attribute information to save. No attribute added';
$lang['no_attributes_available'] = 'No attributes available';

// Product Images tab
$lang['column_image_description'] = 'Description';
$lang['column_image_name'] = 'Image file';
$lang['label_image_description'] = 'Description';
$lang['label_image_name'] = 'Name';
$lang['label_image_product_name'] = 'Images for product';
$lang['message_areyousureimage'] = 'Are you sure you want to delete image: %s?';
$lang['no_images_available'] = 'No images available';

$lang['label_tab_product'] = 'Product Details';
$lang['label_tab_product_categories'] = 'Categories';
$lang['label_tab_attributes'] = 'Attributes';
$lang['label_tab_images'] = 'Images';

$lang['message_imageadded'] = 'Image: %s has been added';
$lang['message_imagedeleted'] = 'Image: %s has been deleted';
$lang['message_noimagetoupload'] = 'No image to upload. No image added';
$lang['text_active'] = 'Set Active';
$lang['text_delete'] = 'Delete';
$lang['text_edit'] = 'Edit';
$lang['text_inactive'] = 'Set Inactive';

// Templates tab
$lang['label_tab_template'] = 'Templates';

// Frontend translations
$lang['textproductcount'] = 'Total %s product(s) found:';
$lang['textmore'] = ' ...';
$lang['productsoldout'] = 'Sold out';
$lang['pricesincurinvat'] = 'All prices in %s, including TAX/VAT';
$lang['pricesincurexvat'] = 'All prices in %s, excluding TAX/VAT';
$lang['unknown_display'] = 'Parameter display not defined in action.default.';

// Admin
$lang['helpcatname'] = 'Name of category. Must exactly match. If left blank, the products from the root category will be shown.';
$lang['helpdisplay'] = 'Specifies the type of display you want to show. There are currently two available:<ul>
	<li>categorylist (default) - shows a list of the categories and the number of products within category.</li>
	<li>productlist - show products from a named category.</li></ul>';
$lang['changelog'] = '<ul>
<li>Version 0.1.4 May 2008<br>
	Upload of image for category has been changed;<br>
	Changed install so directory path correct for categories and products.</li>
<li>Version 0.1.3 May 2008<br>
	All front end pages are handled by templates derived from admin part;<br>
	Administrator now has tab containing templates as used on front end;<br>
	Front end shows wether prices are incl. or excl. VAT dependent on preference;<br>
	Products connected to category sorted by list order;<br>
	Overview categories in back end and front end now sorted by list order.</li>
<li>Version 0.1.2 - May 1st 2008<br>
	When a category is deleted, its connected products will be connected to the root category.<br>
	Some buttons lacked proper translations.</li>
<li>Version 0.1.1 - April 2008<br>
	Now option to show products of one category in single pages using parameters.<br>
	Some fields turned into float to correctly handle decimals.<br>
	Dropped admin preferences to hold shop policies (use content block or normal CMSMS page with the policies).<br>
	Introduction of checkmark if prices are inclusive or exlcusive VAT in preferences.<br>
	Also in preferences now unit of measure for weights of the products.<br>
	Introduction of VAT code and nett weight per product. For calculation of (shipping) cost in Cart module</li>  
<li>Version 0.1.0 - April 18th 2008 Roll out version<br>
	Layout changes made</li>
<li>Version 0.0.4 - Import and Export Release<br>
	Categories<br>
	Products</li>
<li>Version 0.0.3 - Client Interface Release<br>
	Client interface tags<br>
Version 0.0.2 - Administration Extended Release
	Templates, Events, Orders, Translations<br>
Version 0.0.1 - Administration Release<br>
	Preferences - Completed on 24/12/2007<br>
	Categories - Completed on 25/12/2007<br>
	Products</li>
</ul>';
$lang['help'] = '
<h3>How Do I Use It</h3>
<p>
A visitor of the website will see a list of categories. You will be able to show a list of the categories by placing a smarty tag in a page or template using &#123;cms_module module=\'ShopMadeSimple\'}.<br> 
Currently there is one additional parameter. Using this parameter you are able to show products linked to a category.<br>
	An example is: {cms_module module=\'ShopMadeSimple\'  display=\'productlist\' catname=\'Gardentools\'}. This will show all products that are connected to the
	category name \'Gardentools\'.<br>
This will show the categories in the root. If one is selected, all the connected products are shown.<br>
<h3>Support</h3>
<p>This module does not include commercial support. However, there are a number of resources available to help you with it:</p>
<ul>
<li>For the latest version of this module, FAQs, or to file a Bug Report see the <a href="http://dev.cmsmadesimple.org/projects/sms">projects homepage</a>.</li>
<li>Commercial support is available via Duketown\'s module homepage at <a href="http://www.mantox.nl/dt">Duketown</a>.</li>
<li>Additional discussion of this module may also be found in the <a href="http://forum.cmsmadesimple.org">CMS Made Simple Forums</a>.</li>
<li>Lastly, you may have some success emailing the author directly.</li>
</ul>
<p>As per the GPL, this software is provided as-is. Please read the text
of the license for the full disclaimer.</p>

<h3>Copyright and License</h3>
<p>Copyright &copy; 2008.<br>
Authors:<ul>
	<li>Duketown: <a href="mailto:duketown@mantox.nl">&lt;duketown@mantox.nl&gt;</a></li>
	<li>Lahuindai: <a href="mailto:lahuindai@nobrain.co.za">&lt;lahuindai@nobrain.co.za&gt;</a></li>
</ul>
';
?>