<?php
if (isSet($params['submit'])) {
	require_once(dirname(__FILE__).'/../../lib/filemanager/ImageManager/Classes/Files.php');
	// Save the image name from being overwritten
	$image = $params['image'];
	
	/* Build the path we will be uploading the image to */
	$config = $gCms->GetConfig();
	$path = $config['image_uploads_path'].$this->GetPreference('imagepath_category');
	$files = new Files;

	$files->createFolder($path);
	foreach ($_FILES as $uploadfile) {
		// Replace any non-word characters by underscores
		$uploadfile['name'] = $files->escape($uploadfile['name']);
		$files->copyFile($uploadfile['tmp_name'], $path, $uploadfile['name'], true);
		$params['image'] = $uploadfile['name'];
	}
	// Restore the name of the image if no new image has been uploaded
	if ( $params['image'] == '' ) {
		$params['image'] = $image;
	}

	$this->categories->Update($params);
	
	$params = array('active_tab'=>'categories',
	                'current_category_id'=>$params['parent_id']);
	$this->Redirect( $id, 'defaultadmin', $returnid, $params );
}
if (isset($params['cancel'])) {
	$params = array('active_tab'=>'categories',
	                'current_category_id'=>$params['parent_id']);
	$this->Redirect( $id, 'defaultadmin', $returnid, $params );
}

$category = array();
$category['startform'] = $this->CreateFormStart( $id, 'category_edit', $returnid, 'post', 'multipart/form-data');
$category['submit'] = $this->CreateInputSubmit ($id, 'submit', $this->Lang('submit'));
$category['cancel'] = $this->CreateInputSubmit ($id, 'cancel', $this->Lang('cancel'));
$category['endform'] = $this->CreateFormEnd();
$category['category_id'] = array(
	'label'=>'',
	'input'=>$this->CreateInputHidden( $id, 'category_id', $params['category_id'])
);
$category['parent_id'] = array(
	'label'=>$this->Lang('label_category_parent'),
	'input'=>$this->CreateInputDropdown( $id, 'parent_id', $this->categories->BuildList(), -1, intval($params['parent_id']))
);
$category['name'] = array(
	'label'=>$this->Lang('label_category_name'),
	'input'=>$this->CreateInputText( $id, 'name', $params['name'], 40, 40)
);
$category['description'] = array(
	'label'=>$this->Lang('label_category_description'),
	'input'=>$this->CreateTextArea(true, $id, $params['description'], 'description','pagesmalltextarea','','','',40,40)
);
$category['image'] = array(
	'label'=>$this->Lang('label_category_image'),
	'input'=>$this->CreateInputText( $id, 'image', $params['image'], 40, 40).' '.$this->CreateInputFile( $id, 'new_image', '', 40)
);
$category['active'] = array(
	'label'=>$this->Lang('label_category_active'),
	'input'=>$category_active = $this->CreateInputCheckbox( $id, 'active', 1, $params['active'])
);
$category['position'] = array(
	'label'=>$this->Lang('label_category_position'),
	'input'=>$this->CreateInputText( $id, 'position', $params['position'], 40, 40)
);
$smarty->assign('category', $category);
echo $this->ProcessTemplate('category_edit.tpl');
?>