<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Lytebox module for CMSMS - A simple wrapper to the Lytebox JavaScript class.
 *
 * PHP versions 4 and 5
 *
 * LICENSE:
 * Copyright (c) 2008, Carsten Wiedmann
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY AUTHOR OR CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @category   Modules
 * @package    Lytebox
 * @author     Carsten Wiedmann <carsten_sttgt@gmx.de>
 * @copyright  2008 Carsten Wiedmann
 * @license    http://www.freebsd.org/copyright/freebsd-license.html FreeBSD License
 * @version    SVN: $Id: method.upgrade.php 2 2008-05-08 00:35:02Z wiedmann $
 * @link       http://dev.cmsmadesimple.org/projects/Lytebox
 */

if (!isset($gCms)) {
    exit;
}

/**
 * Upgrades the Lytebox module.
 *
 * @category   Modules
 * @package    Lytebox
 * @author     Carsten Wiedmann <carsten_sttgt@gmx.de>
 * @license    http://www.freebsd.org/copyright/freebsd-license.html  FreeBSD License
 * @version    Release: 0.1.0dev1
 * @link       http://dev.cmsmadesimple.org/projects/Lytebox
 * @see        Lytebox
 */
class Lytebox_Uninstall extends Lytebox
{
    /**
     * contains the version of the old module
     *
     * @var string
     * @access protected
     */
    var $oldversion;

    /**
     * contains the version of the new module
     *
     * @var string
     * @access protected
     */
    var $newversion;

    /**
     * Lytebox_Upgrade()
     *
     * @param string &$oldversion The version we are upgrading from
     * @param string &$newversion The version we are upgrading to
     *
     * @uses Lytebox()
     * @uses $oldversion
     * @uses $newversion
     *
     * @return void
     * @access public
     */
    function Lytebox_Upgrade(&$oldversion, &$newversion)
    {
        parent::Lytebox();

        $this->oldversion =& $oldversion;
        $this->newversion =& $newversion;
    }

    /**
     * DoUpgrade()
     *
     * @uses Audit()
     * @uses Lang()
     * @uses GetVersion()
     * @uses $oldversion
     *
     * @return void
     * @access public
     */
    function DoUpgrade()
    {
        /*
         * make the upgrade tasks
         */
        switch ($this->oldversion) {
        default:
             break;
        }

        /*
         * put mention into the admin log
         */
        $this->Audit( 0, $this->Lang('friendlyname'), $this->Lang('upgraded', $this->GetVersion()));
    }
}

$upgrade = new Lytebox_Upgrade($oldversion, $newversion);
$upgrade->DoUpgrade();

?>
