<?php

/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * Lytebox module for CMSMS - A simple wrapper to the Lytebox JavaScript class.
 *
 * PHP versions 4 and 5
 *
 * LICENSE:
 * Copyright (c) 2008, Carsten Wiedmann
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY AUTHOR OR CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @category   Modules
 * @package    Lytebox
 * @author     Carsten Wiedmann <carsten_sttgt@gmx.de>
 * @copyright  2008 Carsten Wiedmann
 * @license    http://www.freebsd.org/copyright/freebsd-license.html FreeBSD License
 * @version    SVN: $Id: method.install.php 2 2008-05-08 00:35:02Z wiedmann $
 * @link       http://dev.cmsmadesimple.org/projects/Lytebox
 */

if (!isset($gCms)) {
    exit;
}

/**
 * Installs the Lytebox module.
 *
 * @category   Modules
 * @package    Lytebox
 * @author     Carsten Wiedmann <carsten_sttgt@gmx.de>
 * @license    http://www.freebsd.org/copyright/freebsd-license.html  FreeBSD License
 * @version    Release: 0.1.0dev1
 * @link       http://dev.cmsmadesimple.org/projects/Lytebox
 * @see        Lytebox
 */
class Lytebox_Install extends Lytebox
{
    /**
     * Lytebox_Install()
     *
     * @param object &$gCms the gCms object
     *
     * @uses Lytebox()
     *
     * @return void
     * @access public
     */
    function Lytebox_Install()
    {
        parent::Lytebox();
    }

    /**
     * GetStylesheet()
     *
     * @author  Markus F. Hay
     * @license http://creativecommons.org/licenses/by/3.0/ Creative Commons Attribution 3.0 License
     * @version Release: 3.22
     * @link    http://dolem.com/lytebox/
     *
     * @return string the stylesheet content
     * @access protected
     */
    function GetStylesheet()
    {
        $stylesheetcontent = <<<EOT
#lbOverlay { position: fixed; top: 0; left: 0; z-index: 99998; width: 100%; height: 500px; }
    #lbOverlay.grey { background-color: #000000; }
    #lbOverlay.red { background-color: #330000; }
    #lbOverlay.green { background-color: #003300; }
    #lbOverlay.blue { background-color: #011D50; }
    #lbOverlay.gold { background-color: #666600; }

#lbMain { position: absolute; left: 0; width: 100%; z-index: 99999; text-align: center; line-height: 0; }
#lbMain a img { border: none; }

#lbOuterContainer { position: relative; background-color: #fff; width: 200px; height: 200px; margin: 0 auto; }
    #lbOuterContainer.grey { border: 3px solid #888888; }
    #lbOuterContainer.red { border: 3px solid #DD0000; }
    #lbOuterContainer.green { border: 3px solid #00B000; }
    #lbOuterContainer.blue { border: 3px solid #5F89D8; }
    #lbOuterContainer.gold { border: 3px solid #B0B000; }

#lbDetailsContainer {   font: 10px Verdana, Helvetica, sans-serif; background-color: #fff; width: 100%; line-height: 1.4em; overflow: auto; margin: 0 auto; }
    #lbDetailsContainer.grey { border: 3px solid #888888; border-top: none; }
    #lbDetailsContainer.red { border: 3px solid #DD0000; border-top: none; }
    #lbDetailsContainer.green { border: 3px solid #00B000; border-top: none; }
    #lbDetailsContainer.blue { border: 3px solid #5F89D8; border-top: none; }
    #lbDetailsContainer.gold { border: 3px solid #B0B000; border-top: none; }

#lbImageContainer, #lbIframeContainer { padding: 10px; }
#lbLoading { position: absolute; top: 45%; left: 0%; height: 32px; width: 100%; text-align: center; line-height: 0; background: url(modules/Lytebox/images/loading.gif) center no-repeat; }

#lbHoverNav { position: absolute; top: 0; left: 0; height: 100%; width: 100%; z-index: 10; }
#lbImageContainer>#lbHoverNav { left: 0; }
#lbHoverNav a { outline: none; }

#lbPrev { width: 49%; height: 100%; background: transparent url(modules/Lytebox/images/blank.gif) no-repeat; display: block; left: 0; float: left; }
    #lbPrev.grey:hover, #lbPrev.grey:visited:hover { background: url(modules/Lytebox/images/prev_grey.gif) left 15% no-repeat; }
    #lbPrev.red:hover, #lbPrev.red:visited:hover { background: url(modules/Lytebox/images/prev_red.gif) left 15% no-repeat; }
    #lbPrev.green:hover, #lbPrev.green:visited:hover { background: url(modules/Lytebox/images/prev_green.gif) left 15% no-repeat; }
    #lbPrev.blue:hover, #lbPrev.blue:visited:hover { background: url(modules/Lytebox/images/prev_blue.gif) left 15% no-repeat; }
    #lbPrev.gold:hover, #lbPrev.gold:visited:hover { background: url(modules/Lytebox/images/prev_gold.gif) left 15% no-repeat; }

#lbNext { width: 49%; height: 100%; background: transparent url(modules/Lytebox/images/blank.gif) no-repeat; display: block; right: 0; float: right; }
    #lbNext.grey:hover, #lbNext.grey:visited:hover { background: url(modules/Lytebox/images/next_grey.gif) right 15% no-repeat; }
    #lbNext.red:hover, #lbNext.red:visited:hover { background: url(modules/Lytebox/images/next_red.gif) right 15% no-repeat; }
    #lbNext.green:hover, #lbNext.green:visited:hover { background: url(modules/Lytebox/images/next_green.gif) right 15% no-repeat; }
    #lbNext.blue:hover, #lbNext.blue:visited:hover { background: url(modules/Lytebox/images/next_blue.gif) right 15% no-repeat; }
    #lbNext.gold:hover, #lbNext.gold:visited:hover { background: url(modules/Lytebox/images/next_gold.gif) right 15% no-repeat; }

#lbPrev2, #lbNext2 { text-decoration: none; font-weight: bold; }
    #lbPrev2.grey, #lbNext2.grey, #lbSpacer.grey { color: #333333; }
    #lbPrev2.red, #lbNext2.red, #lbSpacer.red { color: #620000; }
    #lbPrev2.green, #lbNext2.green, #lbSpacer.green { color: #003300; }
    #lbPrev2.blue, #lbNext2.blue, #lbSpacer.blue { color: #01379E; }
    #lbPrev2.gold, #lbNext2.gold, #lbSpacer.gold { color: #666600; }

#lbPrev2_Off, #lbNext2_Off { font-weight: bold; }
    #lbPrev2_Off.grey, #lbNext2_Off.grey { color: #CCCCCC; }
    #lbPrev2_Off.red, #lbNext2_Off.red { color: #FFCCCC; }
    #lbPrev2_Off.green, #lbNext2_Off.green { color: #82FF82; }
    #lbPrev2_Off.blue, #lbNext2_Off.blue { color: #B7CAEE; }
    #lbPrev2_Off.gold, #lbNext2_Off.gold { color: #E1E100; }

#lbDetailsData { padding: 0 10px; }
    #lbDetailsData.grey { color: #333333; }
    #lbDetailsData.red { color: #620000; }
    #lbDetailsData.green { color: #003300; }
    #lbDetailsData.blue { color: #01379E; }
    #lbDetailsData.gold { color: #666600; }

#lbDetails { width: 60%; float: left; text-align: left; }
#lbCaption { display: block; font-weight: bold; }
#lbNumberDisplay { float: left; display: block; padding-bottom: 1.0em; }
#lbNavDisplay { float: left; display: block; padding-bottom: 1.0em; }

#lbClose { width: 64px; height: 28px; float: right; margin-bottom: 1px; }
    #lbClose.grey { background: url(modules/Lytebox/images/close_grey.png) no-repeat; }
    #lbClose.red { background: url(modules/Lytebox/images/close_red.png) no-repeat; }
    #lbClose.green { background: url(modules/Lytebox/images/close_green.png) no-repeat; }
    #lbClose.blue { background: url(modules/Lytebox/images/close_blue.png) no-repeat; }
    #lbClose.gold { background: url(modules/Lytebox/images/close_gold.png) no-repeat; }

#lbPlay { width: 64px; height: 28px; float: right; margin-bottom: 1px; }
    #lbPlay.grey { background: url(modules/Lytebox/images/play_grey.png) no-repeat; }
    #lbPlay.red { background: url(modules/Lytebox/images/play_red.png) no-repeat; }
    #lbPlay.green { background: url(modules/Lytebox/images/play_green.png) no-repeat; }
    #lbPlay.blue { background: url(modules/Lytebox/images/play_blue.png) no-repeat; }
    #lbPlay.gold { background: url(modules/Lytebox/images/play_gold.png) no-repeat; }

#lbPause { width: 64px; height: 28px; float: right; margin-bottom: 1px; }
    #lbPause.grey { background: url(modules/Lytebox/images/pause_grey.png) no-repeat; }
    #lbPause.red { background: url(modules/Lytebox/images/pause_red.png) no-repeat; }
    #lbPause.green { background: url(modules/Lytebox/images/pause_green.png) no-repeat; }
    #lbPause.blue { background: url(modules/Lytebox/images/pause_blue.png) no-repeat; }
    #lbPause.gold { background: url(modules/Lytebox/images/pause_gold.png) no-repeat; }
EOT;

        return utf8_encode($stylesheetcontent);
    }

    /**
     * DoInstall()
     *
     * @uses GetStylesheetOperations()
     * @uses Stylesheet()
     * @uses InsertStylesheet()
     * @uses SetPreference()
     * @uses Audit()
     * @uses Lang()
     * @uses GetVersion()
     * @uses GetStylesheet()
     * @uses $cms
     *
     * @return void
     * @access public
     */
    function DoInstall()
    {

        /*
         * create new stylesheet
         */
        $stylesheetops =& $this->cms->GetStylesheetOperations();
        $stylesheet    =  new Stylesheet();

        $stylesheet->name       = 'Module: Lytebox';
        $stylesheet->value      = $this->GetStylesheet();
        $stylesheet->media_type = 'screen';

        /*
         * save stylesheet in database
         */
        $cssid = $stylesheetops->InsertStylesheet($stylesheet);
        $this->SetPreference('cssid', (string) $cssid);

        /*
         * put mention into the admin log
         */
        $this->Audit(0, $this->Lang('friendlyname'), $this->Lang('installed', $this->GetVersion()));
    }
}

$install = new Lytebox_Install($gCms);
$install->DoInstall();

?>
