<?php
# Module: Shop Made Simple - A product maintenance module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown <duketown@mantox.nl>
#
# This function will upgrade the module Shop Made Simple
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/sms
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

if (!isset($gCms)) exit;

$dict = NewDataDictionary($db);

$current_version = $oldversion;
switch($current_version)
{
	case '0.1.0':
		$dict = NewDataDictionary($db);
		$sqlarray = $dict->AlterColumnSQL(cms_db_prefix().'module_sms_products', 'price F' );
		$dict->ExecuteSQLArray($sqlarray);
		$sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_sms_products', 'netweight F' );
		$dict->ExecuteSQLArray($sqlarray);
		$sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_sms_products', 'vatcode C(1)' );
		$dict->ExecuteSQLArray($sqlarray);
		$sqlarray = $dict->AlterColumnSQL(cms_db_prefix().'module_sms_options', 'price F' );
		$dict->ExecuteSQLArray($sqlarray);
		// Shop policy to be taken from page or content block
		$this->RemovePreference('shop_description');
		// Introduce checkmark to state if prices are in- or excluding VAT
		$this->SetPreference('pricesinclvat', false);
		// All weight are in unit of measure as prepared in preferences
		$this->SetPreference('weightunitmeasure', 'Kg');

  		$current_version = '0.1.1';
		
	case '0.1.1':		

  		$current_version = '0.1.2';
		
	case '0.1.2':

		/**
		 * Create various templates
		 */
		# Setup category list template
		$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'fe_category_list.tpl';
		if( file_exists( $fn ) )
		{
			$template = @file_get_contents($fn);
			$this->SetTemplate('catlist_template',$template);
		}

		# Setup categories template
		$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'fe_categories.tpl';
		if( file_exists( $fn ) )
		{
			$template = @file_get_contents($fn);
			$this->SetTemplate('categories_template',$template);
		}

		# Setup product detail template
		$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'fe_product_detail.tpl';
		if( file_exists( $fn ) )
		{
			$template = @file_get_contents($fn);
			$this->SetTemplate('proddetail_template',$template);
		}

		# Setup featured products template
		$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'fe_products_featured.tpl';
		if( file_exists( $fn ) )
		{
			$template = @file_get_contents($fn);
			$this->SetTemplate('prodfeat_template',$template);
		}
		
  		$current_version = '0.1.3';
		
	case '0.1.3':

}

// Log the upgrade in the admin audit trail
$this->Audit( 0, $this->Lang('friendlyname'), $this->Lang('upgraded',$this->GetVersion()));

?>