<?php
if (!isset($gCms)) exit;
/**
 * Create all tables
 */
$this->categories->CreateTables();
/**
 * Insert some test data
 */
$category = array('parent_id'=>0,
                  'name'=>'Test 1',
                  'description'=>'Test 1 Top Level',
                  'image'=>'no_image.jpg',
                  'active'=>False,
                  'position'=>0);
$this->categories->Create($category);
$category = array('parent_id'=>0,
                  'name'=>'Test 2',
                  'description'=>'Test 2 Top Level',
                  'image'=>'no_image.jpg',
                  'active'=>False,
                  'position'=>0);
$this->categories->Create($category);
$category = array('parent_id'=>0,
                  'name'=>'Test 3',
                  'description'=>'Test 3 Top Level',
                  'image'=>'no_image.jpg',
                  'active'=>False,
                  'position'=>0);
$this->categories->Create($category);
$category = array('parent_id'=>1,
                  'name'=>'Test 1.1',
                  'description'=>'Test 1.1 Child Level',
                  'image'=>'no_image.jpg',
                  'active'=>False,
                  'position'=>0);
$this->categories->Create($category);
$category = array('parent_id'=>1,
                  'name'=>'Test 1.2',
                  'description'=>'Test 1.2 Child Level',
                  'image'=>'no_image.jpg',
                  'active'=>False,
                  'position'=>0);
$this->categories->Create($category);

/**
 * End test data
 */
$this->products->CreateTables();
#$this->translations->CreateTables();
/**
 * Create all preferences
 */
$this->SetPreference('admin_name', '<Administrator Name>');
$this->SetPreference('admin_email', '<Administrator Email>');
$this->SetPreference('shop_name', '<The name of the shop>');
$this->SetPreference('shop_phone', '<The contact number in case of emergencies>');
$this->SetPreference('shop_online', 'false');
$this->SetPreference('default_language', 'en_US');
$this->SetPreference('pricesinclvat', false);
$this->SetPreference('weightunitmeasure', 'Kg');
$this->SetPreference('default_currency', 'NZD');
$this->SetPreference('default_symbol', '$');
$this->SetPreference('imagepath_category', 'categories/');
/* TODO: Add the default preferences for image width and height for categories. */
$this->SetPreference('imagepath_product', 'products/');
/* TODO: Add the default preferences for image width and height for products. */
/**
 * Create an example stylesheet for Shop Made Simple tags
 */
$css_name = $this->Lang('module_example_stylesheet'); // Retrieve the name of the new stylesheet locate in the css directory
// Check if this model style sheet allready exists
$query = 'SELECT * FROM '. cms_db_prefix() .'css WHERE css_name = ?';
$dbresult = $db->Execute($query, array($css_name));
if( !$dbresult ) {
	$new_css_id = $db->GenID(cms_db_prefix() . "css_seq");
	$css_text = file_get_contents($this->cms->config['root_path'] . DIRECTORY_SEPARATOR . 'modules' . DIRECTORY_SEPARATOR . $this->GetName() . DIRECTORY_SEPARATOR . 'css' . DIRECTORY_SEPARATOR . 'stylesheet.css');
	$media_type = '';
	// Add the stylesheet to the database
	$query = "INSERT INTO " . cms_db_prefix() . "css (css_id, css_name, css_text, media_type, create_date, modified_date) VALUES (?, ?, ?, ?, ?, ?)";
	$result = $db->Execute($query, array($new_css_id, $css_name, $css_text, $media_type, $db->DBTimeStamp(time()), $db->DBTimeStamp(time())));
}

/**
 * Create security permissions
 */
$this->CreatePermission('Use ShopMadeSimple', 'Use Shop Made Simple');
$this->CreatePermission('Edit Preferences', 'Edit Preferences');
$this->CreatePermission('Add/Delete Category', 'Add/Delete Category');
$this->CreatePermission('Edit Category', 'Edit Category');
$this->CreatePermission('Add/Delete Products', 'Add/Delete Products');
$this->CreatePermission('Edit Products', 'Edit Products');
$this->CreatePermission('Add/Delete Translations', 'Add/Delete Translations');
$this->CreatePermission('Edit Translations', 'Edit Translations');
$this->CreatePermission('Add/Delete Templates', 'Add/Delete Templates');
$this->CreatePermission('Edit Templates', 'Edit Templates');

/**
 * Create various templates
 */
# Setup category list template
$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'fe_category_list.tpl';
if( file_exists( $fn ) )
{
	$template = @file_get_contents($fn);
	$this->SetTemplate('catlist_template',$template);
}

# Setup categories template
$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'fe_categories.tpl';
if( file_exists( $fn ) )
{
	$template = @file_get_contents($fn);
	$this->SetTemplate('categories_template',$template);
}

# Setup product detail template
$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'fe_product_detail.tpl';
if( file_exists( $fn ) )
{
	$template = @file_get_contents($fn);
	$this->SetTemplate('proddetail_template',$template);
}

# Setup featured products template
$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'fe_products_featured.tpl';
if( file_exists( $fn ) )
{
	$template = @file_get_contents($fn);
	$this->SetTemplate('prodfeat_template',$template);
}

$this->Audit( 0, $this->Lang('friendlyname'), $this->Lang('installed',$this->GetVersion()));
?>