<?php
// This program is called from product_edit, when button add image is used
if (isset($params['submit']) && $params['submit'] == $this->Lang('addimage')) {
	require_once(dirname(__FILE__).'/../../lib/filemanager/ImageManager/Classes/Files.php');

	// Build the path we will be uploading the image to
	$config = $gCms->GetConfig();
	$path = $config['image_uploads_path'].$this->GetPreference('imagepath_product');
	$files = new Files;
	
	// Make sure the directory can be found. Create it, error handling will covre any problems found
	$files->createFolder($path);
	foreach ($_FILES as $uploadfile) {
		// Replace any non-word characters by underscores
		$uploadfile['name'] = $files->escape($uploadfile['name']);
		$files->copyFile($uploadfile['tmp_name'], $path, $uploadfile['name'], true);
		$params['image'] = $uploadfile['name'];
		if ($uploadfile['name'] != '') {
			// Now that all info is known, insert a record in the images database
			$this->products->CreateImage($params);
			// Prepare a message to be shown on top of the images overview
			$params['message'] = $this->Lang ('message_imageadded',$uploadfile['name']);
		}
		else {
			$params['message'] = $this->Lang ('message_noimagetoupload');
		}
	}
	// Redirect back to images, so we can see the result
	$params = array('product_id' => $params['product_id'],
				'active_tab' => 'images',
				'message' => $params['message']
			);
	$this->Redirect( $id, 'product_edit', $returnid, $params );	
}

if (isset($params['cancel']) && $params['cancel'] == $this->Lang('cancel')) {
	$params = array('active_tab'=>'categories', 
				'current_category_id'=>$params['current_category_id']);
	$this->Redirect( $id, 'defaultadmin', $returnid, $params );
}

?>