<?php
class Categories {
	
	var $module;
	var $taboptarray;
	
	function Categories(&$module) {
		$this->module = $module;
		$this->taboptarray = array('mysql' => 'TYPE=MyISAM');
	}
	function CreateTables() {
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		$fields = "category_id I PRIMARY AUTO,
		           parent_id I,
		           name C(30),
		           description C(255),
		           image C(60),
		           active L,
		           position I";
		$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_sms_categories", $fields, $this->taboptarray);
		$dict->ExecuteSQLArray($sqlarray);		
	}
		
	function DestroyTables() {
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		$sqlarray = $dict->DropTableSQL(cms_db_prefix()."module_sms_categories");
		$dict->ExecuteSQLArray($sqlarray);		
	}

	function Get($category_id) {
		// Retrieve information on the category by id
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		$sql = "SELECT category_id,
		               parent_id,
		               name,
		               description,
		               image,
		               active,
		               position
		        FROM ".cms_db_prefix()."module_sms_categories
		        WHERE category_id=?";
		$dbresult = $db->Execute( $sql, array( $category_id ));
		if( !$dbresult ) {
			return false;
		}
		return $dbresult->FetchRow();
	}

	function GetCatByName($category_name) {
		// Retrieve information on the category by category name
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		$sql = "SELECT *
		        FROM ".cms_db_prefix()."module_sms_categories
		        WHERE name=?";
		$dbresult = $db->Execute( $sql, array( $category_name ));
		if( !$dbresult ) {
			return false;
		}
		return $dbresult->FetchRow();
	}

	function GetList($parent_id=0) {
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		$sql = "SELECT category_id,
		               parent_id,
		               name,
		               description,
		               image,
		               active,
		               position
		        FROM ".cms_db_prefix()."module_sms_categories
		        WHERE parent_id=?";
		$dbresult = $db->Execute( $sql, array( $parent_id ));
		if( !$dbresult ) {
			return false;
		}
		$result = array();
		while( $row = $dbresult->FetchRow() ) {
			$result[] = $row;
		}
		return $result;	
	}
	function Create(&$category) {
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		$sql = "INSERT INTO ".cms_db_prefix()."module_sms_categories(parent_id, 
		                                                           name, 
		                                                           description, 
		                                                           image, 
		                                                           active, 
		                                                           position) 
		        VALUES(?,?,?,?,?,?)";
		$dbresult = $db->Execute( $sql, array( $category['parent_id'], 
                                                     $category['name'],
                                                     $category['description'],
                                                     $category['image'],
                                                     $category['active'],
                                                     $category['position']));
		if( !$dbresult ) {
			return false;
		}
		return true;
	}
	function Update(&$category) {
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		$sql = "UPDATE ".cms_db_prefix()."module_sms_categories
		        SET parent_id=?, 
		            name=?,
		            description=?, 
		            image=?, 
		            active=?, 
		            position=? 
		        WHERE category_id=?";
		$dbresult = $db->Execute( $sql, array( $category['parent_id'], 
                                                     $category['name'],
                                                     $category['description'],
                                                     $category['image'],
                                                     $category['active'],
                                                     $category['position'],
                                                     $category['category_id']));
		if( !$dbresult ) {
			return false;
		}
		return true;
	}
	function Delete(&$category) {
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		// First reset all connected products to root otherwise they are lost in 'space'
		$sql = 'UPDATE '.cms_db_prefix().'module_sms_product_category SET category_id= 0 WHERE category_id=?';
		$dbresult = $db->Execute( $sql, array( $category_id));
		// Now that the category has no connections anymore it can be removed
		$sql = "DELETE FROM ".cms_db_prefix()."module_sms_categories
		        WHERE category_id=?";
		$dbresult = $db->Execute( $sql, array( $category['category_id']));
		if( !$dbresult ) {
			return false;
		}
		return true;
	}
	function BuildList($category_id=0, $category_list='', $level=0) {
	    $pad = str_pad("", $level,"-",STR_PAD_LEFT);
		if ($category_list == '') $category_list = array('root' => 0);
		$category = $this->Get($category_id);
		foreach ($this->GetList($category_id) as $category) {
		    $name = $pad." ".$category['name'];
			$category_list[$name] = $category['category_id'];
			$this->BuildList($category['category_id'], $category_list, $level+1);
		}
		return $category_list;
	}
	function BuildPath($category) {
		$path_array = array();
		$path_array[] = $category;
		while ($category['category_id'] != 0) {
			$category = $this->Get($category['parent_id']);
			if ($category) {
				$path_array[] = $category;
			}
		}
		return array_reverse($path_array);
	}}
?>