<?php

if (!isset($gCms)) exit;

$detailpage = '';
if (isset($params['detailpage']))
{
	$manager =& $gCms->GetHierarchyManager();
	$node =& $manager->sureGetNodeByAlias($params['detailpage']);
	if (isset($node))
	{
		$content =& $node->GetContent();
		if (isset($content))
		{
			$detailpage = $content->Id();
		}
	}
	else
	{
		$node =& $manager->sureGetNodeById($params['detailpage']);
		if (isset($node))
		{
			$detailpage = $params['detailpage'];
		}
	}
}
$config = $gCms->GetConfig();
$pathcat = $this->GetPreference('imagepath_category');
$pathproduct = $this->GetPreference('imagepath_product');

// Display information of the category
$query = "SELECT * FROM ".cms_db_prefix()."module_sms_categories WHERE category_id = ? AND active = 1";
$row = $db->GetRow($query, array($params['category_id']));

if ($row)
{
	$this->smarty->assign('id', $row['category_id']);
	$this->smarty->assign('categoryname', $row['name']);
	$this->smarty->assign('description', $row['description']);
	if (isset($row['image']) && $row['image'] != 'no_image.jpg') {
		$this->smarty->assign('image', ''.$pathcat.$row['image'].'" alt="'.$row['image'].'"');
	}
	else {
		$this->smarty->assign('image', '*none');
	}
}

// Display information of the connected products
$query = 'SELECT p.name AS prodname, p.product_id, p.description AS proddesc, p.price FROM '
	.cms_db_prefix().'module_sms_product_category c LEFT OUTER JOIN '
	.cms_db_prefix().'module_sms_products p ON c.product_id = p.product_id WHERE c.category_id = ? AND p.active = 1';
$dbresult = $db->Execute($query, array($params['category_id']));

$rowclass = 'row1';
$entryarray = array();

while ($dbresult && $row = $dbresult->FetchRow())
{
	$onerow = new stdClass();

	$onerow->prodid = $row['product_id'];
	$onerow->prodname = $this->CreateLink($id, 'fe_product_detail', $returnid, $row['prodname'], array('product_id'=>$row['product_id']));
	$proddesclen = strlen($row['proddesc']);
	if ($proddesclen > 100) {
		$proddescription = substr($row['proddesc'], 0, 100).$this->Lang('textmore');
	}
	else {
		$proddescription = $row['proddesc'];
	}
	$onerow->proddesc = $proddescription;
	// Prepare price, if no price state 'Sold out'
	if ($row['price'] != 0) {
		$onerow->price = $row['price'];
	}
	else {
		$onerow->price = $this->Lang('productsoldout');
	}

	// Get the first picture available for the product found
	$query = "SELECT * FROM ".cms_db_prefix()."module_sms_product_images WHERE product_id = ?";
	$picture = $db->GetRow($query, array($row['product_id']));
	if ($picture)
	{
		if (isset($picture['image']) && $picture['image'] != 'no_image.jpg') {
			$onerow->prodimage = $pathproduct.$picture['image'];
			#$onerow->prodimage = $pathproduct.$picture['image'].'" alt="'.$picture['description'].'"';
		}
		else {
			$this->smarty->assign('prodimage', '*none');
		}

	}
	
	$onerow->rowclass = $rowclass;

	$entryarray[] = $onerow;

	($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
}

$this->smarty->assign_by_ref('products', $entryarray);
$this->smarty->assign('lable_product_count', $this->Lang('textproductcount', count($entryarray)));

// State the currency symbol and that prices are in/ex VAT/TAX
$this->smarty->assign('currency', $this->Lang('pricesincurexvat',$this->GetPreference('default_currency')));

#Display template
#$template = 'summary'.$this->GetPreference('current_catlist_template'); // Use this if template coming from database
$template = 'fe_category_list.tpl';
if (isset($params['summarytemplate']))
  {
    $template = 'summary'.$params['summarytemplate'];
  }
echo $this->ProcessTemplate($template);
#echo $this->ProcessTemplateFromDatabase($template);
?>