<?php

if (! isset($gCms)) exit;

if (! $this->CheckPermission('Use ShopMadeSimple')) {
	return $this->DisplayErrorPage($id, $params, $returnid,$this->Lang('accessdenied'));
}
$active_tab = 'categories';
if( isset( $params['active_tab'] ) ) {
	$active_tab = $params['active_tab'];
}
if ( ! isset( $params['current_category_id']) ) {
	$params['current_category_id'] = 0;
}
$current_category = $this->categories->Get($params['current_category_id']);
/**
 * Prepare the preferences tab
 */
$editor = $this->CheckPermission('Edit Preferences');
$preferences = array();
$preferences['startform'] = $this->CreateFormStart( $id, 'preferences_update');
$preferences['submit'] = $this->CreateInputSubmit ($id, 'submit', $this->Lang('update'));
$preferences['endform'] = $this->CreateFormEnd();

$preferences['admin_name'] = array(
	'label'=>$this->Lang('label_admin_name'),
	'input'=>$editor ? $this->CreateInputText( $id, 'admin_name', $this->GetPreference('admin_name', ''), 40, 40 ) : '<b>'.$this->GetPreference('admin_name', '').'</b>'
); 
$preferences['admin_email'] = array(
	'label'=>$this->Lang('label_admin_email'),
	'input'=>$editor ? $this->CreateInputText( $id, 'admin_email', $this->GetPreference('admin_email', ''), 40, 40 ) : '<b>'.$this->GetPreference('admin_email', '').'</b>'
); 
$preferences['shop_name'] = array(
	'label'=>$this->Lang('label_shop_name'),
	'input'=>$editor ? $this->CreateInputText( $id, 'shop_name', $this->GetPreference('shop_name', ''), 40, 40 ) : '<b>'.$this->GetPreference('shop_name', '').'</b>'
); 
$preferences['shop_phone'] = array(
	'label'=>$this->Lang('label_shop_phone'),
	'input'=>$editor ? $this->CreateInputText( $id, 'shop_phone', $this->GetPreference('shop_phone', ''), 40, 40 ) : '<b>'.$this->GetPreference('shop_phone', '').'</b>'
); 
$preferences['shop_online'] = array(
	'label'=>$this->Lang('label_shop_online'),
	'input'=>$editor ? $this->CreateInputCheckbox($id,'shop_online', 1,$this->GetPreference('shop_online', '')) : '<b>'.$this->GetPreference('shop_online', '').'</b>'
); 
$preferences['default_language'] = array(
	'label'=>$this->Lang('label_default_language'),
	'input'=>''
); 
$preferences['pricesinclvat'] = array(
	'label'=>$this->Lang('label_prices_incl_vat'),
	'input'=>$editor ? $this->CreateInputCheckbox($id,'pricesinclvat', 1,$this->GetPreference('pricesinclvat', false)) : '<b>'.$this->GetPreference('pricesinclvat', false).'</b>'
); 
$preferences['pricesinclvat'] = array(
	'label'=>$this->Lang('label_prices_incl_vat'),
	'input'=>$editor ? $this->CreateInputCheckbox($id,'pricesinclvat', 1,$this->GetPreference('pricesinclvat', false)) : '<b>'.$this->GetPreference('pricesinclvat', false).'</b>'
); 
$preferences['weightunitmeasure'] = array(
	'label'=>$this->Lang('label_weight_unit_measure'),
	'input'=>$editor ? $this->CreateInputText( $id, 'weightunitmeasure', $this->GetPreference('weightunitmeasure', 'Kg'), 10, 10 ) : '<b>'.$this->GetPreference('weightunitmeasure', 'Kg').'</b>'
); 
$preferences['default_currency'] = array(
	'label'=>$this->Lang('label_default_currency'),
	'input'=>$editor ? $this->CreateInputText( $id, 'default_currency', $this->GetPreference('default_currency', ''), 10, 10 ) : '<b>'.$this->GetPreference('default_currency', '').'</b>'
); 
$preferences['default_symbol'] = array(
	'label'=>$this->Lang('label_default_symbol'),
	'input'=>$editor ? $this->CreateInputText( $id, 'default_symbol', $this->GetPreference('default_symbol', ''), 40, 40 ) : '<b>'.$this->GetPreference('default_symbol', '').'</b>'
); 
$preferences['imagepath_category'] = array(
	'label'=>$this->Lang('label_imagepath_category'),
	'input'=>$editor ? $this->CreateInputText( $id, 'imagepath_category', $this->GetPreference('imagepath_category', ''), 40, 40 ) : '<b>'.$this->GetPreference('imagepath_category', '').'</b>'
); 
$preferences['imagepath_product'] = array(
	'label'=>$this->Lang('label_imagepath_product'),
	'input'=>$editor ? $this->CreateInputText( $id, 'imagepath_product', $this->GetPreference('imagepath_product', ''), 40, 40 ) : '<b>'.$this->GetPreference('imagepath_product', '').'</b>'
);
/**
 * Prepare the Categories.
 */
$categories = array();
$category_path = $this->CreateLink( $id, 'category_list', $returnid, 'root', array ('current_category_id' => 0));
foreach ($this->categories->BuildPath($current_category) as $category) {
	$category_path .= ' / '.$this->CreateLink( $id, 'category_list', $returnid, $category['name'], array ('current_category_id' => $category['category_id']));
}

$categories['current'] = array(
	'label'=>$this->Lang('label_current_category'),
	'value'=>$category_path,
	'link_add'=>$this->CreateLink( $id, 'category_add', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('text_add').' '.$this->Lang('text_category'),'','','systemicon'), array('current_category_id'=>$params['current_category_id']), '', false, false, 'class="pageoptions"')
);
$category_list = array();
foreach ($this->categories->GetList($params['current_category_id']) as $category) {
	$category['link_delete'] = $this->CreateLink($id, 'category_delete', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('text_delete'), '', '', 'systemicon'), array ('current_category_id' => $category['category_id']), $this->Lang ('message_areyousure'));
	$category['link_edit'] = $this->CreateLink ($id, 'category_edit', $returnid, $gCms->variables['admintheme']->DisplayImage ('icons/system/edit.gif', $this->Lang('text_edit'), '', '', 'systemicon'), array ('current_category_id' => $params['current_category_id'], 'category_id' => $category['category_id'], 'parent_id' => $category['parent_id'], 'name' => $category['name'],'description' => $category['description'],'image' => $category['image'],'active' => $category['active'],'position' => $category['position'],));
	$category['link_enable'] = $this->CreateLink($id, 'category_enable', $returnid, $category['active'] == 1 ? $gCms->variables['admintheme']->DisplayImage('icons/system/true.gif', $this->Lang('text_inactive'), '', '', 'systemicon') : $gCms->variables['admintheme']->DisplayImage('icons/system/false.gif', $this->Lang('text_active'), '', '', 'systemicon'), array ('current_category_id' => $category['category_id']));
	$category['name'] = $this->CreateLink( $id, 'category_list', $returnid, $category['name'], array ('current_category_id' => $category['category_id']));
	$category_list[] = $category;
}
$categories['subcategories'] = array(
	'label'=>array(
		'id'=>$this->Lang('label_category_id'),
		'name'=>$this->Lang('label_category_name'),
		'description'=>$this->Lang('label_category_description')
	),
	'list'=>$category_list
);
/**
 * Prepare the products
 */
$products = array();
$products['category'] = array(
	'label'=>$this->Lang('label_product_category'),
	'value'=>$current_category['name'],
	'link_add'=>$this->CreateLink( $id, 'product_add', $returnid, 
		$gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('text_add').' '.$this->Lang('text_product'),'','','systemicon'), 
		array('current_category_id'=>$params['current_category_id']), '', false, false, 'class="pageoptions"')
);
$product_list = array();
foreach ($this->products->GetList($params['current_category_id']) as $product) {
	// Prepare a link field on the description, while keeping the length of the field to a maximum
	if ( strlen($product['description']) > 80) {
		$product['description'] = $this->CreateLink ($id, 'product_edit', $returnid, substr($product['description'], 0, 80).' ...', 
			array ('current_category_id' => $params['current_category_id'], 'product_id' => $product['product_id']));
	}
	else {
		$product['description'] = $this->CreateLink ($id, 'product_edit', $returnid, $product['description'], 
			array ('current_category_id' => $params['current_category_id'], 'product_id' => $product['product_id']));
	}
	$product['link_delete'] = $this->CreateLink($id, 'product_delete', $returnid, 
		$gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('text_delete'), '', '', 'systemicon'), 
		array ('current_product_id' => $product['product_id']), $this->Lang ('message_areyousureproduct',$product['name']));
	$product['link_edit'] = $this->CreateLink ($id, 'product_edit', $returnid, 
		$gCms->variables['admintheme']->DisplayImage ('icons/system/edit.gif', $this->Lang('text_edit'), '', '', 'systemicon'), 
		array ('current_category_id' => $params['current_category_id'], 'product_id' => $product['product_id']));
	$product['link_enable'] = $this->CreateLink($id, 'product_enable', $returnid, 
		$product['active'] == 1 ? $gCms->variables['admintheme']->DisplayImage('icons/system/true.gif', $this->Lang('text_inactive'), '', '', 'systemicon') : $gCms->variables['admintheme']->DisplayImage('icons/system/false.gif', $this->Lang('text_active'), '', '', 'systemicon'), 
		array ('current_product_id' => $product['product_id']));
	$product_list[] = $product;
}
$products['products'] = array(
	'label'=>array(
		'id'=>$this->Lang('label_product'),
		'name'=>$this->Lang('label_category_name'),
		'description'=>$this->Lang('label_category_description')
	),
	'list'=>$product_list
);

echo $this->StartTabHeaders();
echo $this->SetTabHeader('categories', $this->Lang('label_tab_categories'), ($active_tab == 'categories'));
echo $this->SetTabHeader('preferences', $this->Lang('label_tab_preferences'), ($active_tab == 'preferences'));
echo $this->EndTabHeaders();

echo $this->StartTabContent();
echo $this->StartTab('preferences', $params);
$smarty->assign('preferences', $preferences); 
echo $this->ProcessTemplate('tab_preferences.tpl');
echo $this->EndTab();

echo $this->StartTab('categories', $params);
$smarty->assign('categories', $categories); 
$smarty->assign('products', $products); 
echo $this->ProcessTemplate('tab_categories.tpl');
echo $this->EndTab();
echo $this->EndTabContent();

?>