<?php
# Module: Cart Made Simple - An Order Intake module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown <duketown@mantox.nl>
#
# This function will upgrade the module Cart Made Simple
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/cartms
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

if (!isset($gCms)) exit;

$dict = NewDataDictionary($db);

$current_version = $oldversion;
switch($current_version)
{
	case '0.0.2':
		# Setup tinybox template
		$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'tinybox.tpl';
		if( file_exists( $fn ) )
		{
			$template = @file_get_contents($fn);
			$this->SetPreference('default_cart_tinybox',$template);
			$this->SetTemplate('cart_tinybox',getDefaultTemplate('cart_'));    
		}

		# Setup normalbox template
		$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'normalbox.tpl';
		if( file_exists( $fn ) )
		{
			$template = @file_get_contents($fn);
			$this->SetPreference('default_cart_normalbox',$template);
			$this->SetTemplate('cart_normalbox',getDefaultTemplate('cart_'));    
		}

		# Setup front end templates
		$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'fe_delivery_info.tpl';
		if( file_exists( $fn ) )
		{
			$template = @file_get_contents($fn);
			$this->SetTemplate('cart_fe_delivery_info', $template);    
		}
		$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'fe_orderconfirm.tpl';
		if( file_exists( $fn ) )
		{
			$template = @file_get_contents($fn);
			$this->SetTemplate('cart_fe_orderconfirm', $template);    
		}
		$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'fe_payment_info.tpl';
		if( file_exists( $fn ) )
		{
			$template = @file_get_contents($fn);
			$this->SetTemplate('cart_fe_payment_info', $template);    
		}
		$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'fe_shipping_info.tpl';
		if( file_exists( $fn ) )
		{
			$template = @file_get_contents($fn);
			$this->SetTemplate('cart_fe_shipping_info', $template);    
		}
		$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'fe_showcart.tpl';
		if( file_exists( $fn ) )
		{
			$template = @file_get_contents($fn);
			$this->SetTemplate('cart_fe_showcart', $template);    
		}

  		$current_version = '0.0.3';
		
	case '0.0.3':
		// Remove an earlier prepared preference. It will come back with better naming convention
		$this->RemovePreference('addadmincost'); 
		// Add various preferences that control part of the module
		$this->SetPreference('admincost', 0);
		$this->SetPreference('admincostadd', false);
		$this->SetPreference('admincostminamount', 100);
		$this->SetPreference('cartcurrency', 'Eur');
		$this->SetPreference('mandatorystate', false);
		$this->SetPreference('numberformatdecimals', '2');
		$this->SetPreference('numberformatdec_point', ',');
		$this->SetPreference('numberformatthousands_sep', '.');
		$this->SetPreference('showinmenu', 'extensions');
		$this->SetPreference('storeshipaddress', true);

		// Table schema description for table: shippingprovider
		$flds = "
			shipprov_id I KEY,
			shipprovcode C(3),
			shipprovdesc C(255),
			shipprovprice F,
			active L(1)
			";

		// Create it. This should do error checking.
		$sqlarray = $dict->CreateTableSQL(cms_db_prefix().'module_cartms_shippingprovider',$flds, $taboptarray);
		$dict->ExecuteSQLArray($sqlarray);
		// Create a sequence
		$db->CreateSequence(cms_db_prefix().'module_cartms_shippingprovider_seq');	
		
		// Add field to hold administration cost per order
		$dict = NewDataDictionary($db);
		$sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_cartms_orders', 'totaladmincost F' );
		$dict->ExecuteSQLArray($sqlarray);

  		$current_version = '0.0.4';
		
	case '0.0.4':
		$this->SetPreference('contentthankyou', '');
		// Change fields to hold decimals
		$dict = NewDataDictionary($db);
		$sqlarray = $dict->AlterColumnSQL(cms_db_prefix().'module_cartms_order_lines', 'price F' );
		$dict->ExecuteSQLArray($sqlarray);
		$sqlarray = $dict->AlterColumnSQL(cms_db_prefix().'module_cartms_order_lines', 'lineamount F' );
		$dict->ExecuteSQLArray($sqlarray);
		$sqlarray = $dict->AlterColumnSQL(cms_db_prefix().'module_cartms_orders', 'totalproduct F' );
		$dict->ExecuteSQLArray($sqlarray);
		$sqlarray = $dict->AlterColumnSQL(cms_db_prefix().'module_cartms_orders', 'totalshipping F' );
		$dict->ExecuteSQLArray($sqlarray);

  		$current_version = '0.1.0';
		
	case '0.1.0':
		/**
		 * Create an example stylesheet for Cart Made Simple tags
		 */
		$new_css_id = $db->GenID(cms_db_prefix() . 'css_seq');
		$css_name = $this->Lang('module_example_stylesheet'); // Retrieve the name of the new stylesheet locate in the css directory
		$css_text = file_get_contents($this->cms->config['root_path'] . DIRECTORY_SEPARATOR . 'modules' . DIRECTORY_SEPARATOR . $this->GetName() . 
			DIRECTORY_SEPARATOR . 'css' . DIRECTORY_SEPARATOR . 'cartmsstylesheet.css');
		$media_type = '';
		# Add the stylesheet to the database
		$query = 'INSERT INTO ' . cms_db_prefix() . 'css (css_id, css_name, css_text, media_type, create_date, modified_date) VALUES (?, ?, ?, ?, ?, ?)';
		$result = $db->Execute($query, array($new_css_id, $css_name, $css_text, $media_type, $db->DBTimeStamp(time()), $db->DBTimeStamp(time())));
		// Add field to hold total netweight per order
		$dict = NewDataDictionary($db);
		$sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_cartms_orders', 'totalnetweight F' );
		$dict->ExecuteSQLArray($sqlarray);
		// Add total vat amounts per vat code
		$sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_cartms_orders', 'totalvat0amount F' );
		$dict->ExecuteSQLArray($sqlarray);
		$sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_cartms_orders', 'totalvat1amount F' );
		$dict->ExecuteSQLArray($sqlarray);
		$sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_cartms_orders', 'totalvat2amount F' );
		$dict->ExecuteSQLArray($sqlarray);
		$sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_cartms_orders', 'totalvat3amount F' );
		$dict->ExecuteSQLArray($sqlarray);
		$sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_cartms_orders', 'totalvat4amount F' );
		$dict->ExecuteSQLArray($sqlarray);
		$sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_cartms_order_lines', 'vatcode C(1)' );
		$dict->ExecuteSQLArray($sqlarray);
		// Prepare fields to hold VAT rates
		$this->SetPreference('vat0name', '');
		$this->SetPreference('vat1name', '');
		$this->SetPreference('vat2name', '');
		$this->SetPreference('vat3name', '');
		$this->SetPreference('vat4name', '');
		$this->SetPreference('vat0perc', 0);
		$this->SetPreference('vat1perc', 0);
		$this->SetPreference('vat2perc', 0);
		$this->SetPreference('vat3perc', 0);
		$this->SetPreference('vat4perc', 0);
		// Prepare template so it can be used from database
		$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'fe_thankyou_info.tpl';
		if( file_exists( $fn ) )
		{
			$template = @file_get_contents($fn);
			$this->SetTemplate('cart_fe_thankyou_info', $template);    
		}

  		$current_version = '0.1.1';
		
	case '0.1.1':		

}

// Log the upgrade in the admin audit trail
$this->Audit( 0, $this->Lang('friendlyname'), $this->Lang('upgraded',$this->GetVersion()));

?>