<?php
# Module: Cart Made Simple - An Order Intake module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown <duketown@mantox.nl>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/cartms
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

if (!isset($gCms)) exit;

global $gCms;
$db =& $gCms->GetDb();

if (isset($params['cancel']))
{
	// Redirect needed to cart
	$this->RedirectForFrontend( $id, $returnid, 'cart', $params, true);
}

if (isset($params['order_id']))
{
	$order_id = $params['order_id'];
}

if (isset($params['continue']) && $params['continue'] != '')
{
	// Store the entered shipping information
	$this->orders->StoreDeliveryInfo( &$params );
	// Shipping information filled, commence to payment information
	$params['perfaction'] = 'request_payment_method';
	$this->RedirectForFrontend( $id, $returnid, 'order', $params, true);
	
}

$this->smarty->assign('welcometitle', $this->Lang('title_welcomedelivery'));
$errorfound = false;
// Perform a check on all the entries. All are mandatory
if (isset($params['submit']))
{
	// Validate delivery method
	if (isset($params['deliverymethod']))
	{
		$deliverymethod = $params['deliverymethod'];
		$this->smarty->assign('deliverymethod_error', '');
		if ($deliverymethod == '')
		{
			$this->smarty->assign('deliverymethod_error', $this->Lang('errordeliverymethodblank'));
			$errorfound = true;
		}
	}

	// Fill separate message for header
	if (!$errorfound) 
	{
		$this->smarty->assign('welcometitle', $this->Lang('checkdeliveryinfo'));
		$this->smarty->assign('continue', $this->CreateInputSubmit($id, 'continue', $this->Lang('continuestep3')));
	}
}

// Prepare a list of possible delivery methods. These will come from the admin part.
$deliverymethodlist = array();
$deliverymethodlist[$this->Lang('deliverselfcollect')] = 'SEC';
$deliverymethodlist[$this->Lang('delivertnt')] = 'TNT';
$deliverymethodlist[$this->Lang('deliverups')] = 'UPS';

#Display template
$this->smarty->assign('startform', $this->CreateFormStart($id, 'orderdelivery', $returnid));
$this->smarty->assign('deliverymethod_label', $this->Lang('deliverymethod_label'));
$this->smarty->assign('deliverymethod_input', $this->CreateInputDropdown($id, 'deliverymethod', $deliverymethodlist, -1, $deliverymethod));

$this->smarty->assign('hidden', $this->CreateInputHidden($id, 'order_id', $order_id));
$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', $this->Lang('submit')));
$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', $this->Lang('cancel')));
$this->smarty->assign('endform', $this->CreateFormEnd());

// Set default template. If past as parameter, show that one
$template = 'cart_fe_delivery_info';
if (isset($params['template_delivery_info']))
  {
    $template = 'cart_'.$params['template_delivery_info'];
  }
echo $this->ProcessTemplateFromDatabase($template);
?>