<?php
# Module: Cart Made Simple - An Order Intake module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown <duketown@mantox.nl>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/cartms
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

if (!isset($gCms)) exit;

global $gCms;
$db =& $gCms->GetDb();

if (isset($params['cancel']))
{
	// Redirect needed to cart
	$this->RedirectForFrontend( $id, $returnid, 'cart', $params, true);
}

if (isset($params['order_id']))
{
	$order_id = $params['order_id'];
}

if (isset($params['confirm']))
{
	// Remove contents of cart
	$this->orders->ClearCart( );
	// Send a mail to customer as confirmation
	$this->orders->SendCustomerConfirmationMail( );
	// Set status of order to confirmed
	$params['oldstatus'] = 'INT';
	$this->orders->SwitchStatus( $params );
	// Exit to thank you page
	$params['perfaction'] = 'please_come_back';
	$this->RedirectForFrontend( $id, $returnid, 'order', $params, true);	
}

$this->smarty->assign('welcometitle', $this->Lang('title_welcomeconfirm'));
// Prepare shipping information
$orderheader = array();
$orderheader = $this->orders->GetOrderHeader( $order_id );
$shipto = array();
$shipto = $this->orders->GetOrderShipTo( $orderheader['customer_id'] );
$this->smarty->assign('shiptoname', $shipto['shiptoname']);
$this->smarty->assign('shiptostreet', $shipto['addressstreet']);
$this->smarty->assign('shiptocity', $shipto['addresscity']);
$this->smarty->assign('shiptostate', $shipto['addressstate']);
$this->smarty->assign('shiptozip', $shipto['addresszip']);
$this->smarty->assign('shiptocountry', $shipto['addresscountry']);
// Total weight
$shopms =& $this->GetModuleInstance('ShopMadeSimple');
if( $shopms )
{
	$umweight = $shopms->GetPreference('weightunitmeasure', 'Kg');
}
$this->smarty->assign('label_total_weight',$this->Lang('label_total_weight', $orderheader['totalnetweight'], $umweight));
// Prepare overview of order lines
//   These order lines are still available in the array $products, so no need to load them again.
// Any administration cost involved?
if ( $orderheader['totaladmincost'] <> 0 ) {
	$formattedamount = $this->orders->FormatAmount( $orderheader['totaladmincost'] );
	$currency = $this->GetPreference('cartcurrency', 'Eur');
	$this->smarty->assign('label_admin_amount',$this->Lang('adminamount'));
	$this->smarty->assign('admin_amount', $formattedamount);
}
// Prepare the VAT amounts for front end
if ( $orderheader['totalvat0amount'] <> 0 ) {
	$formattedamount = $this->orders->FormatAmount( $orderheader['totalvat0amount'] );
	$this->smarty->assign('label_vat0_amount',$this->GetPreference('vat0perc', 0));
	$this->smarty->assign('totalvat0amount', $formattedamount);
}
if ( $orderheader['totalvat1amount'] <> 0 ) {
	$formattedamount = $this->orders->FormatAmount( $orderheader['totalvat1amount'] );
	$this->smarty->assign('label_vat1_amount',$this->GetPreference('vat1perc', 0));
	$this->smarty->assign('totalvat1amount', $formattedamount);
}
if ( $orderheader['totalvat2amount'] <> 0 ) {
	$formattedamount = $this->orders->FormatAmount( $orderheader['totalvat2amount'] );
	$this->smarty->assign('label_vat2_amount',$this->GetPreference('vat2perc', 0));
	$this->smarty->assign('totalvat2amount', $formattedamount);
}
if ( $orderheader['totalvat3amount'] <> 0 ) {
	$formattedamount = $this->orders->FormatAmount( $orderheader['totalvat3amount'] );
	$this->smarty->assign('label_vat3_amount',$this->GetPreference('vat3perc', 0));
	$this->smarty->assign('totalvat3amount', $formattedamount);
}
if ( $orderheader['totalvat4amount'] <> 0 ) {
	$formattedamount = $this->orders->FormatAmount( $orderheader['totalvat4amount'] );
	$this->smarty->assign('label_vat4_amount',$this->GetPreference('vat4perc', 0));
	$this->smarty->assign('totalvat4amount', $formattedamount);
}
// Prepare the total amount
$formattedamount = $this->orders->FormatAmount( $orderheader['totalproduct'] + $orderheader['totaladmincost'] 
	+ $orderheader['totalvat0amount'] + $orderheader['totalvat1amount'] + $orderheader['totalvat2amount']
	+ $orderheader['totalvat3amount'] + $orderheader['totalvat4amount']);
$currency = $this->GetPreference('cartcurrency', 'Eur');
$this->smarty->assign('label_total_amount',$this->Lang('ordertotals'));
$this->smarty->assign('total_amount', $currency.' '.$formattedamount);
// Prepare delivery method
switch ( $orderheader['shipmode'] )
{
	case 'SEC':
		$this->smarty->assign('deliveryvia', $this->Lang('deliverselfcollect'));
		break;
	case 'TNT':
		$this->smarty->assign('deliveryvia', $this->Lang('delivertnt'));
		break;
	case 'UPS':
		$this->smarty->assign('deliveryvia', $this->Lang('deliverups'));
		break;
	default:
		$this->smarty->assign('deliveryvia', $this->Lang('deliverselfcollect'));
		break;
}
// Prepare payment method
switch ( $orderheader['shipmode'] )
{
	case 'PAYUF':
		$this->smarty->assign('paymentvia', $this->Lang('paymentupfront'));
		break;
	case 'PAYPAL':
		$this->smarty->assign('paymentvia', $this->Lang('paymentpaypal'));
		break;
	case 'WORLDPAY':
		$this->smarty->assign('paymentvia', $this->Lang('paymentworldpay'));
		break;
	default:
		$this->smarty->assign('paymentvia', $this->Lang('paymentupfront'));
		break;
}

#Display template
$this->smarty->assign('startform', $this->CreateFormStart($id, 'orderconfirm', $returnid));
$this->smarty->assign('shipto_label', $this->Lang('ship_to'));
$this->smarty->assign('productqtytext', $this->Lang('productqtytext'));
$this->smarty->assign('productnametext', $this->Lang('productnametext'));
$this->smarty->assign('productpricetext', $this->Lang('productpricetext'));
$this->smarty->assign('lineamounttext', $this->Lang('lineamounttext'));
$this->smarty->assign('deliveryvia_label', $this->Lang('deliverymethod_via'));
$this->smarty->assign('paymentvia_label', $this->Lang('paymentmethod_via'));

$this->smarty->assign('hidden', $this->CreateInputHidden($id, 'order_id', $order_id));
$this->smarty->assign('confirm', $this->CreateInputSubmit($id, 'confirm', $this->Lang('confirm')));
$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', $this->Lang('cancel')));
$this->smarty->assign('endform', $this->CreateFormEnd());

// Set default template. If past as parameter, show that one
$template = 'cart_fe_orderconfirm';
if (isset($params['template_confirm']))
  {
    $template = 'cart_'.$params['template_confirm'];
  }
echo $this->ProcessTemplateFromDatabase($template);
?>
