<?php
#-------------------------------------------------------------------------
# Module: Cart Made Simple - An Order Intake module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown <duketown@mantox.nl>
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/cartms/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

include_once(dirname(__FILE__).'/library/orders.api.php');
include_once(dirname(__FILE__).'/library/admin.functions.php');

class CartMadeSimple extends CMSModule
{
	var $orders;
	
	function CartMadeSimple() {
    	parent::CMSModule();
   	$this->orders = new Orders($this);
	}

	function GetName()
	{
		return 'CartMadeSimple';
	}

	function GetFriendlyName()
	{
		return $this->Lang('friendlyname');
	}

	function GetVersion()
	{
		return '0.1.1';
	}

	function GetHelp()
	{
		return $this->Lang('help');
	}

	function GetAuthor()
	{
		return 'Duketown';
	}

	function GetAuthorEmail()
	{
		return 'duketown@mantox.nl';
	}

	function GetChangeLog()
	{
		return $this->Lang('changelog');
	}

	function IsPluginModule()
	{
		return true;
	}

	function HasAdmin()
	{
		return true;
	}

	function GetAdminSection()
	{
		//Alan Ryan - I find this to be useful
		return $this->GetPreference("showinmenu","extensions"); 
		//return 'extensions';
	}

	function GetAdminDescription()
	{
		return $this->Lang('moddescription');
	}

	function VisibleToAdminUser()
	{
        return $this->CheckPermission('Use CartMadeSimple');
	}

	function GetDependencies()
	{
		return array('FrontEndUsers'=>'1.3.0',
				#'SelfRegistration'=>'1.1.5',
				'ShopMadeSimple'=>'0.0.1');
	}

	function MinimumCMSVersion()
	{
		return "1.0.0";
	}
	
	
	/*---------------------------------------------------------
	   SetParameters()
	   This function enables you to create mappings for
	   your module when using "Pretty Urls".
	   
	   Typically, modules create internal links that have
	   big ugly strings along the lines of:
	   index.php?mact=ModName,cntnt01,actionName,0&cntnt01param1=1&cntnt01param2=2&cntnt01returnid=3
	   
	   You might prefer these to look like:
	   /ModuleFunction/2/3
	   
	   To do this, you have to register routes and map
	   your parameters in a way that the API will be able
	   to understand.

	   Also note that any calls to CreateLink will need to
	   be updated to pass the pretty url parameter.
	   
	   Since the Skeleton doesn't really create any links,
	   the section below is commented out, but you can
	   use it to figure out pretty urls.
	   
	   ---------------------------------------------------------*/
	function SetParameters()
	{
	/*
		$this->CreateParameter('cartmadesimple', '', $this->lang('help_cartmadesimple'));
		// For viewing a picture
		$this->RegisterRoute('/cartmadesimple\/(?P<numeric_param_name>[0-9]+)\/(?P<string_param_name>[a-zA-Z]+)\/(?P<returnid>[0-9]+)$/', 
array('action'=>'default'));

		// now, any url that looks like:
		//    /cartmadesimple/3/foo/5
		// will call the default action, with:
		//     params['numeric_param_name'] set to 3
		//     params['string_param_name'] set to "foo"
		//    and returnid set to 5
		
	*/
	}

	function GetEventDescription ( $eventname )
	{
		return $this->Lang('event_info_'.$eventname );
	}

	function GetEventHelp ( $eventname )
	{
		return $this->Lang('event_help_'.$eventname );
	}

	function InstallPostMessage()
	{
		return $this->Lang('postinstall');
	}

	function UninstallPostMessage()
	{
		return $this->Lang('postuninstall');
	}

	function UninstallPreMessage()
	{
		return $this->Lang('really_uninstall');
	}

}

?>
