<?php
class Products {
	
	var $module;
	var $taboptarray;
	
	function Products($module) {
		$this->module = $module;
		$this->taboptarray = array('mysql' => 'TYPE=MyISAM');
	}
	function CreateTables() {
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		/**
		 * Primary Product Table
		 */
		$fields = "product_id I PRIMARY AUTO,
                   name C(30),
                   description C(255),
                   price N(9,2),
                   active L,
                   featured L,
                   position I";
		$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_sms_products", $fields, $this->taboptarray);
		$dict->ExecuteSQLArray($sqlarray);
		/**
		 * Product Images
		 */
		$fields = "product_images_id I PRIMARY AUTO,
		           product_id I,
		           image C(30),
		           description C(255)";
		$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_sms_product_images", $fields, $this->taboptarray);
		$dict->ExecuteSQLArray($sqlarray);
		/**
		 * Product Attributes
		 */           
		$fields = "attribute_id I PRIMARY AUTO,
		           product_id I,
		           name C(30),
                   description C(255)";
		$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_sms_product_attributes", $fields, $this->taboptarray);
		$dict->ExecuteSQLArray($sqlarray);
		/**
		 * Attribute Options
		 */
		$fields = "option_id I PRIMARY AUTO,
		           attribute_id I,
		           name C(30),
                   description C(255),
                   price N(9,2)";
		$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_sms_attribute_options", $fields, $this->taboptarray);
		$dict->ExecuteSQLArray($sqlarray);
		/**
		 * Product <-> Category Map Table
		 */
		$fields = "category_product_id I PRIMARY AUTO,
		           category_id I,
		           product_id I";
		$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_sms_product_category", $fields, $this->taboptarray);
		$dict->ExecuteSQLArray($sqlarray);
		
	}
	function UpgradeTables() {
		
	}
	function DestroyTables() {
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		$sqlarray = $dict->DropTableSQL(cms_db_prefix()."module_sms_products");
		$dict->ExecuteSQLArray($sqlarray);				
		$sqlarray = $dict->DropTableSQL(cms_db_prefix()."module_sms_product_images");
		$dict->ExecuteSQLArray($sqlarray);				
		$sqlarray = $dict->DropTableSQL(cms_db_prefix()."module_sms_product_attributes");
		$dict->ExecuteSQLArray($sqlarray);				
		$sqlarray = $dict->DropTableSQL(cms_db_prefix()."module_sms_attribute_options");
		$dict->ExecuteSQLArray($sqlarray);				
		$sqlarray = $dict->DropTableSQL(cms_db_prefix()."module_sms_product_category");
		$dict->ExecuteSQLArray($sqlarray);				
	}
	function Get($product_id) {
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		$sql = "SELECT product_id,
                       name,
                       description,
                       price,
                       active,
                       featured,
                       position
		        FROM ".cms_db_prefix()."module_sms_products
		        WHERE product_id=?";
		$dbresult = $db->Execute( $sql, array( $product_id ));
		if( !$dbresult ) {
			return false;
		}
		$product = $dbresult->FetchRow();
		/**
		 * Get the categories this product belongs to.
		 */
		$product['categories'] = array();
		foreach ($this->GetCategoryMap($product_id) as $category_map) {
			$product['categories'][] = $this->module->categories->Get($category_map['category_id']);
		}
		/**
		 * Get the images for the product.
		 */
		$sql = "SELECT product_images_id, product_id, image, description
		        FROM ".cms_db_prefix()."module_sms_product_images
		        WHERE product_id=?";
		$dbresult = $db->Execute( $sql, array( $product_id ));
		
		while ($dbresult && $row = $dbresult->FetchRow()) {
			$product['images'][] = $row;
		}
		/**
		 * Get the attributes of the product.
		 */
		$sql = "SELECT attribute_id, product_id, name, description
			FROM ".cms_db_prefix()."module_sms_product_attributes
			WHERE product_id=?";
		$dbresult = $db->Execute( $sql, array( $product_id ));

		while ($dbresult && $row = $dbresult->FetchRow()) {
			$product['attributes'][] = $row;
		}
		/**
		 * TODO: Get the options of the product.
		 */
		return $product;		
	}
	function GetList($category_id=0) {
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		$sql = "SELECT ".cms_db_prefix()."module_sms_products.product_id,
		               ".cms_db_prefix()."module_sms_products.name,
		               ".cms_db_prefix()."module_sms_products.description,
		               ".cms_db_prefix()."module_sms_products.price,
		               ".cms_db_prefix()."module_sms_products.active,
		               ".cms_db_prefix()."module_sms_products.featured,
		               ".cms_db_prefix()."module_sms_products.position
		        FROM ".cms_db_prefix()."module_sms_products,".cms_db_prefix()."module_sms_product_category
		        WHERE ".cms_db_prefix()."module_sms_products.product_id=".cms_db_prefix()."module_sms_product_category.product_id
		        AND ".cms_db_prefix()."module_sms_product_category.category_id=?";
		$dbresult = $db->Execute( $sql, array( $category_id));
		if( !$dbresult ) {
			return false;
		}
		$result = array();
		while( $row = $dbresult->FetchRow() ) {
			$result[] = $row;
		}
		return $result;	
	}
	function Create(&$product) {
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		$sql = "INSERT INTO ".cms_db_prefix()."module_sms_products(name, 
		                                                           description, 
		                                                           price, 
		                                                           active, 
		                                                           featured, 
		                                                           position) 
		        VALUES(?,?,?,?,?,?)";
		$dbresult = $db->Execute( $sql, array( $product['name'],
                                               $product['description'],
                                               $product['price'],
                                               $product['active'],
                                               $product['featured'],
                                               $product['position']));
		if( !$dbresult ) {
			return false;
		}
		$product['product_id'] = $db->Insert_ID();
		return true;
	}
	function CreateCategoryMap($category_id, $product_id) {
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		$sql = "INSERT INTO ".cms_db_prefix()."module_sms_product_category(category_id, 
		                                                                   product_id) 
		        VALUES(?,?)";
		$dbresult = $db->Execute( $sql, array( $category_id,
                                               $product_id));
		if( !$dbresult ) {
			return false;
		}
		return true;
	}
	function DeleteCategoryMap($category_id, $product_id) {
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		$sql = "DELETE FROM ".cms_db_prefix()."module_sms_product_category WHERE category_id=? AND product_id=?";
		$dbresult = $db->Execute( $sql, array( $category_id,
                                               $product_id));
		if( !$dbresult ) {
			return false;
		}
		return true;
	}
	
	function GetCategoryMap($product_id) {
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		$sql = "SELECT category_id 
		        FROM ".cms_db_prefix()."module_sms_product_category
		        WHERE product_id=?";		
		$dbresult = $db->Execute( $sql, array( $product_id));
		if( !$dbresult ) {
			return false;
		}
		$result = array();
		while( $row = $dbresult->FetchRow() ) {
			$result[] = $row;
		}
		return $result;	
	}
	function Update($product) {
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		$sql = "UPDATE ".cms_db_prefix()."module_sms_products SET name = ?, 
													description = ?, 
													price = ?, 
													active = ?, 
													featured = ?, 
													position = ? 
		         WHERE product_id = ?";
		$dbresult = $db->Execute( $sql, array(	$product['name'],
									$product['description'],
									$product['price'],
									$product['active'],
									$product['featured'],
									$product['position'],
        								$product['product_id']));
		if( !$dbresult ) {
			return false;
		}
		return true;
	}
	function Delete($product) {
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		// Delete the picture(s)
		$sql = "DELETE FROM ".cms_db_prefix()."module_sms_product_images 
				WHERE product_id = ?";		
		$dbresult = $db->Execute( $sql, array( $product['product_id']));
		// Delete the uploaded picture(s)
		// Delete the connection to the category
		$sql = "DELETE FROM ".cms_db_prefix()."module_sms_product_category
				WHERE product_id = ?";		
		$dbresult = $db->Execute( $sql, array( $product['product_id']));
		// Delete all the options that are connected to the product
		$sql = "DELETE FROM ".cms_db_prefix()."module_sms_attribute_options
				WHERE attribute_id IN (SELECT attribute_id FROM ".cms_db_prefix()."module_sms_product_attributes
					WHERE product_id = ?)";
		// Delete the attributes of this product
		$sql = "DELETE FROM ".cms_db_prefix()."module_sms_product_attributes
				WHERE product_id = ?";		
		$dbresult = $db->Execute( $sql, array( $product['product_id']));
		// Now it is possible to delete the product it self
		// Should a check been done to the Cart Made Simple tables? So delete orders????
		$sql = "DELETE FROM ".cms_db_prefix()."module_sms_products 
				WHERE product_id = ?";		
		$dbresult = $db->Execute( $sql, array( $product['product_id']));
		if( !$dbresult ) {
			return false;
		}
		return true;
	}
	
	// Attributes related functions	
	// Retrieve the information related to a product attribute
	function GetAttribute($attribute_id) {
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		$sql = "SELECT product_id, name, description 
		        FROM ".cms_db_prefix()."module_sms_product_attributes
		        WHERE attribute_id = ?";		
		$dbresult = $db->Execute( $sql, array( $attribute_id ));
		if( !$dbresult ) {
			return false;
		}
		$result = '';
		while( $row = $dbresult->FetchRow() ) {
			$result = $row;
		}
		return $result;	
	
	}

	// Save new product attribute information
	function CreateAttribute($attribute) {
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		$sql = "INSERT INTO ".cms_db_prefix()."module_sms_product_attributes (product_id, 
		                                                                 name, 
		                                                                 description)
		        VALUES(?,?,?)";
		$dbresult = $db->Execute( $sql, array( $attribute['product_id'],
                                               $attribute['name'],
                                               $attribute['description']));
		if( !$dbresult ) {
			echo "FALSE";
			return false;
		}
		return true;
		
	}

	// Delete product attribute information
	function DeleteAttribute($params) {
		// Now delete the attribute record
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		$sql = "DELETE FROM ".cms_db_prefix()."module_sms_product_attributes WHERE attribute_id = ? ";
		$dbresult = $db->Execute( $sql, array( $params['attribute_id'] ));
		if( !$dbresult ) {
			echo "FALSE";
			return false;
		}
		return true;
		
	}
	// Save changed product attribute information
	function UpdateAttribute($params) {
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		$sql = "UPDATE ".cms_db_prefix()."module_sms_product_attributes SET name = ?, description = ? WHERE attribute_id = ? ";
		$dbresult = $db->Execute( $sql, array( $params['name'], $params['description'],
                                               $params['attribute_id']));
		if( !$dbresult ) {
			echo "FALSE";
			return false;
		}
		return true;
		
	}
	
	// Images related functions	
	// Retrieve the information related to a product image
	function GetImage($product_images_id) {
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		$sql = "SELECT product_id, image, description 
		        FROM ".cms_db_prefix()."module_sms_product_images
		        WHERE product_images_id = ?";		
		$dbresult = $db->Execute( $sql, array( $product_images_id ));
		if( !$dbresult ) {
			return false;
		}
		$result = '';
		while( $row = $dbresult->FetchRow() ) {
			$result = $row;
		}
		return $result;	
	
	}

	// Save new product image information
	function CreateImage($image) {
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		$sql = "INSERT INTO ".cms_db_prefix()."module_sms_product_images(product_id, 
		                                                                 image, 
		                                                                 description)
		        VALUES(?,?,?)";
		$dbresult = $db->Execute( $sql, array( $image['product_id'],
                                               $image['image'],
                                               $image['description']));
		if( !$dbresult ) {
			echo "FALSE";
			return false;
		}
		return true;
		
	}

	// Delete image from folder and its product image information
	function DeleteImage($params) {
		// Now delete the image record
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		$sql = "DELETE FROM ".cms_db_prefix()."module_sms_product_images WHERE product_images_id = ? ";
		$dbresult = $db->Execute( $sql, array( $params['product_images_id'] ));
		if( !$dbresult ) {
			echo "FALSE";
			return false;
		}
		return true;
		
	}
	// Save changed product image information
	function UpdateImage($params) {
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		$sql = "UPDATE ".cms_db_prefix()."module_sms_product_images SET description = ? WHERE product_images_id = ? ";
		$dbresult = $db->Execute( $sql, array( $params['description'],
                                               $params['product_images_id']));
		if( !$dbresult ) {
			echo "FALSE";
			return false;
		}
		return true;
		
	}

}
?>