<?php
// Usage: place {cms_module module='ShopMadeSimple'} somewhere in the template of a frontend page.

if (!isset($gCms)) exit;

global $gCms;
$db =& $gCms->GetDb();

$detailpage = '';
if (isset($params['detailpage']))
  {
    $manager =& $gCms->GetHierarchyManager();
    $node =& $manager->sureGetNodeByAlias($params['detailpage']);
    if (isset($node))
      {
	$content =& $node->GetContent();	
	if (isset($content))
	  {
	    $detailpage = $content->Id();
	  }
      }
    else
      {
	$node =& $manager->sureGetNodeById($params['detailpage']);
	if (isset($node))
	  {
	    $detailpage = $params['detailpage'];
	  }
      }
  }

if (isset($params['display']))
{
	$display = $params['display'];
}
else
{
	$display = 'categorylist';
}
if (isset($params['catlevel'])) {
	$catlevel = $params['catlevel'];
}
else {
	$catlevel = '0';
}

switch($display)
  {
	case 'categorylist':
		if ($catlevel == '0') { 
			// Prepare a list of categories at top level
			foreach ($this->categories->GetList() as $category) {
				if ($category['active'] == 1) {
					$onerow = new stdClass();
					// Check the number of active products connected to this category
					$query = 'SELECT count(*) as num_products FROM '.cms_db_prefix().'module_sms_product_category pc,
						'.cms_db_prefix().'module_sms_products p WHERE category_id=? AND pc.product_id = p.product_id AND 
						p.active = 1';
					$dbresult = $db->Execute( $query, array( $category['category_id']));
					$row = $dbresult->FetchRow();
					$num_products=$row['num_products'];
					// Include the number of products in the name of the category
					if ($num_products != 0) {
						$category['name'] = $category['name'] . ' ('.$num_products.')';
					}
					$sendtodetail = array('category_id'=>$category['category_id']);
					$prettyurl = 'ShopMadeSimple/'.$row['category_id'].'/'.($detailpage!=''?$detailpage:$returnid);
					if (isset($sendtodetail['detailtemplate']))
					{
						$prettyurl .= '/d,' . $sendtodetail['detailtemplate'];
					}
					$onerow->name  = $this->CreateLink($id, 'fe_category_list', $detailpage!=''?$detailpage:$returnid, 
						$category['name'], $sendtodetail,'', false, false, '', true, $prettyurl);
					$onerow->rowclass = $rowclass;
					$entryarray[] = $onerow;
				}
			}
			$this->smarty->assign_by_ref('items', $entryarray);

			$this->smarty->assign('startform', $this->CreateFrontendFormStart($id, $returnid, 'default'));
			$this->smarty->assign('endform', $this->CreateFormEnd());
			$this->smarty->assign('label_categories', $this->Lang('label_categories'));
			$this->smarty->assign('categories', $categories);
			echo $this->ProcessTemplate('box_categories.tpl');
		}
 		break;
	case 'productlist':
		// Prepare a list of products for given category
 		break;
	case 'productdetail':
		// Prepare details for given product
 		break;
	default:
 		echo $this->Lang('unknown_display', $display);
 		return;
  }
/*
if (!isset($params['display'])) $params['display'] = 'categories';
print '<pre>';
print_r($params);
print '</pre>';

if (isset($params['display']) && $params['display'] == 'categories') {
	$current_category_id = isset($params['current_category_id']) ? $params['current_category_id'] : '';
	$category_list = array();
	foreach ($this->categories->GetList($current_category_id) as $category) {
		if ($category['active']) {
			$category_list[] = array(
				'label'=>$this->CreateFrontEndLink($id, $returnid, 'default', $contents='', $params=array('display'=>'categories','current_category_id'=>$category['category_id']), $warn_message=''),
				'image'=>$shop_page['imagepath_category'].$category['image']
			);
			echo $category['name'].'<br />';
		}
	}
	$this->smarty->assign('categories', $category_list);
	echo $this->ProcessTemplate('example_categories.tpl');
}
if (isset($params['display']) && $params['display'] == 'products') {
}
if (isset($params['display']) && $params['display'] == 'product_details') {
}
if (isset($params['display']) && $params['display'] == 'featured') {
}
*/
?>