<?php

include_once(dirname(__FILE__).'/library/categories.api.php');
include_once(dirname(__FILE__).'/library/products.api.php');
include_once(dirname(__FILE__).'/library/translations.api.php');

class ShopMadeSimple extends CMSModule {
	
	var $categories;
	var $products;
	var $translations;
	
	function ShopMadeSimple() {
    	parent::CMSModule();
    	$this->categories = new Categories($this);
    	$this->products = new Products($this);
   	$this->translations = new Translations($this);
	}
	function GetName() {
		return 'ShopMadeSimple';
	}
	function GetFriendlyName() {
		return $this->Lang('friendlyname');
	}
	function GetVersion() {
		return '0.1.0';
	}
	function GetAuthor() {
		return 'Gary Greyling and Duketown<br>';
	}
	function GetAuthorEmail() {
		return 'gary.greyling@gmail.com and duketown@mantox.nl';
	}
	function GetHelp() {
		return $this->Lang('help');
	}
	function GetChangeLog()	{
		return $this->Lang('changelog');
	}
	function IsPluginModule() {
		return true;
	}
	function HasAdmin()	{
		return true;
	}
	function GetAdminSection() {
		return 'extensions';
	}
	function GetAdminDescription() {
		return $this->Lang('admin_description');
	}
	function GetDependencies() {
		return array('FrontEndUsers'=>'1.0');
	}	
	function MinimumCMSVersion() {
		return "1.0.0";
	}
	function InstallPostMessage() {
		return $this->Lang('message_postinstall');
	}
	function UninstallPostMessage() {
		return $this->Lang('message_postuninstall');
	}
	function UninstallPreMessage() {
		return $this->Lang('message_confirmuninstall');
	}		
}

?>