<?php
#-------------------------------------------------------------------------
# Module: Cart Made Simple - An Order Intake module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown <duketown@mantox.nl>
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/cartms/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

if (!isset($gCms)) exit;

/** 
 * Create CartMadeSimple user type and group in FrontEndUsers
 */
$properties = array(
	array('name'=>'firstname', 'prompt'=>'Firstname', 'type'=>0, 'length'=>20, 'maxlength'=>20),
	array('name'=>'surname','prompt'=>'Surname','type'=>0,'length'=>30,'maxlength'=>30),
	array('name'=>'email','prompt'=>'Email Address','type'=>2,'length'=>50,'maxlength'=>255),
	array('name'=>'addressstreet','prompt'=>'Street','type'=>0,'length'=>50,'maxlength'=>200),
	array('name'=>'addresscity','prompt'=>'City','type'=>0,'length'=>50,'maxlength'=>100),
	array('name'=>'addressstate','prompt'=>'State/Province','type'=>0,'length'=>20,'maxlength'=>20),
	array('name'=>'addresszip','prompt'=>'Zip/Postal code','type'=>0,'length'=>10,'maxlength'=>10),
	// The country dropdown values are to be filled by site owner in group properties.
	// The countries define where the shop wants to ship to
	array('name'=>'addresscountry','prompt'=>'Country','type'=>4,'length'=>0,'maxlength'=>0)
);

$feu =& $gCms->modules['FrontEndUsers']['object'];
/* Check if the group already exists */
if (! $feu->GroupExistsByName('CartMadeSimple')) {
	$result = $feu->AddGroup('CartMadeSimple','CartMadeSimple Users');

	if ($result[0])
	{
	 	$counter = 0;
		foreach ($properties as $property) {
			$feu->AddPropertyDefn($property['name'], 
			                      $property['prompt'],
			                      $property['type'],
			                      $property['length'],
			                      $property['maxlength']);
			$feu->AddGroupPropertyRelation($result[1], $property['name'], $counter, 1, 1);
			$counter++;
		}
	}
}
else {
  /* TODO: Check that it has all the properties we require */
}

/**
 * Create all tables
 */
$this->orders->CreateTables();

/**
 * Create all preferences
 */
$this->SetPreference('admincost', 0);
$this->SetPreference('admincostadd', false);
$this->SetPreference('admincostminamount', 100);
$this->SetPreference('cartcurrency', 'Eur');
$this->SetPreference('mandatorystate', false);
$this->SetPreference('numberformatdecimals', '2');
$this->SetPreference('numberformatdec_point', ',');
$this->SetPreference('numberformatthousands_sep', '.');
$this->SetPreference('showinmenu', 'extensions');
$this->SetPreference('storeshipaddress', true);
$this->SetPreference('contentthankyou', '');

/**
 * Create various example templates
 */
# Setup cart template
$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'cart_template.tpl';
if( file_exists( $fn ) )
{
	$template = @file_get_contents($fn);
	$this->SetTemplate('cart_template',$template);
}

# Setup tinybox template
$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'tinybox.tpl';
if( file_exists( $fn ) )
{
	$template = @file_get_contents($fn);
	$this->SetTemplate('cart_tinybox', $template);    
}

# Setup normalbox template
$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'normalbox.tpl';
if( file_exists( $fn ) )
{
	$template = @file_get_contents($fn);
	$this->SetTemplate('cart_normalbox',$template);
}

# Setup front end templates
$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'fe_delivery_info.tpl';
if( file_exists( $fn ) )
{
	$template = @file_get_contents($fn);
	$this->SetTemplate('cart_fe_delivery_info', $template);    
}
$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'fe_orderconfirm.tpl';
if( file_exists( $fn ) )
{
	$template = @file_get_contents($fn);
	$this->SetTemplate('cart_fe_orderconfirm', $template);    
}
$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'fe_payment_info.tpl';
if( file_exists( $fn ) )
{
	$template = @file_get_contents($fn);
	$this->SetTemplate('cart_fe_payment_info', $template);    
}
$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'fe_shipping_info.tpl';
if( file_exists( $fn ) )
{
	$template = @file_get_contents($fn);
	$this->SetTemplate('cart_fe_shipping_info', $template);    
}
$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'fe_showcart.tpl';
if( file_exists( $fn ) )
{
	$template = @file_get_contents($fn);
	$this->SetTemplate('cart_fe_showcart', $template);    
}

# Setup userauth template
$fn = dirname(__FILE__).DIRECTORY_SEPARATOR.'templates'.DIRECTORY_SEPARATOR.'userauth_template.tpl';
if( file_exists( $fn ) )
{
	$template = @file_get_contents($fn);
	$this->SetTemplate('userauth_template',$template);
}

/**
 * Create security permissions
 */
$this->CreatePermission('Use CartMadeSimple', 'Use Cart Made Simple');

$this->Audit( 0, $this->Lang('friendlyname'), $this->Lang('installed',$this->GetVersion()));
?>