<?php
class Orders {
	
	var $module;
	var $taboptarray;

	function Orders(&$module) {
		$this->module = $module;
		// mysql-specific, but ignored by other database
		$this->taboptarray = array('mysql' => 'TYPE=MyISAM');
	}

	function CreateTables() {
		/**
		 * Create all tables
		 */
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);

		// Table schema description for table: cart
		$flds = "
			cart_id I KEY,
			session_id C(50),
			product_id I,
			qty I,
			create_date " . CMS_ADODB_DT . "
			";

		// Create it. This should do error checking.
		$sqlarray = $dict->CreateTableSQL(cms_db_prefix().'module_cartms_carts',$flds, $taboptarray);
		$dict->ExecuteSQLArray($sqlarray);
		// Create a sequence
		$db->CreateSequence(cms_db_prefix().'module_cartms_carts_seq');

		// Table schema description for table: Order
		$flds = "
			order_id I KEY,
			totalproduct F,
			totalshipping F,
			totaladmincost F,
			shipmode C(3),
			comment C(255),
			status C(3),
			customer_id I,
			currency C(3),
			paymethod C(10),
			create_date " . CMS_ADODB_DT . ",
			modified_date " . CMS_ADODB_DT . "
			";

		// Create it. This should do error checking.
		$sqlarray = $dict->CreateTableSQL(cms_db_prefix().'module_cartms_orders',$flds, $taboptarray);
		$dict->ExecuteSQLArray($sqlarray);
		// Create a sequence
		$db->CreateSequence(cms_db_prefix().'module_cartms_orders_seq');	

		// Table schema description for table: Order lines
		$flds = "
			orderline_id I KEY,
			order_id I,
			product_id I,
			description C(255),
			qty I,
			price F,
			lineamount F,
			comment C(255),
			status C(3),
			create_date " . CMS_ADODB_DT . ",
			modified_date " . CMS_ADODB_DT . "
			";

		// Create it. This should do error checking.
		$sqlarray = $dict->CreateTableSQL(cms_db_prefix().'module_cartms_order_lines',$flds, $taboptarray);
		$dict->ExecuteSQLArray($sqlarray);
		// Create a sequence
		$db->CreateSequence(cms_db_prefix().'module_cartms_order_lines_seq');
		
		// Table schema description for table: shippingprovider
		$flds = "
			shipprov_id I KEY,
			shipprovcode C(3),
			shipprovdesc C(255),
			shipprovprice F,
			active L(1)
			";

		// Create it. This should do error checking.
		$sqlarray = $dict->CreateTableSQL(cms_db_prefix().'module_cartms_shippingprovider',$flds, $taboptarray);
		$dict->ExecuteSQLArray($sqlarray);
		// Create a sequence
		$db->CreateSequence(cms_db_prefix().'module_cartms_shippingprovider_seq');	
	}

	function DestroyTables()
	{
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);

		// Remove the database tables and sequences
		$sqlarray = $dict->DropTableSQL( cms_db_prefix().'module_cartms_carts' );
		$dict->ExecuteSQLArray($sqlarray);
		$db->DropSequence( cms_db_prefix().'module_cartms_carts_seq' );

		$sqlarray = $dict->DropTableSQL( cms_db_prefix().'module_cartms_orders' );
		$dict->ExecuteSQLArray($sqlarray);
		$db->DropSequence( cms_db_prefix().'module_cartms_orders_seq' );

		$sqlarray = $dict->DropTableSQL( cms_db_prefix().'module_cartms_order_lines' );
		$dict->ExecuteSQLArray($sqlarray);
		$db->DropSequence( cms_db_prefix().'module_cartms_order_lines_seq' );

		$sqlarray = $dict->DropTableSQL( cms_db_prefix().'module_cartms_shippingprovider' );
		$dict->ExecuteSQLArray($sqlarray);
		$db->DropSequence( cms_db_prefix().'module_cartms_shippingprovider_seq' );
	}

	function LinkToSMS( &$SMSInstalled ) {
		// Prepare settings for return to ShopMadeSimple
		$SMSInstalled = false;
		$modulename = 'ShopMadeSimple';

		$cmsmodules = $gCms->modules;
		if (isset($cmsmodules[$modulename]))
		{
			if (isset($cmsmodules[$modulename]['object'])
				&& $cmsmodules[$modulename]['installed'] == true
				&& $cmsmodules[$modulename]['active'] == true ) {
				$SMSInstalled = true;
			}
		}
	}

	function LinkToPMS( &$PaymentMSInstalled ) {
		// Prepare settings for return to PaymentMadeSimple
		$PaymentMSInstalled = false;
		$modulename = 'PaymentMadeSimple';

		$cmsmodules = $gCms->modules;
		if (isset($cmsmodules[$modulename]))
		{
			if (isset($cmsmodules[$modulename]['object'])
				&& $cmsmodules[$modulename]['installed'] == true
				&& $cmsmodules[$modulename]['active'] == true ) {
				$PaymentMSInstalled = true;
			}
		}
	}
	
	function AddProduct($product_id, $qty) {
		$sessionid = $this->GetSessionId();

		$db =& $this->module->GetDb();

		$query = 'SELECT COUNT(*) FROM '.cms_db_prefix().'module_cartms_carts WHERE session_id = ? AND product_id = ?';
		$dbresult = $db->Execute( $query, array( $sessionid, $product_id ));
		$row = $dbresult->FetchRow();
		$numRows = $row['COUNT(*)'];
		
		if($numRows == 0) 
		{
			// This item doesn't exist in the users cart, we will add it with an insert query
			$cart_id = $db->GenID(cms_db_prefix().'module_cartms_carts_seq');
			// Creation time can be used to later reorganize the carts table (remove none actual requests)
			$time = $db->DBTimeStamp(time());
			$query = 'INSERT INTO '.cms_db_prefix().'module_cartms_carts (cart_id, session_id, product_id, qty, create_date) VALUES( ?, ?, ?, ?, '.$time.' )';
			$db->Execute($query, array($cart_id, $sessionid, $product_id, $qty ));
			$numRows = 1;
		}
		else
		{
			// This item already exists in the users cart, we will update it instead
			$this->UpdateProduct($sessionid, $product_id, $qty);
		}
		
	}

	function UpdateProduct($sessionid, $product_id, $qty) {
		$db =& $this->module->GetDb();
		
		$query = 'UPDATE '.cms_db_prefix().'module_cartms_carts SET qty = ? WHERE session_id = ? AND product_id = ?';
		$db->Execute($query, array($qty, $sessionid, $product_id));

	}

	function RemoveProduct( $product_id) {
		$db =& $this->module->GetDb();
		
		$query = "DELETE FROM ".cms_db_prefix()."module_cartms_carts WHERE session_id = '" . $this->GetSessionId() . "' AND product_id = ?";
		$db->Execute($query, array($product_id));
	}

	function ClearCart() {
		$db =& $this->module->GetDb();
		
		$query = 'DELETE FROM '.cms_db_prefix().'module_cartms_carts WHERE session_id = \'' . $this->GetSessionId().'\'';
		$db->Execute($query, array());
	}

	function ShowCart( &$entryarray, &$totalcost, $id, $returnid ) {
		$db =& $this->module->GetDb();
		$query = "SELECT * FROM ".cms_db_prefix()."module_cartms_carts cart INNER JOIN ".cms_db_prefix()."module_sms_products prd ON
			 cart.product_id = prd.product_id WHERE cart.session_id = '" . $this->GetSessionId() . "' ORDER BY prd.name ASC";
		$dbresult = $db->Execute($query);

		$rowclass = 'row1';
		$entryarray = array();
		$totalcost = 0;

		while ($dbresult && $row = $dbresult->FetchRow())
		{
			$onerow = new stdClass();
			$onerow->id = $row['cart_id'];
			$onerow->product_id = $row['product_id'];
			$onerow->name = $row['name'];
			$onerow->description = $row['description'];
			$onerow->price = $this->FormatAmount( $row['price'] );
			$onerow->lineamount = $this->FormatAmount( $row['qty'] * $row['price'] );
			// Prepare the possible values of quantities
			$qtydropdown = array();
			for($i = 1; $i <= 20; $i++)
			{
				if($row['qty'] == $i)
				{
					$onerow->myqty = $i;
				}
				$qtydropdown[$i] = $i;
			}
			$onerow->qtydropdown = $qtydropdown;
			$onerow->deletelink = $this->module->CreateLink($id, 'cart', $returnid, 
				#$this->module->$gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->module->Lang('delete'),'','','systemicon'),
				$this->module->Lang('remove_product_from_cart'), 
				array('product_id'=>$row['product_id'], 'perfaction'=>'remove_product'));

			// Increment the total cost of all items
			$totalcost += ($row['qty'] * $row['price']);

			$entryarray[] = $onerow;

			$onerow->rowclass = $rowclass;
			($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
		}

	}
		
	function GetSessionId() {
		// This function will generate an encrypted string and will set it as a cookie using set_cookie. This will
		// also be used as the cookieId field in the cart table

		if(isset($_COOKIE["session_id"]))
		{
			return $_COOKIE["session_id"];
		}
		else
		{
			// There is no cookie set. We will set the cookie and return the value of the users session ID
			// Expiration time of cookie is set to 30 days
			session_start();
			setcookie("session_id", session_id(), time() + ((3600 * 24) * 30));
			return session_id();
		}
	}

	function GetOrderHeader( $order_id ) {
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		$sql = "SELECT order_id,
				totalproduct,
				totalshipping,
				totaladmincost,
				shipmode,
				comment,
				status,
				customer_id,
				currency,
				paymethod
				FROM ".cms_db_prefix()."module_cartms_orders
					WHERE order_id=?";
		$dbresult = $db->Execute( $sql, array( $order_id ));
		if( !$dbresult ) {
			return false;
		}
		$result = '';
		while( $row = $dbresult->FetchRow() ) {
			$result = $row;
		}
		return $result;	
	}

	function GetOrderShipTo( $customer_id ) {
	     // Retrieve the address from the module FrontEndUsers
		$feusers =& $this->module->GetModuleInstance('FrontEndUsers');
		if( !$feusers )
		{
		}
		else
		{
			$db =& $this->module->GetDb();
			$dict = NewDataDictionary($db);
			// Possible coding here on formating the address with regards to country formating
			// See http://bitboost.com/ref/international-address-formats.html for more info on formating
			$shipto['firstname'] = $feusers->GetUserPropertyFull( 'firstname', $customer_id );
			$shipto['surname'] = $feusers->GetUserPropertyFull( 'surname', $customer_id );
			$shipto['shiptoname'] = $shipto['firstname'].' '.$shipto['surname'];
			$shipto['email'] = $feusers->GetUserPropertyFull( 'email', $customer_id );
			$shipto['addressstreet'] = $feusers->GetUserPropertyFull( 'addressstreet', $customer_id );
			$shipto['addresscity'] = $feusers->GetUserPropertyFull( 'addresscity', $customer_id );
			$shipto['addressstate'] = $feusers->GetUserPropertyFull( 'addressstate', $customer_id );
			$shipto['addresszip'] = $feusers->GetUserPropertyFull( 'addresszip', $customer_id );
			$addresscountry = $feusers->GetUserPropertyFull( 'addresscountry', $customer_id );
			// Address formating
			switch ( $addresscountry )
			{
				case 'NL':
					$shipto['shiptoname'] .= '<br>';
					$shipto['addressstreet'] .= '<br>';
					$shipto['addresszip'] .= '&nbsp;&nbsp;'.$shipto['addresscity'].'<br>';
					$shipto['addresscity'] = '';
					$shipto['addressstate'] = '';
					break;
				default:
					$shipto['shiptoname'] .= '<br>';
					$shipto['addressstreet'] .= '<br>';
					$shipto['addresszip'] .= '<br>';
					$shipto['addresscity'] .= '<br>';
					$shipto['addressstate'] .= '<br>';
					break;
			}
			// Better would be to handle it via feusers, but I don't know how that can be achieved
			#$countries = array();
			#$countries = $feusers->GetSelectOptions( 'addresscountry' );
			// Retrieve country name
			$qry = 'SELECT * FROM '.cms_db_prefix().'module_feusers_dropdowns
					WHERE option_name = ? and control_name = ?';
			$rowitem = $db->GetRow($qry, array( $addresscountry, 'addresscountry' ));
			$shipto['addresscountry'] = $rowitem['option_text'];

			return $shipto;
		}
	}

	function GetOrderLines( $order_id ) {
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		$sql = 'SELECT orderline_id,
				ol.product_id as ol_product_id,
				qty,
				name,
				ol.description as ol_description,
				ol.price as ol_price
			FROM '.cms_db_prefix().'module_cartms_order_lines ol LEFT OUTER JOIN '.cms_db_prefix().'module_sms_products p 
			ON ol.product_id = p.product_id WHERE ol.order_id = ?
			ORDER BY name';
		$dbresult = $db->Execute( $sql, array( $order_id ));
		if( !$dbresult ) {
			return false;
		}
		$entryarray = array();

		while ($dbresult && $row = $dbresult->FetchRow())
		{
			$onerow = new stdClass();
			$onerow->orderline_id = $row['orderline_id'];
			$onerow->product_id = $row['ol_productid'];
			$onerow->name = $row['name'];
			$onerow->description = $row['ol_description'];
			$onerow->qty = $row['qty'];
			$onerow->price = $this->FormatAmount( $row['ol_price'] );
			$onerow->lineamount = $this->FormatAmount( $row['qty'] * $row['ol_price'] );

			$entryarray[] = $onerow;
		}

		return $entryarray;	
	}

	function GenerateOrder( $params ) {
		$db =& $this->module->GetDb();
		// Read all the products in the cart and copy them into order lines
		$order_id = $db->GenID(cms_db_prefix().'module_cartms_orders_seq');
		// Save the order id, so it can be used in other functions that will be called in sequence 
		$params['order_id'] = $order_id;
		$totalproduct = 0; // Contains the total amount of the products
		$totalshipping = 0; // Will contain the total shipping/handling cost
		$session_id = $params['session_id'];
		// Creation time can be used to later build reports on number of orders processed in a period
		$time = $db->DBTimeStamp(time());
		$query = 'SELECT * FROM '.cms_db_prefix().'module_cartms_carts WHERE session_id = ?';
		$dbresult = $db->Execute($query, array( $session_id ));

		while ($dbresult && $row = $dbresult->FetchRow())
		{
			// Fill all the fields in order line with found cart line information
			$orderline_id = $db->GenID(cms_db_prefix().'module_cartms_order_lines_seq');
			$product_id = $row['product_id'];
			// Retrieve item information
			$qryitem = 'SELECT * FROM '.cms_db_prefix().'module_sms_products WHERE product_id = ?';
			$rowitem = $db->GetRow($qryitem, array( $product_id ));
			$description = $rowitem['description'];
			$price = $rowitem['price'];
			$qty = $row['qty'];
			$lineamount = $qty * $price;
			$comment = '';
			$status = 'RCV'; // Received for processing
			$modtime = NULL;
			$query = 'INSERT INTO '.cms_db_prefix().'module_cartms_order_lines 
				(orderline_id, order_id, product_id, description, qty, price, lineamount, comment, status, create_date, modified_date) 
				VALUES( ?, ?, ?, ?, ?, ?, ?, ?, ?, '.$time.', ? )';
			$db->Execute($query, array($orderline_id, 
								$order_id, 
								$product_id, 
								$description, 
								$qty, 
								$price, 
								$lineamount,
								$comment,
								$status,
								$modtime ));
			// Cumulate the total fields for the order header
			$totalproduct += $lineamount;
		}
		// Check and add administration cost if needed
		$totaladmincost = 0;	
		$admincostadd = $this->module->GetPreference('admincostadd', false);
		if ( $admincostadd ) {
			// Check ordering amount against minimum order amount
			if ( $totalproduct < $this->module->GetPreference('admincostminamount', 100) ) {
				$totaladmincost = $this->module->GetPreference('admincost', 0);
			}
		}
		// Sum information to store in order header
		$shipmode = NULL; // Will follow later
		$comment = NULL;
		$status = 'INT'; // Initiated
		$customer_id = $params['user_id'];
		$currency = 'EUR'; // Will be coming from preferences
		$paymethod = NULL; // Will follow later
		$query = 'INSERT INTO '.cms_db_prefix().'module_cartms_orders 
			(order_id, totalproduct, totalshipping, totaladmincost, shipmode, 
			comment, status, customer_id, currency, paymethod, create_date, modified_date) 
			VALUES( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, '.$time.', ? )';
		$db->Execute($query, array($order_id, 
							$totalproduct, 
							$totalshipping, 
							$totaladmincost, 
							$shipmode, 
							$comment,
							$status,
							$customer_id,
							$currency,
							$paymethod,
							$modtime ));			
	}

	function SwitchStatus( $params ) {
		$db =& $this->module->GetDb();
		switch ($params['oldstatus'])
		{
			case 'INT':
				$query = 'UPDATE '.cms_db_prefix().'module_cartms_orders SET status = ?, modified_date = '.$db->DBTimeStamp(time()).' WHERE order_id = ?';
				$db->Execute($query, array( 'CNF', $params['order_id']));
				break;
			case 'CNF':
				$query = 'UPDATE '.cms_db_prefix().'module_cartms_orders SET status = ?, modified_date = '.$db->DBTimeStamp(time()).' WHERE order_id = ?';
				$db->Execute($query, array( 'PAY', $params['order_id']));
				break;
			case 'PAY':
				$query = 'UPDATE '.cms_db_prefix().'module_cartms_orders SET status = ?, modified_date = '.$db->DBTimeStamp(time()).' WHERE order_id = ?';
				$db->Execute($query, array( 'SHP', $params['order_id']));
				break;
			case 'SHP':
				$query = 'UPDATE '.cms_db_prefix().'module_cartms_orders SET status = ?, modified_date = '.$db->DBTimeStamp(time()).' WHERE order_id = ?';
				$db->Execute($query, array( 'INV', $params['order_id']));
				break;
			default:
				break;
		}
print '<pre><font color="blue">'; var_dump($params); print '</font></pre>'; // <-- debug line
	    // Redirect the user to the default admin screen if requested, else leave up to calling program
	    if (isset($params['active_tab'])) {
			$params = array('active_tab' => 'order');
			$this->module->Redirect($id, 'defaultadmin', $returnid, $params);
	    }
    }

	function StoreShipInfo( $params ) 	{
		// In the second step of the order processing, the visitor has entered a ship to address
		// Now that we know it, store it using FEU for later usage
	     // At this moment we're allowing instant registration (so no checks)
		$feusers =& $this->module->GetModuleInstance('FrontEndUsers');
		if( !$feusers )
		{
		}
		else
		{
			$db =& $this->module->GetDb();
			$dict = NewDataDictionary($db);
			$username = $params['firstname'].' '.$params['lastname'];
			$username = str_replace(' ', '_', $username);
			// Now check if the user already exists
			$group_id = $feusers->GetGroupID('CartMadeSimple');
			$password = 'qaqaqa';  // Very temporary solution. Will become a generated one
			$expires = strtotime('+5 years');
			// Add the customer
			$result = $feusers->AddUser( $username, $password, $expires );
			// Retrieve the id
			$query = 'SELECT * FROM '.cms_db_prefix().'module_feusers_users_seq';
			$row = $db->GetRow($query);
			$user_id = $row['id'];
			// Save the user_id for later
			$params['user_id'] = $user_id;
			// Connect customer to group
			#$result = $feusers->AssignUserToGroup( $user_id, $group_id );
			$query = "INSERT INTO ".cms_db_prefix()."module_feusers_belongs VALUES (?,?)";
			$db->Execute( $query, array( $user_id, $group_id ) );
			// Address id (read user_id) is known
			// Save the address in the connected property fields of customer
			$result = $feusers->SetUserPropertyFull( 'firstname', $params['firstname'], $user_id );
			$result = $feusers->SetUserPropertyFull( 'surname', $params['lastname'], $user_id );
			$result = $feusers->SetUserPropertyFull( 'email', $params['email'], $user_id );
			$result = $feusers->SetUserPropertyFull( 'addressstreet', $params['addressstreet'], $user_id );
			$result = $feusers->SetUserPropertyFull( 'addresscity', $params['addresscity'], $user_id );
			$result = $feusers->SetUserPropertyFull( 'addressstate', $params['addressstate'], $user_id );
			$result = $feusers->SetUserPropertyFull( 'addresszip', $params['addresszip'], $user_id );
			$result = $feusers->SetUserPropertyFull( 'addresscountry', $params['addresscountry'], $user_id );
		
		}
	}

	function StoreDeliveryInfo( $params ) {
		// In the third step of the order processing, the visitor has entered a delivery method
		// Now that we know it, store it in the order
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		
		$deliverymethod = $params['deliverymethod'];
		$order_id = $params['order_id'];

		$query = 'UPDATE '.cms_db_prefix().'module_cartms_orders set shipmode = ? WHERE order_id = ?';
		$db->Execute($query, array($deliverymethod, $order_id));
			
	}

	function StorePaymentInfo( $params ) {
		// In the fourth step of the order processing, the visitor has entered a payment method
		// Now that we know it, store it in the order
		$db =& $this->module->GetDb();
		$dict = NewDataDictionary($db);
		
		$paymentmethod = $params['paymentmethod'];
		$order_id = $params['order_id'];
		
		$query = 'UPDATE '.cms_db_prefix().'module_cartms_orders set paymethod = ? WHERE order_id = ?';
		$db->Execute($query, array($paymentmethod, $order_id));
	
	}
	
	function FormatAmount ( $amount ) {
		$formatdecimals = $this->module->GetPreference('numberformatdecimals', '2');
		$formatdecimal_point = $this->module->GetPreference('numberformatdec_point', ',');
		$formatthousand_sep = $this->module->GetPreference('numberformatthousand_sep', '.');
		return number_format($amount, $formatdecimals, $formatdecimal_point, $formatthousand_sep);

	}
}
?>