<?php
#-------------------------------------------------------------------------
# Module: Cart Made Simple - An Order Intake module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown <duketown@mantox.nl>
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/cartms/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

if (!isset($gCms)) exit;

// Based upon the status, the orders will be shown. Default the confirmed orders are shown
if (isset($params['orderstatus'])) {
	$orderstatus = $params['orderstatus'];
}
else {
	$orderstatus = 'CNF';
}

// Show for each status the orders by order number, but on invoiced orders eldest at bottom
$orderby = ' ORDER BY order_id';
if ($orderstatus == 'INV') {
	$orderby = ' ORDER BY modified_date DESC';
}

$listorders = array();
$query = 'SELECT * FROM '.cms_db_prefix().'module_cartms_orders, '.cms_db_prefix().'module_feusers_users 
	WHERE customer_id = id and status = ?'
	.$orderby;
$dbresult = $db->Execute($query, array($orderstatus) );

$rowclass = 'row1';
$entryarray = array();

while ($dbresult && $row = $dbresult->FetchRow())
{
	$onerow = new stdClass();

	$onerow->order_id = $this->CreateLink($id, 'ordershowdetail', $returnid, $row['order_id'], array('order_id'=>$row['order_id'], 'orderstatus'=>$orderstatus));
	$onerow->shipmode = $this->CreateLink($id, 'ordershowdetail', $returnid, $row['shipmode'], array('order_id'=>$row['order_id'], 'orderstatus'=>$orderstatus));
	$onerow->customername = $this->CreateLink($id, 'ordershowdetail', $returnid, $row['username'], array('order_id'=>$row['order_id'], 'orderstatus'=>$orderstatus));
	$onerow->modificationdate = $row['modified_date'];
	/* Show the icons needed for editing, deleting */
	$onerow->viewlink = $this->CreateLink($id, 'ordershowdetail', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/view.gif', $this->Lang('ordershowdetail'),'','','systemicon'), 
		array('order_id'=>$row['order_id'], 'orderstatus'=>$orderstatus));
	if ( $orderstatus != 'INT' && $orderstatus != 'INV' ) {
		$onerow->switchlink = $this->CreateLink($id, 'switchstatus', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/accept.gif', 
			$this->Lang('statusorderfrom'.$orderstatus),'','','systemicon'), array('oldstatus'=>$orderstatus, 'order_id'=>$row['order_id'], 'active_tab'=>'order'));
	}
	#$onerow->deletelink = $this->CreateLink($id, 'deleteorder', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'),'','','systemicon'), array('order_id'=>$row['order_id']), $this->Lang('areyousureorder'));

	$onerow->rowclass = $rowclass;

	$entryarray[] = $onerow;

	($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
}
$this->smarty->assign_by_ref('orders', $entryarray);

$this->smarty->assign('title_ordercount', $this->Lang('title_ordercountstat'.$orderstatus));
$this->smarty->assign('ordercount', count($entryarray));

// Prepare the links to see the orders per status
$this->smarty->assign('selectINTorderslink', $this->CreateLink($id, 'defaultadmin', $returnid, $this->Lang('showenteredorders'), 
	array('active_tab'=>'order', 'orderstatus'=>'INT'), '', false, false, 'class="pageoptions"'));
$this->smarty->assign('selectCNForderslink', $this->CreateLink($id, 'defaultadmin', $returnid, $this->Lang('showconfirmedorders'), 
	array('active_tab'=>'order', 'orderstatus'=>'CNF'), '', false, false, 'class="pageoptions"'));
$this->smarty->assign('selectPAYorderslink', $this->CreateLink($id, 'defaultadmin', $returnid, $this->Lang('showpaidorders'), 
	array('active_tab'=>'order', 'orderstatus'=>'PAY'), '', false, false, 'class="pageoptions"'));
$this->smarty->assign('selectSHPorderslink', $this->CreateLink($id, 'defaultadmin', $returnid, $this->Lang('showshippedorders'), 
	array('active_tab'=>'order', 'orderstatus'=>'SHP'), '', false, false, 'class="pageoptions"'));
$this->smarty->assign('selectINVorderslink', $this->CreateLink($id, 'defaultadmin', $returnid, $this->Lang('showinvoicedorders'), 
	array('active_tab'=>'order', 'orderstatus'=>'INV'), '', false, false, 'class="pageoptions"'));

$this->smarty->assign('ordertext', $this->Lang('title_orders'));
$this->smarty->assign('shipmodetext', $this->Lang('title_shipmode'));
$this->smarty->assign('customernametext', $this->Lang('title_customername'));
$this->smarty->assign('moddatetext', $this->Lang('title_modificationdate'));

#Display template
echo $this->ProcessTemplate('listorders.tpl');
?>