<?php
# Module: Cart Made Simple - An Order Intake module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown <duketown@mantox.nl>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/teamsportscores
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

if (!isset($gCms)) exit;

global $gCms;
$db =& $gCms->GetDb();

if (isset($params['cancel']))
{
	$params = array('active_tab' => 'orders', 'orderstatus'=>$params['orderstatus']);
	$this->Redirect($id, 'defaultadmin', $returnid, $params);
}

if (isset($params['order_id']))
{
	$order_id = $params['order_id'];
}

if (isset($params['submit']))
{
	// Set status of order to next status
	$params['oldstatus'] = $params['orderstatus'];
	$params['active_tab'] = 'order';
	$this->orders->SwitchStatus( $params );
}

// Prepare shipping information
$orderheader = array();
$orderheader = $this->orders->GetOrderHeader( $order_id );
$orderstatus = $orderheader['status'];
$this->smarty->assign('welcometitle', $this->Lang('title_orderhandling'.$orderstatus));

$shipto = array();
$shipto = $this->orders->GetOrderShipTo( $orderheader['customer_id'] );
$this->smarty->assign('shiptoname', $shipto['shiptoname']);
$this->smarty->assign('shiptostreet', $shipto['addressstreet']);
$this->smarty->assign('shiptocity', $shipto['addresscity']);
$this->smarty->assign('shiptostate', $shipto['addressstate']);
$this->smarty->assign('shiptozip', $shipto['addresszip']);
$this->smarty->assign('shiptocountry', $shipto['addresscountry']);

// Prepare overview of order lines
$products = array();
$products = $this->orders->GetOrderLines( $order_id );
$this->smarty->assign_by_ref('products', $products);

if ( $orderheader['totaladmincost'] <> 0 ) {
	$formattedamount = $this->orders->FormatAmount( $orderheader['totaladmincost'] );
	$currency = $this->GetPreference('cartcurrency', 'Eur');
	$this->smarty->assign('label_admin_amount',$this->Lang('adminamount'));
	$this->smarty->assign('admin_amount', $formattedamount);
}
$formattedamount = $this->orders->FormatAmount( $orderheader['totalproduct'] + $orderheader['totalshipping'] + $orderheader['totaladmincost'] );
$currency = $this->GetPreference('cartcurrency', 'Eur');
$this->smarty->assign('label_total_amount',$this->Lang('ordertotals'));
$this->smarty->assign('total_amount', $currency.' '.$formattedamount);
// Prepare delivery method
switch ( $orderheader['shipmode'] )
{
	case 'SEC':
		$this->smarty->assign('deliveryvia', $this->Lang('deliverselfcollect'));
		break;
	case 'TNT':
		$this->smarty->assign('deliveryvia', $this->Lang('delivertnt'));
		break;
	case 'UPS':
		$this->smarty->assign('deliveryvia', $this->Lang('deliverups'));
		break;
	default:
		$this->smarty->assign('deliveryvia', $this->Lang('deliverselfcollect'));
		break;
}
// Prepare payment method
switch ( $orderheader['shipmode'] )
{
	case 'PAYUF':
		$this->smarty->assign('paymentvia', $this->Lang('paymentupfront'));
		break;
	case 'PAYPAL':
		$this->smarty->assign('paymentvia', $this->Lang('paymentpaypal'));
		break;
	case 'WORLDPAY':
		$this->smarty->assign('paymentvia', $this->Lang('paymentworldpay'));
		break;
	default:
		$this->smarty->assign('paymentvia', $this->Lang('paymentupfront'));
		break;
}

#Display template
$this->smarty->assign('startform', $this->CreateFormStart($id, 'ordershowdetail', $returnid));
$this->smarty->assign('ordernumber_label', $this->Lang('title_orders'));
$this->smarty->assign('ordernumber', $order_id);
$this->smarty->assign('shipto_label', $this->Lang('title_shippingaddress'));
$this->smarty->assign('productqtytext', $this->Lang('productqtytext'));
$this->smarty->assign('productnametext', $this->Lang('productnametext'));
$this->smarty->assign('productpricetext', $this->Lang('productpricetext'));
$this->smarty->assign('lineamounttext', $this->Lang('lineamounttext'));
$this->smarty->assign('deliveryvia_label', $this->Lang('deliverymethod_via'));
$this->smarty->assign('paymentvia_label', $this->Lang('paymentmethod_via'));

$this->smarty->assign('hidden', $this->CreateInputHidden($id, 'order_id', $order_id));
$this->smarty->assign('hiddenstatus', $this->CreateInputHidden($id, 'orderstatus', $orderstatus));
if ( $orderstatus != 'INT' && $orderstatus != 'INV' ) {
	$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', $this->Lang('statusorderfrom'.$orderstatus)));
}
$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', $this->Lang('cancel')));
$this->smarty->assign('endform', $this->CreateFormEnd());

echo $this->ProcessTemplate('adminshoworder.tpl');
?>
