<?php
# Module: Cart Made Simple - An Order Intake module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown <duketown@mantox.nl>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/teamsportscores
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

if (!isset($gCms)) exit;

global $gCms;
$db =& $gCms->GetDb();

if (isset($params['cancel']))
{
	// Redirect needed to cart
	$this->RedirectForFrontend( $id, $returnid, 'cart', $params, true);
}

if (isset($params['submit_register']))
{
	$submit_register = $params['submit_register'];
}

if (isset($params['submit_login']))
{
	$submit_login = $params['submit_login'];
}

if (isset($params['continue']))
{
	// Store the entered shipping information
	$this->orders->StoreShipInfo( &$params, &$shipto );
	// Generate order from cart information
	$params['session_id'] = $this->orders->GetSessionId();
	$this->orders->GenerateOrder( &$params );
	// Shipping information filled, commence to payment information
	$params['perfaction'] = 'request_delivery_info';
	$this->RedirectForFrontend( $id, $returnid, 'order', $params, true);
	
}

if (!isset($params['addresscountry'])) {
	// First time here, show the first country of the selectable countries
	$selectedcountry = -1;
}
else {
	// Set the selected country (otherwise first one will be shown)
	$val = $params['addresscountry'];
}

// Check if the user allready has logged in. If not temporary save the customer address.
$feusers =& $this->GetModuleInstance('FrontEndUsers');
$userloggedin = $feusers->loggedin();
if ( !$userloggedin )
{
	$this->smarty->assign('welcometitle', $this->Lang('title_welcomelogin'));
	$errorfound = false;
	// Perform a check on all the entries. All are mandatory
	if (isset($params['submit']))
	{
		// Validate first name of visitor
		if (isset($params['firstname']))
		{
			$firstname = $params['firstname'];
			$this->smarty->assign('firstname_error', '');
			if ($firstname == '')
			{
				$this->smarty->assign('firstname_error', $this->Lang('errorfirstnameblank'));
				$errorfound = true;
			}
		}

		// Validate last name of visitor
		if (isset($params['lastname']))
		{
			$lastname = $params['lastname'];
			$this->smarty->assign('lastname_error', '');
			if ($lastname == '')
			{
				$this->smarty->assign('lastname_error', $this->Lang('errorlastnameblank'));
				$errorfound = true;
			}
		}

		// Validate email address of visitor
		if (isset($params['email']))
		{
			$email = $params['email'];
			$this->smarty->assign('email_error', '');
			if ($email == '')
			{
				$this->smarty->assign('email_error', $this->Lang('erroremailblank'));
				$errorfound = true;
			}
			// Check if the format of the entered email is correct
			if (!eregi("^[A-Z0-9._%-]+@[A-Z0-9._%-]+\.[A-Z]{2,6}$", $email))
			{
				$this->smarty->assign('email_error', $this->Lang('erroremailformat'));
				$errorfound = true;
			}

		}

		// Validate street address of visitor
		if (isset($params['addressstreet']))
		{
			$addressstreet = $params['addressstreet'];
			$this->smarty->assign('addressstreet_error', '');
			if ($addressstreet == '')
			{
				$this->smarty->assign('addressstreet_error', $this->Lang('erroraddressstreetblank'));
				$errorfound = true;
			}
		}

		// Validate city of visitor
		if (isset($params['addresscity']))
		{
			$addresscity = $params['addresscity'];
			$this->smarty->assign('addresscity_error', '');
			if ($addresscity == '')
			{
				$this->smarty->assign('addresscity_error', $this->Lang('erroraddresscityblank'));
				$errorfound = true;
			}
		}

		// Validate state of visitor
		if (isset($params['addressstate']) && $this->GetPreference('mandatorystate', false))
		{
			$addressstate = $params['addressstate'];
			$this->smarty->assign('addressstate_error', '');
			if ($addressstate == '')
			{
				$this->smarty->assign('addressstate_error', $this->Lang('erroraddressstateblank'));
				$errorfound = true;
			}
		}

		// Validate Zip/Postal code of visitor
		if (isset($params['addresszip']))
		{
			$addresszip = $params['addresszip'];
			$this->smarty->assign('addresszip_error', '');
			if ($addresszip == '')
			{
				$this->smarty->assign('addresszip_error', $this->Lang('erroraddresszipblank'));
				$errorfound = true;
			}
		}

		// Validate country of visitor
		if (isset($params['addresscountry']))
		{
			$addresscountry = $params['addresscountry'];
			$this->smarty->assign('addresscountry_error', '');
			if ($addresscountry == '')
			{
				$this->smarty->assign('addresscountry_error', $this->Lang('erroraddresscountryblank'));
				$errorfound = true;
			}
		}

		// Fill separate message for header
		if (!$errorfound) 
		{
			$this->smarty->assign('welcometitle', $this->Lang('checkshipinfo'));
			$this->smarty->assign('continue', $this->CreateInputSubmit($id, 'continue', $this->Lang('continuestep2')));
		}
	}
}

#Display template
$this->smarty->assign('startform', $this->CreateFormStart($id, 'orderaddress', $returnid));
$this->smarty->assign('title_fieldset_ec', $this->Lang('title_fieldset_exist_customer'));
$this->smarty->assign('title_fieldset_nc', $this->Lang('title_fieldset_new_customer'));
$this->smarty->assign('title_username', $this->Lang('title_username'));
$this->smarty->assign('firstname_label', $this->Lang('firstname_label'));
$this->smarty->assign('firstname_input', $this->CreateInputText($id, 'firstname', $firstname, 40, 40));
$this->smarty->assign('lastname_label', $this->Lang('lastname_label'));
$this->smarty->assign('lastname_input', $this->CreateInputText($id, 'lastname', $lastname, 40, 40));
$this->smarty->assign('email_label', $this->Lang('email_label'));
$this->smarty->assign('email_input', $this->CreateInputText($id, 'email', $email, 40, 255));
$this->smarty->assign('addressstreet_label', $this->Lang('addressstreet_label'));
$this->smarty->assign('addressstreet_input', $this->CreateInputText($id, 'addressstreet', $addressstreet, 40, 40));
$this->smarty->assign('addresscity_label', $this->Lang('addresscity_label'));
$this->smarty->assign('addresscity_input', $this->CreateInputText($id, 'addresscity', $addresscity, 40, 40));
$this->smarty->assign('addressstate_label', $this->Lang('addressstate_label'));
$this->smarty->assign('addressstate_input', $this->CreateInputText($id, 'addressstate', $addressstate, 15, 15));
$this->smarty->assign('addresszip_label', $this->Lang('addresszip_label'));
$this->smarty->assign('addresszip_input', $this->CreateInputText($id, 'addresszip', $addresszip, 15, 15));
$this->smarty->assign('addresscountry_label', $this->Lang('addresscountry_label'));
$this->smarty->assign('addresscountry_input', $this->CreateInputDropdown( $id, 
							'addresscountry', 
							$feusers->GetSelectOptions('addresscountry', 1), 
							$selectedcountry, 
							$val));

$this->smarty->assign('hidden', '');
$this->smarty->assign('register', $this->CreateInputSubmit($id, 'sumbit_register', $this->Lang('customer_register')));
$this->smarty->assign('login', $this->CreateInputSubmit($id, 'submit_login', $this->Lang('customer_login')));
$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', $this->Lang('submit')));
$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', $this->Lang('cancel')));
$this->smarty->assign('endform', $this->CreateFormEnd());

// Not entirely sure if there will be multiple login templates in the database
#$template = 'fe_'.$this->GetPreference('fe_template_login');
$template = 'fe_template_login';
if (isset($params['fe_template']))
  {
    $template = 'fe_'.$params['fe_template'];
  }
#echo $this->ProcessTemplateFromDatabase($template);
echo $this->ProcessTemplate('fe_shipping_info.tpl');
?>
