<?php


if($config['errors_on']){
	error_reporting(E_ALL);
	ini_set('error_reporting', E_ALL);
}

if (!isset($gCms)) exit;

#
# The tab headers
#
echo $this->StartTabHeaders();
if (FALSE == empty($params['active_tab']))
{
	$tab = $params['active_tab'];
} else {
	$tab = '';
}

if ($this->CheckPermission('Use CartMadeSimple'))
{
	echo $this->SetTabHeader('order',$this->Lang('orderadmin'), ('order' == $tab)?true:false);
	echo $this->SetTabHeader('cart',$this->Lang('cartadmin'), ('cart' == $tab)?true:false);
	echo $this->SetTabHeader('delivery',$this->Lang('delivery'), ('delivery' == $tab)?true:false);
}
	
if ($this->CheckPermission('Modify Templates'))
{
	echo $this->SetTabHeader('cart_template',$this->Lang('carttemplate'), ('cart_template' == $tab)?true:false);
	echo $this->SetTabHeader('userauth_template',$this->Lang('userauthtemplate'), ('userauth_template' == $tab)?true:false);
}
	
if ($this->CheckPermission('Modify Site Preferences'))
{
	echo $this->SetTabHeader('config',$this->Lang('cartconfig'), ('config' == $tab)?true:false);
}
echo $this->EndTabHeaders();

#
# The content of the tabs
#
echo $this->StartTabContent();
if ($this->CheckPermission('Use CartMadeSimple'))
{
	// Handling orders based upon their status
	echo $this->StartTab('order', $params);
	include(dirname(__FILE__).'/function.admin_orders_tab.php');
	echo $this->EndTab();

	// All the parameters/options that are valid for this module
	echo $this->StartTab('cart', $params);
	echo "<h3>" . $this->Lang('title_cart'). "</h3>";
	include(dirname(__FILE__).'/function.admin_main_tab.php');
	echo $this->EndTab();

	// Basic handling of delivery methods
	echo $this->StartTab('delivery', $params);
	echo "<h3>" . $this->Lang('title_delivery'). "</h3>";
	include(dirname(__FILE__).'/function.admin_delivery_tab.php');
	echo $this->EndTab();
}

if( $this->CheckPermission( 'Modify Templates' ) )
{
	// All templates that are cart related
	echo $this->StartTab('cart_template', $params);
	echo "<h3>" . $this->Lang('title_cart_template'). "</h3>";
	$params['template'] = 'cart_';
	include(dirname(__FILE__).'/function.admin_listtemplates.php');
	echo $this->EndTab();

	// All templates that are customer authorization related
	echo $this->StartTab('userauth_template', $params);
	echo "<h3>" . $this->Lang('title_userauth_template'). "</h3>";
	$params['template'] = 'userauth_';
	include(dirname(__FILE__).'/function.admin_listtemplates.php');
	echo $this->EndTab();
}

if ($this->CheckPermission('groupPermPerms') )
{
	// Configuration of this module (more the meta level)
	echo $this->StartTab('config', $params);
	echo "<h3>" . $this->Lang('title_config') . "</h3>";
	include(dirname(__FILE__).'/function.admin_config_tab.php');
	echo $this->EndTab();
}


?>
