<?php
$lang['friendlyname'] = 'Flickr Module';
$lang['postinstall'] = 'To start using this module you must enter your flickr.com API key in the Flickr module setup. If you do not have an API key you can obtain one from flickr.com here: <a href="http://www.flickr.com/services/api/misc.api_keys.html">http://www.flickr.com/services/api/misc.api_keys.html</a>';
$lang['postuninstall'] = 'The Flickr module has been uninstalled and the Flickr cache table has been removed from the database.';
$lang['installed'] = 'Module version %s installed.';
$lang['accessdenied'] = 'Access Denied. Please check your permissions.';
$lang['error'] = 'Error!';
$lang['errorusername'] = 'Flickr error, no username specified';
$lang['errorapikey'] = 'Flickr error, no api key specified';
$lang['flickrerrorusername'] = 'Flickr error: Username does not exist. flickr.com does not recognize the username "%s".';
$lang['flickrerrorset'] = 'Flickr error: set does not exist. flickr.com does not recognize the set with the id "%s".';
$lang['flickrerrorphoto'] = 'Flickr error: photo does not exist. flickr.com does not recognize the photo with the id "%s".';
$lang['upgraded'] = 'Module upgraded to version %s.';
$lang['moddescription'] = '<p>This module allows you to integrate your photo album from flickr.com into CMS.</p>';
$lang['published'] = 'Published on';
$lang['taken'] = 'Taken on';
$lang['atflickr'] = 'This photo at Flickr';
$lang['firstphoto'] = 'You are at the first photo';
$lang['lastphoto'] = 'You are at the last photo';
$lang['clearcache'] = 'Clear Flickr cache';
$lang['clearcachedescription'] = 'Press this button to clear the Flickr cache. All locally stored information from flickr.com will be removed. Use this if you have just modified your Flickr photo gallery and want the changes to be visible through the Flickr module.';
$lang['foundusernames'] = 'The following Flickr usernames are in use and the cache will be built with photos from these accounts';
$lang['refreshcache'] = 'Rebuild Flickr cache';
$lang['refreshcachedescription'] = 'Press this button to rebuild the Flickr cache. All the information from flickr.com that is necessary to display your photos will be fetched and stored locally. This will in most situations mean that pages are generated much faster. Note that the cache timeout you can specify in the module tag will determine how long the cached data are valid.';
$lang['nextphoto'] = 'next &gt;';
$lang['prevphoto'] = '&lt; prev';
$lang['preferences'] = 'Preferences';
$lang['enterapikey'] = 'Flickr.com API key';
$lang['cachetime'] = 'Cache time (seconds)';
$lang['savepreferences'] = 'Save preferences';
$lang['rebuildexternaltitle'] = 'Rebuild cache automatically (advanced)';
$lang['rebuildexternaldescription'] = 'If you want to automatically rebuild the cache with a regular interval (e.g. every night) you can use the URL in the following link. This URL will trigger the same rebuild as if you pressed the "Rebuild Flickr cache" button above and can therefore be used if you want to trigger the rebuild from a script.';
$lang['rebuildexternallinktitle'] = 'Use the URL of this link.';

$lang['changelog'] = '<ul><li><p>Version 0.5 - 5 September 2005.</p><p>Initial Release.</p></li></ul>';

$lang['help'] = '<h3>What Does This Do?</h3>
<p>Flickr is a module for integrating photo albums from flickr.com into your site. 
It will display all your sets of photos within a CMS page and can be heavily customized.</p>
<h3>How Do I Use It</h3>
<p>As this is just a tag module, it is inserted into your page or template by using the cms_module tag. 
An example using only the required parameters would be: <code>{cms_module module="Flickr" username="Your flickr.com username"}</code>. 
Additionally you can add a number of optional parameters, see below.</p>
<h3>What parameters are there?</h3>
<p>
<ul>
<li><em>(Required)</em> <tt>username</tt> - This parameter specifies your flickr.com username. Note that the username is also called "Screen name" in flickr.com terminology.</li>
<li><em>(Optional)</em> <tt>photos_per_page</tt> - Use this parameter to limit the number of thumbnails shown on each page for a photo set. Default is 20, set to a high number to disable.</li>
<li><em>(Optional)</em> <tt>setlist_template</tt> - If you want to use another template than <code>setlist.tpl</code> to display a list of photo sets, then use this tag. Note that you must include the .tpl extension.</li>
<li><em>(Optional)</em> <tt>set_template</tt> - If you want to use another template than <code>set.tpl</code> to display a photo set, then use this tag. Note that you must include the .tpl extension.</li>
<li><em>(Optional)</em> <tt>photo_template</tt> - If you want to use another template than <code>photo.tpl</code> to display a single photo, then use this tag. Note that you must include the .tpl extension.</li>
<li><em>(Optional)</em> <tt>title</tt> - Title which is used on the frontpage of the gallery (ie. the page with a list of sets). The title is only displayed on this page.</li>
<li><em>(Optional)</em> <tt>intro</tt> - Text which is displayed under the title on the frontpage of the gallery (ie. the page with a list of sets). The text is only displayed on this page.</li>
</ul>

<p>The following parameters are a bit special since they alter the output of of the module completely. 
If you set the <code>breadcrumbs</code> parameter to 1 then the module will return a breadcrumbs-like
path to the current photo but nothing else. Intended use it that the module is inserted twice on a 
single page, once for generating the breadcrumbs and once for generating the gallery.</p>

<ul>
<li><em>(Optional)</em> <tt>breadcrumbs</tt> - (0/1) Enable breadcrumbs mode. Default is 0.</li>
<li><em>(Optional)</em> <tt>breadcrumbs_delimiter</tt> - Text to seperate entries in the list (default "&gt;&gt;").</li>
<li><em>(Optional)</em> <tt>breadcrumbs_initial</tt> - (0/1) If set to 1 start the breadcrumbs with a delimiter (default 0).</li>
<li><em>(Optional)</em> <tt>breadcrumbs_root</tt> - Page alias of a page you want to always appear as the first page in the list. Can be used to make a page (e.g. the front page) appear to be the root of everything even though it is not.</li>
</ul>
</p>

<h3>Copyright and License</h3>
<p>Copyright &copy; 2005, Allan Larsen <a href="mailto:cms@bogong.dk">&lt;cms@bogong.dk&gt;</a>. All Rights Are Reserved.</p>
<p>This module has been released under the <a href="http://www.gnu.org/licenses/licenses.html#GPL">GNU Public License</a>. You must agree to this license before using the module.</p>
';
?>
