<?php
#-------------------------------------------------------------------------
# Module: Flickr - CMS module for a flickr.com based gallery
# Version: 0.5, Allan Larsen <cms@bogong.dk>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------


class Flickr extends CMSModule
{
        // General variables
        var $setlist_template;
        var $set_template;
        var $photo_template;
        var $photos_per_page;

        // breadcrumbs variables
        var $breadcrumbs;
        var $breadcrumbs_delimiter;
        var $breadcrumbs_initial;
        var $breadcrumbs_root;

        // phpFlickr object
        var $f = null;
        var $cache_table;

    	function GetName()
	{
		return 'Flickr';
	}

	function GetFriendlyName()
	{
		return $this->Lang('friendlyname');
	}

	function GetVersion()
	{
		return '0.5';
	}

	function GetHelp()
	{
		return $this->Lang('help');
	}

	function GetAuthor()
	{
		return 'Allan Larsen';
	}

	function GetAuthorEmail()
	{
		return 'cms@bogong.dk';
	}

	function GetChangeLog()
	{
		return $this->Lang('changelog');
	}

	function IsPluginModule()
	{
		return true;
	}

	function HasAdmin()
	{
		return true;
	}

	function GetAdminSection()
	{
		return 'extensions';
	}


	function GetAdminDescription()
	{
		return $this->Lang('moddescription');
	}


	function VisibleToAdminUser()
	{
		return $this->CheckPermission('Modify Site Preferences');
	}

	function Install()
	{
                // The cache table is not created here, it is created by phpFlickr
                // on the first use.

                $this->SetPreference("api_key", "");
                $this->SetPreference("cache_time", "3600");
		$this->Audit( 0, $this->Lang('friendlyname'), $this->Lang('installed',$this->GetVersion()));
	}

        function Uninstall()
        {
		$db = $this->cms->db;
		
		// remove the flickr cache table
		$dict = NewDataDictionary($db);
		$sqlarray = $dict->DropTableSQL(cms_db_prefix() . "module_flickr_cache");
		$dict->ExecuteSQLArray($sqlarray);

		// remove the preference
		$this->RemovePreference("api_key");
		$this->RemovePreference("cache_time");
        }

	function InstallPostMessage()
	{
		return $this->Lang('postinstall');
	}

	function UninstallPostMessage()
	{
		return $this->Lang('postuninstall');
	}

	function DoAction($action, $id, $params, $return_id=-1)
	{
        	global $gCms; 

                set_include_path(dirname(__FILE__).'/phpFlickr' . PATH_SEPARATOR . get_include_path());
                require_once("phpFlickr/phpFlickr.php");

                // Set default values
                $this->setlist_template = "setlist.tpl";
                $this->set_template = "set.tpl";
                $this->photo_template = "photo.tpl";
                $this->breadcrumbs = false;
                $this->breadcrumbs_delimiter = "&gt;&gt;";
                $this->breadcrumbs_initial = false;
                $this->breadcrumbs_root = "";
                $this->photos_per_page = 20;
                $this->cache_table = cms_db_prefix() . "module_flickr_cache";

		switch ($action)
		{
			case 'default':
			{
				// this is the plug-in side, i.e., non-Admin
				$this->DisplayModuleOutput($id, $params, $return_id);
				break;
			}
			case 'defaultadmin':
			{
				// only let people access module preferences if they have permission
				if ($this->CheckPermission('Modify Site Preferences'))
				{
					$this->DisplayAdminPanel($id, $params, $return_id);
				}
				else
				{
					$this->DisplayErrorPage($id, $params, $return_id, "Access denied");
				}
				break;
			}
                        case 'refresh':
                        {
                                $this->RefreshCache();
                                break;
                        }
		}
	}

        function PageURL()
        {
        	global $gCms; 

                // Get info about current page
	        $thispage = ContentManager::LoadContentFromAlias($gCms->variables['page'], false);
                
                // Return URL of current page
                return $thispage->getURL();
        }

        function PageName()
        {
        	global $gCms; 

                // Get info about current page
	        $thispage = ContentManager::LoadContentFromAlias($gCms->variables['page'], false);
                
                // Return name of current page
                return $thispage->MenuText();
        }

        function PageAlias()
        {
        	global $gCms; 

                // Get info about current page
	        $thispage = ContentManager::LoadContentFromAlias($gCms->variables['page'], false);
                
                // Return alias of current page
                return $thispage->Alias();
        }

        function GetURL($set_id = 0, $pic_id = 0, $index = 0)
        {
                $url = $this->PageURL();
                if ($this->cms->config['assume_mod_rewrite'] == true)
                {
                        if ($set_id != 0)
                        {
                                $url .= "/" . $set_id;
                                if ($pic_id != 0) 
                                {
                                        $url .= "/" . $pic_id;
                                }
                        }
                }
                else
                {
                        if ($set_id != 0)
                        {
                                $url .= "&amp;set_id=" . $set_id;
                                if ($pic_id != 0) 
                                {
                                        $url .= "&amp;pic_id=" . $pic_id;
                                }
                        }
                }
                if ($index != 0)
                {
                        $url .= "&amp;index=" . $index;
                }
                return $url;
        }
                

        function DisplaySetList($username, $title, $intro)
        {
                // Find the NSID of the username
                $nsid = $this->f->people_findByUsername($username);
                if (!$nsid) {
                        echo "<p>" . $this->Lang('flickrerrorusername', $username) . "</p>\n";
                        return;
                }

                // Get list of photo sets
                $sets = $this->f->photosets_getList($nsid);

                // Slightly alternative way of doing the foreach - this is so that we can obtain
                // a reference to $set and not a copy of $set.
                foreach (array_keys($sets['photoset']) as $key)
                {
                        $set = &$sets['photoset'][$key];
                        $set['url'] = "http://photos" . $set['server'] . ".flickr.com/" . $set['primary'] . "_" . $set['secret'] . "_s.jpg";
                        $set['link'] = $this->GetURL($set['id']);
                }

                // Assign variables to Smarty and process template
                $this->smarty->assign_by_ref('setlist', $sets['photoset']);
                $this->smarty->assign('title', $title);
                $this->smarty->assign('intro', $intro);
                echo $this->ProcessTemplate($this->setlist_template);
        }

        function DisplaySet($set_id)
        {
                // Description of set
                $setinfo = $this->f->photosets_getInfo($set_id);
                if (!$setinfo) {
                        echo "<p>" . $this->Lang('flickrerrorset', $set_id) . "</p>\n";
                        return;
                }
                $primary = $this->f->photos_getInfo($setinfo['primary']);
                $photos = $this->f->photosets_getPhotos($set_id);

                $this->smarty->assign_by_ref('primary_url', $this->f->buildPhotoURL($primary, "small"));
                $this->smarty->assign_by_ref('primary_link', $this->GetURL($set_id, $setinfo['primary']));
                $this->smarty->assign_by_ref('set', $setinfo);
   
                if ((isset($_GET['index'])) && ($_GET['index'] != ""))
                {
                        $start_index = $_GET['index'];
                }
                else
                {
                        $start_index = 1;
                }

                // Loop through the photos and output images with links
                $photo_list = array();

                $index = 1;
                $last_index = count($photos['photo']);
                foreach ($photos['photo'] as $photo) 
                {
                        if (($index >= $start_index) && ($index < $start_index + $this->photos_per_page))
                        {
                                $photo = $this->f->photos_getInfo($photo['id']);
                                $photo['url'] = $this->f->buildPhotoURL($photo, "square");
                                $photo['link'] = $this->GetURL($set_id, $photo['id']);
                                array_push($photo_list, $photo);
                        }
                        $index++;
                }
                $navi['current'] = ($start_index) . " - " . 
                                   ($start_index+$this->photos_per_page<=$last_index?$start_index+$this->photos_per_page-1:$last_index);
                $navi['first'] = $this->GetURL($set_id);
                $navi['last'] = $this->GetURL($set_id, 0, floor($last_index / $this->photos_per_page) * $this->photos_per_page + 1);
                if ($start_index - $this->photos_per_page > 0) 
                {
                        $navi['prev'] = $this->GetURL($set_id, 0, $start_index-$this->photos_per_page);
                }
                else
                {
                        $navi['prev'] = $this->GetURL($set_id);
                }
                if ($start_index + $this->photos_per_page <= $last_index) 
                {
                        $navi['next'] = $this->GetURL($set_id, 0, $start_index+$this->photos_per_page);
                }
                else 
                {
                        $navi['next'] = $this->GetURL($set_id, 0, $start_index);
                }
                $this->smarty->assign_by_ref('navi', $navi);

                $this->smarty->assign_by_ref('photolist', $photo_list);
                echo $this->ProcessTemplate($this->set_template);
        }

        function DisplayPicture($username, $set_id, $pic_id)
        {
                // Find the NSID of the username
                $nsid = $this->f->people_findByUsername($username); 
                if (!$nsid) {
                        echo "<p>" . $this->Lang('flickrerrorusername', $username) . "</p>\n";
                        return;
                }
              
                // Get info about next and previous photos
                $context = $this->f->photosets_getContext($pic_id, $set_id);

                // Gather info about previous photo in list
                if ($context['prevphoto']['id'] != 0)
                {
                        $prevphoto = $this->f->photos_getInfo($context['prevphoto']['id']);
                        $prevphoto['link'] = $this->GetURL($set_id, $prevphoto['id']);
                        $prevphoto['url'] = $this->f->buildPhotoURL($prevphoto, "square");
                        $prevphoto['text'] = $this->Lang('prevphoto');
                }
                $this->smarty->assign_by_ref('prevphoto', $prevphoto);

                // Gather info about next photo in list
                if ($context['nextphoto']['id'] != 0)
                {
                        $nextphoto = $this->f->photos_getInfo($context['nextphoto']['id']);
                        $nextphoto['link'] = $this->GetURL($set_id, $nextphoto['id']);
                        $nextphoto['url'] = $this->f->buildPhotoURL($nextphoto, "square");
                        $nextphoto['text'] = $this->Lang('nextphoto');
                }
                $this->smarty->assign_by_ref('nextphoto', $nextphoto);

                // Get info about current photo
                $photo = $this->f->photos_getInfo($pic_id);
                if (!$photo) {
                        echo "<p>" . $this->Lang('flickrerrorphoto', $pic_id) . "</p>\n";
                        return;
                }

                // Save info in $photoinfo array
                $photoinfo['posted'] = $this->Lang('published') . " " . strftime("%d %b, %Y", $photo['dates']['posted']);
                if ($photo['dates']['taken'] != "") 
                {
                        list($year,$month,$day,$hour,$minute,$second) = sscanf($photo['dates']['taken'],"%4s-%2s-%2s %2s:%2s:%2s");
                        $photoinfo['taken'] = $this->Lang('taken') . " " . strftime("%d %b, %Y", mktime($hour,$minute,$second,$month,$day,$year));
                }
                $photoinfo['flickr_link'] = '<a href="http://flickr.com/photos/'. $nsid . '/' . $pic_id . '">' . $this->Lang('atflickr') . '</a><br />';
                $this->smarty->assign_by_ref('photoinfo', $photoinfo);

                // Necessary because Flickr encodes & &amp;, even when used in
                // non-ascii characters such as &aring;.
                $photo['description'] = html_entity_decode($photo['description']);
                $photo['url'] = $this->f->buildPhotoURL($photo, "medium");
                $this->smarty->assign_by_ref('photo', $photo);

                $this->smarty->assign_by_ref('firstphoto', $this->Lang('firstphoto'));
                $this->smarty->assign_by_ref('lastphoto', $this->Lang('lastphoto'));

                echo $this->ProcessTemplate($this->photo_template);
        }

        function DisplayBreadcrumbs($set_id, $pic_id)
        {
                $html = "<div id=\"breadcrumbs\">";
                if ($this->breadcrumbs_initial)
                {
                        $html .= $this->breadcrumbs_delimiter . " ";
                }
                if ($this->breadcrumbs_root != "") 
                {
        		if (strtolower($this->PageAlias()) != strtolower($this->breadcrumbs_root))
	        	{
		        	$rootcontent = ContentManager::LoadContentFromAlias($this->breadcrumbs_root, false);
			        if ($rootcontent) 
        			{
	        			$html .= "<a href=\"".$rootcontent->getURL()."\">".$rootcontent->MenuText()."</a> ".$this->breadcrumbs_delimiter." ";
		        	}
        		}
                }
                if ($set_id == 0) 
                {
                        $html .= "<strong>" . $this->PageName() . "</strong>";
                } 
                else 
                {
                        $setinfo = $this->f->photosets_getInfo($set_id);
                        $html .= '<a href="' . $this->GetURL() . '">' . $this->PageName() . '</a> ';
                        if ($pic_id == 0) 
                        {
                                $html .= $this->breadcrumbs_delimiter . " <strong>" . $setinfo['title'] . "</strong> ";
                        } 
                        else
                        {
                                $html .= $this->breadcrumbs_delimiter . ' <a href="' . $this->GetURL($set_id) . '">' . $setinfo['title'] . '</a> ';
                                if ($pic_id != 0) 
                                {
                                        $photo = $this->f->photos_getInfo($pic_id);
                                        $html .= $this->breadcrumbs_delimiter . " <strong>" . $photo['title'] . "</strong>";
                                }
                        }
                }
                $html .= "</div>";
                echo $html;
        }

        function DisplayModuleOutput($id, &$params, $returnid)
        {
               	global $gCms; 

                echo "\n<!-- Flickr  start -->\n";
                $starttime = microtime();

                // Check for required parameters. Print error message and 
                // return if they do not exist.
                if (!isset($params['username']))
                {
                        echo "<p>" . $this->Lang('errorusername') . "</p>\n";
                        return;
                }
                if ($this->GetPreference("api_key") == "")
                {
                        echo "<p>" . $this->Lang('errorapikey') . "</p>\n";
                        return;
                }

                if ((isset($params['breadcrumbs'])) && ($params['breadcrumbs'] == "1"))
                {
                        $this->breadcrumbs = true;
                        if ((isset($params['delimiter'])) && ($params['delimiter'] != ""))
                        {
                                $this->breadcrumbs_delimiter = $params['delimiter'];
                        }
                        if ((isset($params['initial'])) && ($params['initial'] == "1"))
                        {
                                $this->breadcrumbs_initial = true;
                        }
                        if (isset($params['root'])) 
                        {
                                $this->breadcrumbs_root = $params['root'];
                        }
                }

                // Check for optional parameters. Update default values
                // if they are set
                if ((isset($params['setlist_template'])) && ($params['setlist_template'] != ""))
                {
                        $this->setlist_template = $params['setlist_template'];
                }
                if ((isset($params['set_template'])) && ($params['set_template'] != ""))
                {
                        $this->set_template = $params['set_template'];
                }
                if ((isset($params['photo_template'])) && ($params['photo_template'] != ""))
                {
                        $this->photo_template = $params['photo_template'];
                }
                if ((isset($params['photos_per_page'])) && ($params['photos_per_page'] != ""))
                {
                        $this->photos_per_page = $params['photos_per_page'];
                }

                // Create phpFlickr object if it does not already exist
                if ($this->f == null) 
                {
                        $starttime1 = microtime();

                        // Create Flickr object
                        $this->f = new phpFlickr($this->GetPreference('api_key'), NULL, false);

                        // Enable caching
                        if ($this->GetPreference("cache_time") != 0)
                        {
                                $dsn = $gCms->config['dbms'] . "://" . $gCms->config['db_username'] . ":" . $gCms->config['db_password'] . 
                                       "@" . $gCms->config['db_hostname'] . "/" . $gCms->config['db_name'];
                                $this->f->enableCache("db", $dsn, $this->GetPreference("cache_time"), $this->cache_table);
                        }
                        $endtime1 = microtime();
                        echo "\n<!-- phpFlickr object startup time: ".microtime_diff($starttime1,$endtime1)." seconds -->\n";
                }

                $pic_id = $_GET['pic_id'];
                $set_id = $_GET['set_id'];

                // If the breadcrumbs parameter is specified, the module will only
                // return a breadcrumbs-like path to the current page page.
                if ($this->breadcrumbs) 
                {
                        $this->DisplayBreadcrumbs($set_id, $pic_id);
                }
                else
                {
                        if (($pic_id != 0) && ($set_id != 0)) 
                        {
                                // Display single photo
                                $this->DisplayPicture($params['username'], $set_id, $pic_id);
                        } 
                        else if ($set_id != 0) 
                        {
                                // Display single set
                                $this->DisplaySet($set_id);
                        } 
                        else 
                        {
                                // Display list of sets
                                $this->DisplaySetList($params['username'], $params['title'], $params['intro']);
                        }
                }

                $endtime = microtime();
                echo "\n<!-- Flickr end - page generated in ".microtime_diff($starttime,$endtime)." seconds -->\n";
        }

        function DisplayErrorPage($id, &$params, $returnid, $message='')
        {
                echo "<h3>Error</h3>";
		if ($message != '')
		{
			echo "<p>" . $message . "</p>";
		}
        }   

        function ClearCache()
        {
               	global $gCms; 

                require_once "phpFlickr/PEAR/DB.php";
                require_once "phpFlickr/PEAR/PEAR.php";

                $dsn = $gCms->config['dbms'] . "://" . $gCms->config['db_username'] . ":" . $gCms->config['db_password'] . 
                       "@" . $gCms->config['db_hostname'] . "/" . $gCms->config['db_name'];
                $db =& DB::connect($dsn);
                if (PEAR::isError($db)) {
                        die($db->getMessage());
                }
                $db->query("TRUNCATE TABLE $this->cache_table");
                echo "<p>Cache cleared!</p>";
        }

        function GetFlickrUsernames()
        {
               	global $gCms; 

                require_once "phpFlickr/PEAR/DB.php";
                require_once "phpFlickr/PEAR/PEAR.php";

                $dsn = $gCms->config['dbms'] . "://" . $gCms->config['db_username'] . ":" . $gCms->config['db_password'] . 
                       "@" . $gCms->config['db_hostname'] . "/" . $gCms->config['db_name'];
                $db =& DB::connect($dsn);
                if (PEAR::isError($db)) {
                        die($db->getMessage());
                }
                $list = $db->getAll("SELECT content FROM `cms_content_props`");

                $usernames = array();
        	foreach ($list as $item)
                {
                        $content = $item[0];
                        $result = preg_match('/\{\s*cms_module\s+module\s*=\s*["\']flickr["\']\s+.*username\s*=\s*["\'](.*?)["\'].*?\}/si', $content, $matches);
                        if (($result) && (count($matches[1])))
                        {
                                $usernames[] = $matches[1];
                        }
                }
                return array_unique($usernames);
        }

        function DisplayAdminPanel($id, &$params, $returnid, $message='')
        {

               	global $gCms; 

        	if (!$this->CheckPermission('Modify Site Preferences'))
		{
			echo '<p class="error">'.$this->Lang('needpermission', array('Modify Site Preferences')).'</p>';
			return;
	        }

                if (isset($params['clearcache']))
                {
                        $this->ClearCache();
                }
                else if (isset($params['save']))
                {
                        if ((isset($_REQUEST[$id.'api_key'])) && ($_REQUEST[$id.'api_key'] != ""))
                        {
                                $this->SetPreference("api_key", $_REQUEST[$id.'api_key']);
                        }
                        if ((isset($_REQUEST[$id.'cache_time'])) && ($_REQUEST[$id.'cache_time'] != ""))
                        {
                                $this->SetPreference("cache_time", $_REQUEST[$id.'cache_time']);                                
                        }
                }

		if ($message != '')
        	{
			echo "<p>" . $message . "</p>";
		}

                echo "<h3>" . $this->Lang('preferences') . "</h3>";
       		echo $this->CreateFormStart($id, 'defaultadmin', $returnid);
                echo "<div class=\"pageoverflow\">";
                echo "<p class=\"pagetext\">" . $this->Lang('enterapikey') . ":</p>";
                echo "<p class=\"pageinput\">";
                echo $this->CreateInputText($id, "api_key", $this->GetPreference("api_key"), 40) . "</p>";
                echo "</div>";
                echo "<div class=\"pageoverflow\">";
                echo "<p class=\"pagetext\">" . $this->Lang('cachetime') . ":</p>";
                echo "<p class=\"pageinput\">";
                echo $this->CreateInputText($id, "cache_time", $this->GetPreference("cache_time"), 10) . "</p>";
                echo "</div>";
                echo "<div class=\"pageoverflow\">";
                echo "<p class=\"pagetext\">&nbsp;</p>";
                echo "<p class=\"pageinput\">";
                echo $this->CreateInputSubmit($id, 'save', $this->Lang('savepreferences')) . "</p>";
                echo "</div>";
		echo $this->CreateFormEnd();

    		echo $this->CreateFormStart($id, 'defaultadmin', $returnid);
                echo "<h3>" . $this->Lang('clearcache') . "</h3>";
                echo "<p>" . $this->Lang('clearcachedescription') . "<br />&nbsp;</p>";
     		echo $this->CreateInputSubmit($id, 'clearcache', $this->Lang('clearcache'));
        	echo $this->CreateFormEnd();

             	echo $this->CreateFormStart($id, 'defaultadmin', $returnid);
                echo "<h3>" . $this->Lang('refreshcache') . "</h3>";
                echo "<p>" . $this->Lang('refreshcachedescription') . "<br />&nbsp;</p>";
                echo "<p>" . $this->Lang('foundusernames') . ": <b>" . implode(", ", $this->GetFlickrUsernames()) . "</b><br />&nbsp;</p>";
                $rebuild_url = $gCms->config['root_url'] . "/modules/Flickr/rebuildcache.php" 
                              . "?api_key=" . $this->GetPreference("api_key") 
                              . "&amp;dbms=" . $gCms->config['dbms']
                              . "&amp;dbuser=" . $gCms->config['db_username']
                              . "&amp;dbpass=" . $gCms->config['db_password']
                              . "&amp;dbhost=" . $gCms->config['db_hostname']
                              . "&amp;dbname=" . $gCms->config['db_name']
                              . "&amp;cachetable=" . $this->cache_table
                              . "&amp;usernames=" . urlencode(implode(",", $this->GetFlickrUsernames()));
                $javascript = "onClick=\"window.open('" . $rebuild_url . "','mywindow','width=600,height=400,toolbar=no,location=no," . 
                              "directories=no,status=yes,menubar=no,scrollbars=no,copyhistory=no,resizable=no')\"";
        	echo $this->CreateInputSubmit($id, 'refreshcache', $this->Lang('refreshcache'), $javascript);
	        echo $this->CreateFormEnd();

                if ($this->GetPreference("api_key") != "") 
                {
                        echo "<h3>" . $this->Lang('rebuildexternaltitle') . "</h3>";
                        echo "<p>" . $this->Lang('rebuildexternaldescription');
                        echo " <a href=\"" . $rebuild_url . "\">" . $this->Lang('rebuildexternallinktitle') . "</a></p>";
                }
        }
}
?>
