<?php
#-------------------------------------------------------------------------
# Module: Flickr - CMS module for a flickr.com based gallery
# Version: 0.5, Allan Larsen <cms@bogong.dk>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

set_include_path(dirname(__FILE__).'/phpFlickr' . PATH_SEPARATOR . get_include_path());
require_once("phpFlickr/phpFlickr.php");
require_once("phpFlickr/PEAR/PEAR.php");
require_once("phpFlickr/PEAR/DB.php");

if (!isset($_GET['api_key']))
{
        die("No API key specified");
}
if (!isset($_GET['dbms']))
{
        die("No database type specified");
}
if (!isset($_GET['dbuser']))
{
        die("No database username specified");
}
if (!isset($_GET['dbpass']))
{
        die("No database password specified");
}
if (!isset($_GET['dbhost']))
{
        die("No database hostname specified");
}
if (!isset($_GET['dbname']))
{
        die("No database name specified");
}
if (!isset($_GET['cachetable']))
{
        die("No cache table specified");
}
if (!isset($_GET['usernames']))
{
        die("No usernames specified");
}
$api_key = $_GET['api_key'];
$dbms = $_GET['dbms'];
$dbuser = $_GET['dbuser'];
$dbpass = $_GET['dbpass'];
$dbhost = $_GET['dbhost'];
$dbname = $_GET['dbname'];
$cachetable = $_GET['cachetable'];
$cachetime = 3600;
$usernames = split(",", $_GET['usernames']);

ob_start();

?>
<html>
<head>
<title>Updating Flickr cache</title>
<link rel="stylesheet" href="/admin/themes/default/css/style.css" />
</head>
<body>
<div class="pagecontainer"><div class="pageoverflow">
<h2>Updating gallery cache</h2>
<p>The Flickr cache will now be updated with the newest info from Flickr.com. Note that it may take a while.
<b>Do not close this window until it says that the update is complete.</b></p>


<?php
ob_flush(); flush();



//
// Clear database cache
// 
echo "<h3>Clearing cache</h3>";
$dsn = $dbms . "://" . $dbuser . ":" . $dbpass . "@" . $dbhost . "/" . $dbname;
$db =& DB::connect($dsn);
if (PEAR::isError($db)) 
{
        die($db->getMessage());
}
$db->query("TRUNCATE TABLE $cachetable");
echo "<p>Cache cleared!</p>";
ob_flush(); flush();


//
// Rebuild cache from flickr.com
// 
echo "<h3>Rebuilding cache</h3>";
$f = new phpFlickr($api_key);
$f->enableCache("db", "$dsn", $cachetime, $cachetable);

foreach ($usernames as $username)
{
        echo "<p>Updating cache for username \"" . $username . "\"</p>";
        ob_flush(); flush();

        // Find the NSID of the username 
        $nsid = $f->people_findByUsername($username);

        // Get sets
        $sets = $f->photosets_getList($nsid);

        // Iterate over sets
        foreach ($sets['photoset'] as $set)
        {
//                 $photo = $f->photos_getInfo($set['primary']);
                $photos = $f->photosets_getPhotos($set['id']);
                echo "<p>Updating cache for: " . $set['title'];
                echo " (" . count($photos['photo']) . " photos): ";
                ob_flush(); flush();
                foreach ($photos['photo'] as $photo) 
                {
                        echo ". ";
                        ob_flush(); flush();
                        $photo = $f->photos_getInfo($photo['id']);
                        $context = $f->photosets_getContext($photo['id'],$set['id']);
//                         if ($context['prevphoto']['id'] != 0) 
//                         {
//                                 $prevphoto = $f->photos_getInfo($context['prevphoto']['id']);
//                         }
//                         if ($context['nextphoto']['id'] != 0) 
//                         {
//                                 $nextphoto = $f->photos_getInfo($context['nextphoto']['id']);
//                         }
                }
                echo " Done!</p>\n";
                ob_flush(); flush();
        }
}
ob_end_flush();

?>

<p><br /><b>Flickr cache is now updated! You may now close this window</b></p>
</div></div>
</body>
</html>
