<?php
# Team Sport Scores. A module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown <duketown@mantox.nl>
#
# This function allows the administrator to change association information
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/teamsportscores
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

if (!isset($gCms)) exit;

$detailpage = '';
if (isset($params['detailpage']))
  {
    $manager =& $gCms->GetHierarchyManager();
    $node =& $manager->sureGetNodeByAlias($params['detailpage']);
    if (isset($node))
      {
	$content =& $node->GetContent();
	if (isset($content))
	  {
	    $detailpage = $content->Id();
	  }
      }
    else
      {
	$node =& $manager->sureGetNodeById($params['detailpage']);
	if (isset($node))
	  {
	    $detailpage = $params['detailpage'];
	  }
      }
  }


if (!$this->CheckPermission('Modify TeamSportScores'))
  {
	echo $this->ShowErrors($this->Lang('needpermission', array('Modify TeamSportScores')));
    return;
  }

if (isset($params['cancel']))
  {
	$params = array('active_tab' => 'associations');
	$this->Redirect($id, 'defaultadmin', $returnid, $params);
  }

$association_id = '';
if (isset($params['association_id']))
  {
    $association_id = $params['association_id'];
  }

$origdesc = '';
if (isset($params['origdesc']))
  {
    $origdesc = $params['origdesc'];
  }

$description = '';
if (isset($params['description']))
  {
    $description = $params['description'];
    if ($description != '')
      {

	$query = 'UPDATE '.cms_db_prefix().'module_tss_association SET description = ?, modified_date = '.$db->DBTimeStamp(time()).' WHERE association_id = ?';
	$db->Execute($query, array($description, $association_id));

	@$this->SendEvent('AssociationEdited', array('association_id' => $association_id, 'description' => $description, 'origdesc' => $origdesc));

	$params = array('tab_message'=> 'associationupdated', 'active_tab' => 'associations');
	$this->Redirect($id, 'defaultadmin', $returnid, $params);
      }
    else
      {
		echo $this->ShowErrors($this->Lang('noassociationdescgiven'));
      }
  }
 else
   {
     $query = 'SELECT * FROM '.cms_db_prefix().'module_tss_association WHERE association_id = ?';
     $row = $db->GetRow($query, array($association_id));

     if ($row)
       {
	 $description = $row['description'];
       }
   }

#Display template
$this->smarty->assign('startform', $this->CreateFormStart($id, 'editassociation', $returnid));
$this->smarty->assign('endform', $this->CreateFormEnd());
$this->smarty->assign('nametext', $this->Lang('associationdescription'));
$this->smarty->assign('inputname', $this->CreateInputText($id, 'description', $description, 40, 40));
$this->smarty->assign('hidden',
		      $this->CreateInputHidden($id, 'association_id', $association_id).
		      $this->CreateInputHidden($id, 'origdesc', $description));
$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));
$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));
echo $this->ProcessTemplate('editassociation.tpl');
?>
