<?php
#CMS - CMS Made Simple
#(c)2004-6 by Ted Kulp (ted@cmsmadesimple.org)
#This project's homepage is: http://cmsmadesimple.org
#
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#$Id$

if (!isset($gCms)) exit;

#The tabs
echo $this->StartTabHeaders();

if (FALSE == empty($params['active_tab']))
{
	$tab = $params['active_tab'];
}
else
{
	$tab = '';
}

if ($this->CheckPermission('Modify Templates'))
{
	echo $this->SetTabHeader('summary_template',$this->Lang('summarytemplate'), ('summary_template' == $tab)?true:false);
	echo $this->SetTabHeader('detail_template',$this->Lang('detailtemplate'), ('detail_template' == $tab)?true:false);
}

if ($this->CheckPermission('Modify Site Preferences'))
{
	echo $this->SetTabHeader('options',$this->Lang('options'), ('options' == $tab)?true:false);
}

echo $this->EndTabHeaders();

#The content of the tabs
echo $this->StartTabContent();
if( $this->CheckPermission( 'Modify Templates' ) )
{
	echo $this->StartTab('summary_template', $params);
	
	echo $this->CreateFormStart($id, 'updatesummarytemplate');
	
	echo '<p>'.$this->CreateTextArea(false, $id, $this->GetTemplate('displaysummary'), 'templatecontent', 'pagebigtextarea').'</p>';
	
	echo $this->CreateInputSubmit($id, 'submitbutton', $this->Lang('submit'));
	echo $this->CreateInputSubmit($id, 'defaultsbutton', $this->Lang('sysdefaults'), '', '', $this->Lang('restoretodefaultsmsg'));
	
	echo $this->CreateFormEnd();
	
	echo $this->EndTab();
	
	echo $this->StartTab('detail_template', $params);
	
	echo $this->CreateFormStart($id, 'updatedetailtemplate');
	
	echo '<p>'.$this->CreateTextArea(false, $id, $this->GetTemplate('displaydetail'), 'templatecontent2', 'pagebigtextarea').'</p>';
	
	echo $this->CreateInputSubmit($id, 'rsssubmitbutton', $this->Lang('submit'));
	echo $this->CreateInputSubmit($id, 'defaultsbutton', $this->Lang('sysdefaults'), '', '', $this->Lang('restoretodefaultsmsg'));
	
	echo $this->CreateFormEnd();
	
	echo $this->EndTab();
}

if ($this->CheckPermission('Modify Site Preferences'))
{
	echo $this->StartTab('options', $params);

	echo $this->CreateFormStart($id, 'updateoptions');

	echo '<p>' . $this->Lang('pagesize') . ': ' . $this->CreateInputText($id, 'pagesize',  $this->GetPreference('pagesize', 10), 5, 10) . '</p>';
	
	echo '<p>' . $this->Lang('imageprop') . ': ' . $this->CreateInputText($id, 'imageprop',  $this->GetPreference('imageprop', 'faceimage'), 10, 30) . '</p>';

	echo '<p>' . $this->Lang('lookup') . ': ' . $this->CreateInputText($id, 'lookup',  $this->GetPreference('lookup', 'lastname'), 10, 30) . '</p>';

	echo '<p>' . $this->Lang('notfound') . ': ' . $this->CreateInputText($id, 'notfound',  $this->GetPreference('notfound', 'uploads/feusers/notfound.jpg'), 25, 255) . '</p>';	
	
	echo $this->CreateInputSubmit($id, 'optionssubmitbutton', $this->Lang('submit'));
	
	echo $this->CreateFormEnd();
	
	echo $this->EndTab();
}

echo $this->EndTabContent();

# vim:ts=4 sw=4 noet
?>