<?php
#CMS - CMS Made Simple
#(c)2004-6 by Ted Kulp (ted@cmsmadesimple.org)
#This project's homepage is: http://cmsmadesimple.org
#
#This program is free software; you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation; either version 2 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#$Id$

class UserDirectory extends CMSModule
{
	function GetName()
	{
		return 'UserDirectory';
	}

	function GetFriendlyName()
	{
		return $this->Lang('userdirectory');
	}

	function IsPluginModule()
	{
		return true;
	}

	function HasAdmin()
	{
		return true;
	}

	function HandlesEvents()
	{
		//return true;
	}

	function GetVersion()
	{
		return '1.0-svn';
	}

	function MinimumCMSVersion()
	{
		return '1.0.4';
	}

	function GetAdminDescription()
	{
		return $this->Lang('description');
	}

	function VisibleToAdminUser()
	{
		return true;
	}

	function SetParameters()
	{
	}

	function GetHelp($lang='en_US')
	{
		return $this->Lang('help');
	}

	function GetAuthor()
	{
		return 'Ted Kulp';
	}

	function GetAuthorEmail()
	{
		return 'ted@cmsmadesimple.org';
	}

	function GetDependencies()
	{
		return array('FrontEndUsers' => '1.1.2');
	}

	function GetChangeLog()
	{
		return $this->Lang('changelog');
	}

	function GetEventDescription( $eventname )
	{
		return $this->lang('eventdesc-' . $eventname);
	}

	function GetEventHelp( $eventname )
	{
		return $this->lang('eventhelp-' . $eventname);
	}

	function GetSummaryHtmlTemplate()
	{
		return '{if $firstletterlist ne \'\'}
{$firstletterlist}<br /><br />
{/if}

{foreach from=$users item=entry}
<div class="UserDirectoryItem">

<h3><a href="{$entry.detailurl}">{$entry.properties.firstname} {$entry.properties.lastname}</a></h3>

{if isset($entry.properties.faceimage)}
<img src="{$entry.properties.faceimage}" />
{/if}

{if isset($user.properties.phone)}
<p>Phone: {$user.properties.phone}</p>
{/if}

{if isset($entry.properties.email)}
<a href="mailto:{$entry.properties.email|escape:\'hexentity\'}" />Email Me</a>
{/if}

</div>
{/foreach}

{$prevlink}{$nextlink}
';
	}

	function GetDetailHtmlTemplate()
	{
		return '<div class="UserDirectoryItem">

<h3>{$user.properties.firstname} {$user.properties.lastname}</h3>

{if isset($user.properties.faceimage)}
<img src="{$user.properties.faceimage}" />
{/if}

{if isset($user.properties.phone)}
<p>Phone: {$user.properties.phone}</p>
{/if}

{if isset($user.properties.email)}
<a href="mailto:{$user.properties.email|escape:\'hexentity\'}">Email Me</a>
{/if}

</div>
';
	}
	
	function GetDefinitionType(&$types, &$dfns, $name)
	{
		$flipped_types = array_flip($types);
		foreach($dfns as $dfn)
		{
			if ($dfn['name'] == $name)
			{
				if (array_key_exists($dfn['type'], $flipped_types))
				{
					return $flipped_types[$dfn['type']];
				}
			}
		}
		return '';
	}
}

# vim:ts=4 sw=4 noet
?>
