<?php
# Team Sport Scores. A module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown <duketown@mantox.nl>
#
# This function will handle the back end information for Team Sport Scores
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/teamsportscores
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

if (!isset($gCms)) exit;

#The tabs
echo $this->StartTabHeaders();
if (FALSE == empty($params['active_tab']))
{
	$tab = $params['active_tab'];
} else {
	$tab = '';
}

if (! $this->CheckPermission('Use TeamSportScores'))
	{
	return $this->DisplayErrorPage($id, $params, $returnid,$this->Lang('accessdenied'));
	}

$this->DisplayAdminNav($id, $params, $returnid);

echo $this->SetTabHeader('associations',$this->Lang('associations'), ('associations' == $tab)?true:false);
echo $this->SetTabHeader('clubs',$this->Lang('clubs'), ('clubs' == $tab)?true:false);
echo $this->SetTabHeader('teams',$this->Lang('teams'), ('teams' == $tab)?true:false);
echo $this->SetTabHeader('matches',$this->Lang('matches'), ('matches' == $tab)?true:false);
echo $this->SetTabHeader('seasons',$this->Lang('seasons'), ('seasons' == $tab)?true:false);
echo $this->SetTabHeader('templates',$this->Lang('templates'), ('templates' == $tab)?true:false);
echo $this->EndTabHeaders();

# The content of the tabs
echo $this->StartTabContent();
if ($this->CheckPermission('Use TeamSportScores'))
{
	// --- Start tab Associations ---
	echo $this->StartTab('associations', $params);

	$curassociation = (isset($params['curassociation'])?$params['curassociation']:'');
	$allassociations = (isset($params['allassociations'])?$params['allassociations']:'no');
	$newassociation = $curassociation;

	if (isset($params['submitassociation']))
	{
		$newassociation = (isset($params['newassociation'])?$params['newassociation']:$newassociation);
	}

	$curassociation = $newassociation;
	$listassociation = array();
	$listassociation[$this->Lang('allassociation')] = '';
	$query = "SELECT * FROM ".cms_db_prefix()."module_tss_association ORDER BY description";
	$dbresult = $db->Execute($query);

	$rowclass = 'row1';

	while ($dbresult && $row = $dbresult->FetchRow())
	{
		$onerow = new stdClass();

		$onerow->id = $row['association_id'];
		$onerow->description = $this->CreateLink($id, 'editassociation', $returnid, $row['description'], array('association_id'=>$row['association_id']));
		/* Show the icons needed for editing, deleting */
		$onerow->editlink = $this->CreateLink($id, 'editassociation', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('edit'),'','','systemicon'), array('association_id'=>$row['association_id']));
		$onerow->deletelink = $this->CreateLink($id, 'deleteassociation', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'),'','','systemicon'), array('association_id'=>$row['association_id']), $this->Lang('areyousureassociation'));

		$onerow->rowclass = $rowclass;

		$entryarray[] = $onerow;

		($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
	}
	$this->smarty->assign_by_ref('items', $entryarray);
	$this->smarty->assign('itemcount', count($entryarray));

	#Setup links
	$this->smarty->assign('addassociationlink', $this->CreateLink($id, 'addassociation', $returnid, $this->Lang('addassociation'), array(), '', false, false, 'class="pageoptions"'));
	$this->smarty->assign('addassociationlink', $this->CreateLink($id, 'addassociation', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('addassociation'),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'addassociation', $returnid, $this->Lang('addassociation'), array(), '', false, false, 'class="pageoptions"'));

	$this->smarty->assign('associationtext', $this->Lang('association'));

	#Display template
	echo $this->ProcessTemplate('listassociation.tpl');

	echo $this->EndTab();

	#--- End tab Associations ---

	// --- Start tab Clubs ---
	echo $this->StartTab('clubs', $params);

	$curclub = (isset($params['curclub'])?$params['curclub']:'');
	$allclubs = (isset($params['allclubs'])?$params['allclubs']:'no');
	$newclub = $curclub;

	if (isset($params['submitclub']))
	{
		$newclub = (isset($params['newclub'])?$params['newclub']:$newclub);
	}

	$query = '';
	$dbresult = '';

	$curclub = $newclub;
	$listclub = array();
	$listclub[$this->Lang('allclub')] = '';

	$query = "SELECT c.*, a.description AS ass_desc FROM ".cms_db_prefix()."module_tss_club c LEFT OUTER JOIN ".cms_db_prefix()."module_tss_association a ON c.association_id = a.association_id ORDER BY c.description";
	$dbresult = $db->Execute($query);

	$rowclass = 'row1';
	$entryarray = array();

	while ($dbresult && $row = $dbresult->FetchRow())
	{
		$onerow = new stdClass();

		$onerow->id = $row['club_id'];
		$onerow->description = $this->CreateLink($id, 'editclub', $returnid, $row['description'], array('club_id'=>$row['club_id']));
		if ($row['association_id'] > 0) {
				$onerow->association = $row['ass_desc'];
		} else {
				$onerow->association = 'Unknown';
		}
		if ($row['status'] == 'A')
			{
				$onerow->statuslink = $this->CreateLink($id, 'switchstatus', $returnid, 
					$gCms->variables['admintheme']->DisplayImage('icons/system/true.gif',$this->Lang('setinactive'),'','','systemicon'),array('active'=>'I','record_id'=>$row['club_id']));
			}
		else
			{
				$onerow->statuslink = $this->CreateLink($id,'switchstatus', $returnid, 
					$gCms->variables['admintheme']->DisplayImage('icons/system/false.gif',$this->Lang('setactive'),'','','systemicon'),array('active'=>'A','record_id'=>$row['club_id']));
			}

 		/* Show the icons needed for editing, deleting */
		if ($row['status'] == 'A')
			{
				$onerow->statuslink = $this->CreateLink($id, 'switchstatus', $returnid, 
					$gCms->variables['admintheme']->DisplayImage('icons/system/true.gif',$this->Lang('setinactive'),'','','systemicon'),array('table'=>'Club','status'=>'I','record_id'=>$row['club_id']));
			}
		else
			{
				$onerow->statuslink = $this->CreateLink($id,'switchstatus', $returnid, 
					$gCms->variables['admintheme']->DisplayImage('icons/system/false.gif',$this->Lang('setactive'),'','','systemicon'),array('table'=>'Club','status'=>'A','record_id'=>$row['club_id']));
			}
		$onerow->editlink = $this->CreateLink($id, 'editclub', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('edit'),'','','systemicon'), array('club_id'=>$row['club_id']));
		if ($row['club_id'] > 0 ) {
				$onerow->deletelink = $this->CreateLink($id, 'deleteclub', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'),'','','systemicon'), array('club_id'=>$row['club_id']), $this->Lang('areyousureclub'));
	  	}
		$onerow->rowclass = $rowclass;

		$entryarray[] = $onerow;

		($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
	}
	$this->smarty->assign_by_ref('items', $entryarray);
	$this->smarty->assign('itemcount', count($entryarray));

	#Setup links
	$this->smarty->assign('addclublink', $this->CreateLink($id, 'addclub', $returnid, $this->Lang('addclub'), array(), '', false, false, 'class="pageoptions"'));
	$this->smarty->assign('addclublink', $this->CreateLink($id, 'addclub', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('addclub'),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'addclub', $returnid, $this->Lang('addclub'), array(), '', false, false, 'class="pageoptions"'));

	$this->smarty->assign('clubtext', $this->Lang('club'));
	$this->smarty->assign('statustext', $this->Lang('status'));

	#Display template
	echo $this->ProcessTemplate('listclub.tpl');

	echo $this->EndTab();
	#--- End tab Clubs ---
	
	// --- Start tab Teams ---
	echo $this->StartTab('teams', $params);

	$query = '';
	$dbresult = '';

	$curteam = $newteam;
	$listteam = array();
	$listteam[$this->Lang('allteam')] = '';

	$query = "SELECT t.*, c.description AS club_desc, season_desc
				 FROM "
				 			.cms_db_prefix()."module_tss_team t, "
							.cms_db_prefix()."module_tss_club c, "
							.cms_db_prefix()."module_tss_season s
				 WHERE t.club_id = c.club_id AND t.season_id = s.season_id
				 ORDER BY t.team_name";
	$dbresult = $db->Execute($query);

	$rowclass = 'row1';
	$entryarray = array();

	while ($dbresult && $row = $dbresult->FetchRow())
	{
		$onerow = new stdClass();

		$onerow->id = $row['team_id'];
		$onerow->code = $this->CreateLink($id, 'editteam', $returnid, $row['team_code'], array('team_id'=>$row['team_id']));
		$onerow->name = $this->CreateLink($id, 'editteam', $returnid, $row['team_name'], array('team_id'=>$row['team_id']));
		$onerow->season = $row['season_desc'];
		if ($row['club_id'] > 0) {
				$onerow->description = $row['club_desc'];
		} else {
			if ($id == 0) {
				$onerow->description = $this->Lang('clubnotconnected');
			} else {
				$onerow->description = $this->Lang('clubunknown');
			}
		}

 		/* Show the icons needed for editing, deleting */
		if ($row['status'] == 'A')
			{
				$onerow->statuslink = $this->CreateLink($id, 'switchstatus', $returnid, 
					$gCms->variables['admintheme']->DisplayImage('icons/system/true.gif',$this->Lang('setinactive'),'','','systemicon'),array('table'=>'Team','status'=>'I','record_id'=>$row['team_id']));
			}
		else
			{
				$onerow->statuslink = $this->CreateLink($id,'switchstatus', $returnid, 
					$gCms->variables['admintheme']->DisplayImage('icons/system/false.gif',$this->Lang('setactive'),'','','systemicon'),array('table'=>'Team','status'=>'A','record_id'=>$row['team_id']));
			}
		$onerow->editlink = $this->CreateLink($id, 'editteam', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('edit'),'','','systemicon'), array('team_id'=>$row['team_id']));
		if ($row['team_id'] > 0 ) {
			 $onerow->deletelink = $this->CreateLink($id, 'deleteteam', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'),'','','systemicon'), array('team_id'=>$row['team_id']), $this->Lang('areyousureteam'));
		}

		$onerow->rowclass = $rowclass;

		$entryarray[] = $onerow;

		($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
	}
	$this->smarty->assign_by_ref('items', $entryarray);
	$this->smarty->assign('itemcount', count($entryarray));

	#Setup links
	$this->smarty->assign('addteamlink', $this->CreateLink($id, 'addteam', $returnid, $this->Lang('addteam'), array(), '', false, false, 'class="pageoptions"'));
	$this->smarty->assign('addteamlink', $this->CreateLink($id, 'addteam', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('addteam'),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'addteam', $returnid, $this->Lang('addteam'), array(), '', false, false, 'class="pageoptions"'));

	$this->smarty->assign('teamcodetext', $this->Lang('teamcode'));
	$this->smarty->assign('teamtext', $this->Lang('team'));
	$this->smarty->assign('seasontext', $this->Lang('season'));
	$this->smarty->assign('clubtext', $this->Lang('club'));
	$this->smarty->assign('statustext', $this->Lang('status'));

	#Display template
	echo $this->ProcessTemplate('listteam.tpl');

	echo $this->EndTab();
	#--- End tab Teams ---
	
	// --- Start tab Matches ---
	echo $this->StartTab('matches', $params);

	$newhometeam = '';
	$newvisitorteam = '';
	$newfuture = false; // If true only future (non played games) are showed
	$sortby = '';
	/*
	if (isset($params['submitfilter']))
	{
		if (isset($params['newhometeam']))
	  	{
	  	 	 $newhometeam = $params['newhometeam'];
	  	}
		if (isset($params['sortby']))
		{
		 	 $sortby = $params['sortby'];
		}
	}
	*/

	// Prepare the basic statement
	$query = "SELECT * FROM ".cms_db_prefix()."module_tss_gameschedule_score ORDER BY date";
	$dbresult = $db->Execute($query);

	$rowclass = 'row1';
	$entryarray = array();

	while ($dbresult && $row = $dbresult->FetchRow())
	{
		$onerow = new stdClass();

		$onerow->id = $row['gss_id'];
		$onerow->hometeam = $this->CreateLink($id, 'editmatch', $returnid, $row['hometeam'], array('gss_id'=>$row['gss_id']));
		$onerow->visitorteam = $this->CreateLink($id, 'editmatch', $returnid, $row['visitorteam'], array('gss_id'=>$row['gss_id']));
		$onerow->matchdate = $row['date'];
		
		if ($row['hometeam_score'] != NULL) {
			$onerow->match_score = $row['hometeam_score'].' - '.$row['visitorteam_score'];
		}
		else {
			$onerow->match_score = $this->Lang('noscoreavailable');
		}
		/* Show the icons needed for editing, deleting */
		$onerow->editlink = $this->CreateLink($id, 'editmatch', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('edit'),'','','systemicon'), array('gss_id'=>$row['gss_id']));
		$onerow->deletelink = $this->CreateLink($id, 'deletematch', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'),'','','systemicon'), array('gss_id'=>$row['gss_id']), $this->Lang('areyousurematch'));

		$onerow->rowclass = $rowclass;

		$entryarray[] = $onerow;

		($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
	}

	$this->smarty->assign_by_ref('items', $entryarray);
	$this->smarty->assign('itemcount', count($entryarray));

	#Setup links
	$this->smarty->assign('addmatchlink', $this->CreateLink($id, 'addmatch', $returnid, $this->Lang('addmatch'), array(), '', false, false, 'class="pageoptions"'));
	$this->smarty->assign('addmatchlink', $this->CreateLink($id, 'addmatch', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('addjobschedule'),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'addmatch', $returnid, $this->Lang('addmatch'), array(), '', false, false, 'class="pageoptions"'));

	$this->smarty->assign('titlehometeam', $this->Lang('title_hometeam'));
	$this->smarty->assign('titlevisitorteam', $this->Lang('title_visitorteam'));
	$this->smarty->assign('titlematchdate', $this->Lang('title_matchdate'));
	$this->smarty->assign('titlescore', $this->Lang('title_score'));

	#Display template
	echo $this->ProcessTemplate('listmatches.tpl');

	echo $this->EndTab();
	#--- End tab Matches ---
  
	// --- Start tab Seasons ---
	echo $this->StartTab('seasons', $params);

	$query = '';
	$dbresult = '';

	$curseason = (isset($params['curseason'])?$params['curseason']:'');
	$allseasons = (isset($params['allseasons'])?$params['allseasons']:'no');
	$newseason = $curseason;

	if (isset($params['submitseason']))
	{
		$newseason = (isset($params['newseason'])?$params['newseason']:$newseason);
	}

	$curseason = $newseason;
	$listseason = array();
	$listseason[$this->Lang('allseasons')] = '';
	$query = "SELECT * FROM ".cms_db_prefix()."module_tss_season ORDER BY start_date, season_desc";
	$dbresult = $db->Execute($query);

	$rowclass = 'row1';
	$entryarray = array();

	while ($dbresult && $row = $dbresult->FetchRow())
	{
		$onerow = new stdClass();

		$onerow->id = $row['season_id'];
		$onerow->season_desc = $this->CreateLink($id, 'editseason', $returnid, $row['season_desc'], array('season_id'=>$row['season_id']));
		$onerow->start_date = $row['start_date'];
		$onerow->end_date = $row['end_date'];

		/* Show the icons needed for editing, deleting */
		if ($row['status'] == 'A')
			{
				$onerow->statuslink = $this->CreateLink($id, 'switchstatus', $returnid, 
					$gCms->variables['admintheme']->DisplayImage('icons/system/true.gif',$this->Lang('setinactive'),'','','systemicon'),array('table'=>'Season','status'=>'I','record_id'=>$row['season_id']));
			}
		else
			{
				$onerow->statuslink = $this->CreateLink($id,'switchstatus', $returnid, 
					$gCms->variables['admintheme']->DisplayImage('icons/system/false.gif',$this->Lang('setactive'),'','','systemicon'),array('table'=>'Season','status'=>'A','record_id'=>$row['season_id']));
			}
		
		$onerow->editlink = $this->CreateLink($id, 'editseason', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('edit'),'','','systemicon'), array('season_id'=>$row['season_id']));
		if ($row['season_id'] > 0 ) {
				$onerow->deletelink = $this->CreateLink($id, 'deleteseason', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'),'','','systemicon'), array('season_id'=>$row['season_id']), $this->Lang('areyousureseason'));
		}

		$onerow->rowclass = $rowclass;

		$entryarray[] = $onerow;

		($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
	}
	$this->smarty->assign_by_ref('items', $entryarray);
	$this->smarty->assign('itemcount', count($entryarray));

#	echo $this->CreateFormEnd();

	#Setup links
	$this->smarty->assign('addseasonlink', $this->CreateLink($id, 'addseason', $returnid, $this->Lang('addseason'), array(), '', false, false, 'class="pageoptions"'));
	$this->smarty->assign('addseasonlink', $this->CreateLink($id, 'addseason', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('addseason'),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'addseason', $returnid, $this->Lang('addseason'), array(), '', false, false, 'class="pageoptions"'));

	$this->smarty->assign('seasontext', $this->Lang('season'));
	$this->smarty->assign('startdatetext', $this->Lang('seasonstartdate'));
	$this->smarty->assign('enddatetext', $this->Lang('seasonenddate'));

	#Display template
	echo $this->ProcessTemplate('listseason.tpl');

	echo $this->EndTab();
	#--- End tab Seasons ---
  
	// --- Start tab Templates ---
	echo $this->StartTab('templates', $params);
	
	$this->smarty->assign('startform', $this->CreateFormStart ($id, 'save_admin_templates', $returnid));
	$this->smarty->assign('title_summary_template',$this->Lang('title_summary_template'));
	$this->smarty->assign('input_summary_template', $this->CreateTextArea(false,
	  $id, $this->GetTemplate('summary_template', 'TeamSportScores'),
	  'input_summary_template', '','','','',80,25));
	$this->smarty->assign('submittemplates', $this->CreateInputSubmit($id, 'submittemplates', $this->Lang('title_save_templates')));
	$this->smarty->assign('endform', $this->CreateFormEnd ());

	// Display the Admin templates
	echo $this->ProcessTemplate ('admintemplates.tpl');
	echo $this->EndTab();
	#--- End tab Templates ---

  
}
echo $this->EndTabContent();

?>