<?php
# Team Sport Scores. A module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown <duketown@mantox.nl>
#
# This function will show all matches
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/teamsportscores
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$db =& $this->GetDb();

$dateformat = "F j, Y, g:i a";
if (isset($params['dateformat']))
  {
    $dateformat = $params['dateformat'];
  }

$query = "SELECT * FROM ".cms_db_prefix()."module_tss_gameschedule_score ORDER BY date";
$dbresult = $db->Execute($query);

$rowclass = 'row1';

while ($dbresult && $row = $dbresult->FetchRow())
{
	$onerow = new stdClass();

	$onerow->id = $row['gss_id'];
	$onerow->hometeam = $row['hometeam'];
	$onerow->visitorteam = $row['visitorteam'];
	#$onerow->match_date = $row['date'];
	$onerow->match_date = date($dateformat, $db->UnixTimeStamp($row['date']));
	$onerow->location = $row['location'];
	
	if ($row['hometeam_score'] != NULL) {
		$onerow->match_score = $row['hometeam_score'].' - '.$row['visitorteam_score'];
	}
	else {
		$onerow->match_score = $this->Lang('noscoreavailable');
	}

	$onerow->rowclass = $rowclass;

	$entryarray[] = $onerow;

	($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
}

$smarty->assign('itemcount', count($entryarray));
$smarty->assign_by_ref('items', $entryarray);
$smarty->assign('titlehometeam', $this->Lang('title_hometeam'));
$smarty->assign('titlevisitorteam', $this->Lang('title_visitorteam'));
$smarty->assign('titlelocation', $this->Lang('title_location'));
$smarty->assign('titlematchdate', $this->Lang('title_matchdate'));
$smarty->assign('titlescore', $this->Lang('title_score'));

/*
if( $summarytemplatename == '' )
  {
    $summarytemplatename = 'summary'.$this->GetPreference(summary_template);
  }
echo $this->ProcessTemplateFromDatabase($formtemplatename);
*/
echo $this->ProcessTemplateFromDatabase('summary_template','TeamSportScores');

?>